/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.extjs.gxt.ui.client.core.DomQuery;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ListViewEvent;
import com.extjs.gxt.ui.client.util.Format;
import com.extjs.gxt.ui.client.widget.ListView;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.Element;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.util.URL;
import org.jahia.ajax.gwt.client.util.icons.ContentModelIconProvider;

public class ThumbsListView
extends ListView<GWTJahiaNode> {
    private boolean detailed = false;

    public ThumbsListView() {
        this.setItemSelector("div.thumb-wrap");
        this.setOverStyle("x-view-over");
    }

    public ThumbsListView(boolean detailed) {
        this();
        this.detailed = detailed;
        if (detailed) {
            this.setTemplate(this.getDetailedTemplate());
        } else {
            this.setTemplate(this.getSimpleTemplate());
        }
    }

    protected GWTJahiaNode prepareData(GWTJahiaNode model) {
        if (model.getNodeTypes().contains("jmix:markedForDeletion")) {
            model.set("markedForDeletion", "true");
        } else {
            model.set("markedForDeletion", "false");
        }
        model.set("shortName", SafeHtmlUtils.htmlEscape((String)Format.ellipse((String)model.getName(), (int)14)));
        model.set("nameLabel", Messages.get("label.name", "Name"));
        model.set("titleLabel", Messages.get("label.title", "Title"));
        model.set("authorLabel", Messages.get("versioning_author", "Author"));
        model.set("tagsLabel", Messages.get("org.jahia.jcr.edit.tags.tab", "tags"));
        model.set("createdBy", model.get("jcr:createdBy"));
        String width = (String)model.get("j:width");
        if (width != null) {
            if (Integer.parseInt(width) < 80) {
                model.set("nodeImg", "<img src=\"" + URL.appendTimestamp(model.getUrl()) + "\" title=\"" + SafeHtmlUtils.htmlEscape((String)model.getName()) + "\">");
            } else {
                model.set("nodeImg", "<img src=\"" + URL.appendTimestamp(model.getPreview()) + "\" title=\"" + SafeHtmlUtils.htmlEscape((String)model.getName()) + "\">");
            }
            if (this.detailed) {
                model.set("widthHTML", "<div><b>" + Messages.get("width.label", "Width") + " </b>" + model.get("j:width") + " px</div>");
                model.set("heightHTML", "<div><b>" + Messages.get("height.label", "Height") + " </b>" + model.get("j:height") + " px</div>");
            } else {
                model.set("widthAndHeightHTML", model.get("j:width") + " x " + model.get("j:height"));
            }
        } else if (model.getPreview() != null) {
            model.set("nodeImg", "<img src=\"" + URL.appendTimestamp(model.getPreview()) + "\" title=\"" + SafeHtmlUtils.htmlEscape((String)model.getName()) + "\">");
        } else {
            model.set("nodeImg", ContentModelIconProvider.getInstance().getIcon(model, true).getHTML());
        }
        if (model.getTags() != null && model.getTags().length() > 0) {
            model.set("tagsHTML", "<div><b>" + model.get("tagsLabel") + ": </b>" + SafeHtmlUtils.htmlEscape((String)model.getTags()) + "</div>");
        }
        return model;
    }

    protected void onMouseDown(ListViewEvent<GWTJahiaNode> e) {
        super.onMouseDown(e);
        if (e.getIndex() == -1) {
            this.getSelectionModel().select((ModelData)((GWTJahiaNode)null), false);
        }
    }

    public void setContextMenu(Menu menu) {
        super.setContextMenu(menu);
    }

    public void setSize(int thumbnailSize) {
        NodeList imageThumbNails = DomQuery.select((String)"#images-view .thumb");
        for (int i = 0; i < imageThumbNails.getLength(); ++i) {
            Element currentThumbnail = (Element)imageThumbNails.getItem(i);
            currentThumbnail.getStyle().setWidth((double)thumbnailSize, Style.Unit.PX);
            currentThumbnail.getStyle().setHeight((double)thumbnailSize, Style.Unit.PX);
        }
    }

    public native String getSimpleTemplate();

    public native String getDetailedTemplate();
}

