/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content.wizard;

import java.io.Serializable;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.content.wizard.ContentDefinitionCard;
import org.jahia.ajax.gwt.client.widget.content.wizard.ContentFormCard;
import org.jahia.ajax.gwt.client.widget.content.wizard.ContentNameCard;
import org.jahia.ajax.gwt.client.widget.wizard.WizardCard;
import org.jahia.ajax.gwt.client.widget.wizard.WizardWindow;

public class AddContentWizardWindow
extends WizardWindow {
    private AddContentData data;
    private Linker linker;
    private GWTJahiaNode parentNode;

    public AddContentWizardWindow() {
        this(null, null);
    }

    public AddContentWizardWindow(Linker linker, GWTJahiaNode parentNode) {
        this(linker, parentNode, null);
    }

    public AddContentWizardWindow(Linker linker, GWTJahiaNode parentNode, GWTJahiaNodeType nodeType) {
        super(null);
        this.addStyleName("add-content-wizard-window");
        this.data = new AddContentData(nodeType);
        this.parentNode = parentNode;
        this.linker = linker;
        this.createCards();
        this.setSize(650, 460);
    }

    protected void createCards() {
        if (this.data.getNodeType() == null) {
            this.addCard(new ContentDefinitionCard(this.parentNode));
            this.addCard(new ContentNameCard());
            this.addCard(new ContentFormCard());
        } else {
            ContentNameCard contentNameCard = new ContentNameCard();
            this.addCard(contentNameCard);
            this.addCard(new ContentFormCard());
            contentNameCard.createUI();
        }
    }

    @Override
    public String getHeaderTitle() {
        return Messages.get("label.addContent", "Add content");
    }

    public Linker getLinker() {
        return this.linker;
    }

    public GWTJahiaNode getParentNode() {
        return this.parentNode;
    }

    public AddContentData getWizardData() {
        return this.data;
    }

    static abstract class ContentWizardCard
    extends WizardCard {
        public ContentWizardCard(String cardtitle, String text) {
            super(cardtitle, text);
        }

        public AddContentData getWizardData() {
            return this.getWizardWindow().getWizardData();
        }

        @Override
        public AddContentWizardWindow getWizardWindow() {
            return (AddContentWizardWindow)super.getWizardWindow();
        }
    }

    static class AddContentData
    implements Serializable {
        private String nodeName;
        private GWTJahiaNodeType nodeType;

        public AddContentData() {
            this(null);
        }

        public AddContentData(GWTJahiaNodeType nodeType) {
            this.nodeType = nodeType;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public GWTJahiaNodeType getNodeType() {
            return this.nodeType;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public void setNodeType(GWTJahiaNodeType nodeType) {
            this.nodeType = nodeType;
        }
    }
}

