/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.StoreEvent;
import com.extjs.gxt.ui.client.store.StoreListener;
import com.extjs.gxt.ui.client.widget.BoxComponent;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.DualListField;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.layout.FillLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTChoiceListInitializer;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.GWTJahiaValueDisplayBean;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACL;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEngineConfiguration;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.AsyncTabItem;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.contentengine.CheckboxWorkInProgress;
import org.jahia.ajax.gwt.client.widget.contentengine.ContentTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineContainer;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;
import org.jahia.ajax.gwt.client.widget.contentengine.PropertiesTabItem;
import org.jahia.ajax.gwt.client.widget.definition.PropertiesEditor;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.AreaModule;
import org.jahia.ajax.gwt.client.widget.toolbar.action.LanguageSwitcherActionItem;

public abstract class AbstractContentEngine
extends LayoutContainer
implements NodeHolder {
    protected GWTEngineConfiguration config;
    protected Linker linker = null;
    protected List<GWTJahiaNodeType> nodeTypes;
    protected List<GWTJahiaNodeType> mixin;
    protected List<BoxComponent> saveButtons = new ArrayList<BoxComponent>();
    protected Map<String, GWTChoiceListInitializer> choiceListInitializersValues;
    protected Map<String, Map<String, List<GWTJahiaNodePropertyValue>>> defaultValues;
    protected Map<String, GWTJahiaNodeProperty> properties = new HashMap<String, GWTJahiaNodeProperty>();
    protected Map<String, GWTJahiaNodeProperty> presetProperties = new HashMap<String, GWTJahiaNodeProperty>();
    protected TabPanel tabs;
    protected boolean existingNode = true;
    protected GWTJahiaNode node;
    protected String nodeName;
    protected GWTJahiaNode targetNode;
    protected GWTJahiaLanguage currentLanguageBean;
    protected String defaultLanguageCode;
    protected ComboBox<GWTJahiaLanguage> languageSwitcher;
    protected ButtonBar buttonBar;
    protected String heading;
    protected EngineContainer container;
    protected GWTJahiaNodeACL acl;
    protected Map<String, Set<String>> referencesWarnings;
    protected GWTJahiaLanguage language;
    private Map<String, Boolean> workInProgressByLocale = new HashMap<String, Boolean>();
    protected boolean workInProgressCheckedByDefault = false;
    protected boolean closed = false;
    protected final List<GWTJahiaNodeProperty> changedProperties = new ArrayList<GWTJahiaNodeProperty>();
    protected final Map<String, List<GWTJahiaNodeProperty>> changedI18NProperties = new HashMap<String, List<GWTJahiaNodeProperty>>();
    protected String parentPath;

    protected AbstractContentEngine(GWTEngineConfiguration config, Linker linker, String parentPath) {
        this.config = config;
        this.linker = linker;
        this.parentPath = parentPath;
        this.setId("JahiaGxtContentEngine");
    }

    protected void init(EngineContainer container) {
        this.container = container;
        this.setLayout((Layout)new FillLayout());
        this.addStyleName("content-engine");
        this.buttonBar = new ButtonBar();
        this.buttonBar.addStyleName("JahiaEditEngineButtonBar");
        container.setEngine((Component)this, this.heading, this.buttonBar, null, this.getLinker());
        this.initLanguageSwitcher();
        this.tabs = new TabPanel();
        this.tabs.setBodyBorder(false);
        this.tabs.setBorders(true);
        this.add((Component)this.tabs);
        this.buttonBar.setAlignment(Style.HorizontalAlignment.CENTER);
        this.initFooter();
        container.getPanel().setFooter(true);
        this.loading();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public void loaded() {
        this.unmask();
    }

    public void loading() {
        this.mask(Messages.get("label.loading", "Loading..."), "x-mask-loading");
    }

    private void initLanguageSwitcher() {
        this.languageSwitcher = new ComboBox();
        this.languageSwitcher.setStore(new ListStore());
        this.languageSwitcher.setDisplayField("displayName");
        this.languageSwitcher.setVisible(false);
        this.languageSwitcher.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaLanguage>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaLanguage> event) {
                GWTJahiaLanguage previous = AbstractContentEngine.this.language;
                AbstractContentEngine.this.language = (GWTJahiaLanguage)event.getSelectedItem();
                AbstractContentEngine.this.onLanguageChange(previous);
            }
        });
        this.languageSwitcher.setTemplate(LanguageSwitcherActionItem.getLangSwitchingTemplate());
        this.languageSwitcher.setTypeAhead(true);
        this.languageSwitcher.setTriggerAction(ComboBox.TriggerAction.ALL);
        this.languageSwitcher.setForceSelection(true);
        this.container.getPanel().getHeader().addTool(this.languageSwitcher);
    }

    protected void onLanguageChange(GWTJahiaLanguage previous) {
    }

    protected void setAvailableLanguages(List<GWTJahiaLanguage> languages) {
        if (this.languageSwitcher != null && !this.languageSwitcher.isVisible()) {
            if (languages != null && !languages.isEmpty()) {
                this.languageSwitcher.getStore().add(languages);
                ArrayList<GWTJahiaLanguage> selected = new ArrayList<GWTJahiaLanguage>();
                selected.add(this.currentLanguageBean);
                this.languageSwitcher.setSelection(selected);
                if (languages.size() > 1) {
                    this.languageSwitcher.setVisible(true);
                }
            } else {
                this.languageSwitcher.setVisible(false);
            }
        } else {
            Log.debug((String)"Language switcher disabled.");
        }
    }

    protected abstract void initFooter();

    protected void fillCurrentTab() {
        Object currentTabItem;
        TabItem currentTab = this.tabs.getSelectedItem();
        if (currentTab != null && (currentTabItem = currentTab.getData("item")) != null && currentTabItem instanceof EditEngineTabItem) {
            EditEngineTabItem engineTabItem = (EditEngineTabItem)currentTabItem;
            if (!((AsyncTabItem)currentTab).isProcessed()) {
                boolean isNewPropertiesEditor = false;
                if (engineTabItem instanceof PropertiesTabItem) {
                    boolean bl = isNewPropertiesEditor = ((PropertiesTabItem)engineTabItem).getPropertiesEditorByLang(this.getSelectedLanguage()) == null;
                }
                if (this.node != null && this.linker instanceof EditLinker && ((EditLinker)this.linker).getSelectedModule() instanceof AreaModule && this.node.equals(((EditLinker)this.linker).getSelectedModule().getNode())) {
                    for (TabItem tabItem : this.tabs.getItems()) {
                        if (!(engineTabItem instanceof ContentTabItem)) continue;
                        ((ContentTabItem)engineTabItem).setNameEditable(false);
                    }
                }
                engineTabItem.init(this, (AsyncTabItem)currentTab, this.getSelectedLanguage());
                if (isNewPropertiesEditor) {
                    this.initChoiceListInitializers(engineTabItem);
                }
            }
            this.focusFirstField();
        }
    }

    protected void focusFirstField() {
        EditEngineTabItem engineTabItem;
        Object currentTabItem;
        TabItem currentTab = this.tabs.getSelectedItem();
        if (currentTab != null && (currentTabItem = currentTab.getData("item")) != null && currentTabItem instanceof EditEngineTabItem && (engineTabItem = (EditEngineTabItem)currentTabItem) instanceof PropertiesTabItem) {
            ((PropertiesTabItem)engineTabItem).focusFirstField();
        }
    }

    protected void initChoiceListInitializers(EditEngineTabItem tabItem) {
        if (this.choiceListInitializersValues != null && tabItem instanceof PropertiesTabItem) {
            PropertiesEditor pe = ((PropertiesTabItem)tabItem).getPropertiesEditor();
            for (Map.Entry<String, GWTChoiceListInitializer> initializer : this.choiceListInitializersValues.entrySet()) {
                if (initializer.getValue().getDependentProperties() == null) continue;
                for (String dependentProperty : initializer.getValue().getDependentProperties()) {
                    Field<?> dependentField;
                    if (!pe.getFieldsMap().containsKey(dependentProperty) || (dependentField = pe.getFieldsMap().get(dependentProperty).getField()) == null) continue;
                    this.initChoiceListInitializer(dependentField, initializer.getKey(), pe, initializer.getValue().getDependentProperties());
                }
            }
        }
    }

    protected void initChoiceListInitializer(final Field<?> dependentField, final String propertyId, PropertiesEditor pe, final List<String> dependentProperties) {
        if (dependentField instanceof DualListField) {
            ((DualListField)dependentField).getToList().getStore().addStoreListener((StoreListener)new StoreListener<GWTJahiaValueDisplayBean>(){

                public void handleEvent(StoreEvent<GWTJahiaValueDisplayBean> event) {
                    AbstractContentEngine.this.refillDependantListWidgetOn(dependentField, propertyId, dependentProperties);
                }
            });
        } else {
            dependentField.addListener(Events.Change, (Listener)new Listener<FieldEvent>(){

                public void handleEvent(FieldEvent event) {
                    AbstractContentEngine.this.refillDependantListWidgetOn(dependentField, propertyId, dependentProperties);
                }
            });
        }
    }

    protected void refillDependantListWidgetOn(Field<?> dependentField, final String propertyId, List<String> dependentProperties) {
        String nodeTypeName = propertyId.substring(0, propertyId.indexOf(46));
        final String propertyName = propertyId.substring(propertyId.indexOf(46) + 1);
        HashMap<String, List<GWTJahiaNodePropertyValue>> dependentValues = new HashMap<String, List<GWTJahiaNodePropertyValue>>();
        for (TabItem tab : this.tabs.getItems()) {
            EditEngineTabItem item = (EditEngineTabItem)tab.getData("item");
            if (!(item instanceof PropertiesTabItem)) continue;
            for (PropertiesEditor pe : ((PropertiesTabItem)item).getLangPropertiesEditorMap().values()) {
                if (pe == null) continue;
                for (Field field : pe.getFields()) {
                    String name;
                    if (!(field instanceof PropertiesEditor.PropertyAdapterField) || !dependentProperties.contains(name = ((PropertiesEditor.PropertyAdapterField)field).getDefinition().getName())) continue;
                    dependentValues.put(name, PropertiesEditor.getPropertyValues(field, pe.getGWTJahiaItemDefinition(name)));
                }
            }
        }
        JahiaContentManagementService.App.getInstance().getFieldInitializerValues(nodeTypeName, propertyName, this.parentPath, dependentValues, (AsyncCallback<GWTChoiceListInitializer>)new BaseAsyncCallback<GWTChoiceListInitializer>(){

            public void onSuccess(GWTChoiceListInitializer result) {
                AbstractContentEngine.this.choiceListInitializersValues.put(propertyId, result);
                if (result.getDisplayValues() != null) {
                    String nameForDualFields = "from-" + propertyName;
                    for (TabItem tab : AbstractContentEngine.this.tabs.getItems()) {
                        PropertiesEditor pe;
                        EditEngineTabItem item = (EditEngineTabItem)tab.getData("item");
                        if (!(item instanceof PropertiesTabItem) || (pe = ((PropertiesTabItem)item).getPropertiesEditor()) == null) continue;
                        for (Field<?> field : pe.getFields()) {
                            ListStore store2;
                            if (field instanceof PropertiesEditor.PropertyAdapterField) {
                                field = ((PropertiesEditor.PropertyAdapterField)field).getField();
                            }
                            if (!propertyName.equals(field.getName()) && (!(field instanceof DualListField) || !nameForDualFields.equals(field.getName()))) continue;
                            if (field instanceof DualListField) {
                                DualListField dualListField = (DualListField)field;
                                store2 = dualListField.getToField().getStore();
                                for (GWTJahiaValueDisplayBean toValue : store2.getModels()) {
                                    if (result.getDisplayValues().contains(toValue)) continue;
                                    store2.remove((ModelData)toValue);
                                }
                                dualListField.getToField().getListView().refresh();
                                store2 = dualListField.getFromField().getStore();
                                store2.removeAll();
                                store2.add(result.getDisplayValues());
                                dualListField.getFromField().getListView().refresh();
                                continue;
                            }
                            if (!(field instanceof ComboBox)) continue;
                            ComboBox comboBox = (ComboBox)field;
                            if (comboBox.getValue() != null && !result.getDisplayValues().contains(comboBox.getValue())) {
                                try {
                                    comboBox.clear();
                                }
                                catch (Exception store2) {
                                    // empty catch block
                                }
                            }
                            store2 = new ListStore();
                            store2.add(result.getDisplayValues());
                            comboBox.setStore(store2);
                        }
                    }
                }
            }

            @Override
            public void onApplicationFailure(Throwable caught) {
                Log.error((String)"Unable to load avalibale mixin", (Throwable)caught);
            }
        });
    }

    protected void removeUneditedLanguages() {
        HashSet<String> editedLanguages = new HashSet<String>();
        editedLanguages.add(this.getSelectedLanguage());
        block0: for (Map.Entry<String, List<GWTJahiaNodeProperty>> entry : this.getChangedI18NProperties().entrySet()) {
            if (this.getSelectedLanguage().equals(entry.getKey())) continue;
            for (GWTJahiaNodeProperty property : entry.getValue()) {
                if (!property.isDirty()) continue;
                editedLanguages.add(entry.getKey());
                continue block0;
            }
        }
        this.getChangedI18NProperties().keySet().retainAll(editedLanguages);
    }

    @Override
    public Linker getLinker() {
        return this.linker;
    }

    @Override
    public List<GWTJahiaNodeType> getNodeTypes() {
        return this.nodeTypes;
    }

    @Override
    public List<GWTJahiaNodeType> getMixin() {
        return this.mixin;
    }

    @Override
    public Map<String, GWTChoiceListInitializer> getChoiceListInitializersValues() {
        return this.choiceListInitializersValues;
    }

    @Override
    public Map<String, GWTJahiaNodeProperty> getProperties() {
        return this.properties;
    }

    @Override
    public Map<String, GWTJahiaNodeProperty> getPresetProperties() {
        return this.presetProperties;
    }

    @Override
    public GWTJahiaNode getNode() {
        return this.node;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public String getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    @Override
    public GWTJahiaNodeACL getAcl() {
        return this.acl;
    }

    @Override
    public Map<String, Set<String>> getReferencesWarnings() {
        return this.referencesWarnings;
    }

    @Override
    public GWTJahiaNode getTargetNode() {
        return this.targetNode;
    }

    @Override
    public boolean isExistingNode() {
        return this.existingNode;
    }

    @Override
    public boolean isMultipleSelection() {
        return false;
    }

    @Override
    public List<GWTJahiaNode> getNodes() {
        return Arrays.asList(this.node);
    }

    public String getSelectedLanguage() {
        if (this.language != null) {
            return this.language.getLanguage();
        }
        return JahiaGWTParameters.getLanguage();
    }

    public abstract void setButtonsEnabled(boolean var1);

    public ComboBox<GWTJahiaLanguage> getLanguageSwitcher() {
        return this.languageSwitcher;
    }

    public TabPanel getTabs() {
        return this.tabs;
    }

    public List<GWTJahiaNodeProperty> getChangedProperties() {
        return this.changedProperties;
    }

    public Map<String, List<GWTJahiaNodeProperty>> getChangedI18NProperties() {
        return this.changedI18NProperties;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    @Override
    public Map<String, Map<String, List<GWTJahiaNodePropertyValue>>> getDefaultValues() {
        return this.defaultValues;
    }

    protected void refreshButtons() {
        for (BoxComponent button : this.saveButtons) {
            if (!(button instanceof CheckboxWorkInProgress)) continue;
            ((CheckboxWorkInProgress)button).refresh(this, this.language);
        }
    }

    public void setWorkInProgressCheckedByDefault(boolean workInProgressCheckedByDefault) {
        this.workInProgressCheckedByDefault = workInProgressCheckedByDefault;
    }

    public void setWorkInProgress(boolean workInProgress) {
        this.workInProgressByLocale.put(this.getSelectedLanguage(), workInProgress);
    }

    public boolean isWorkInProgress(String locale) {
        return this.workInProgressByLocale.containsKey(locale) && this.workInProgressByLocale.get(locale) != false;
    }

    public void setWorkInProgressProperty() {
        if (this.isNodeOfJmixLastPublishedType()) {
            for (String locale : this.workInProgressByLocale.keySet()) {
                if (!this.changedI18NProperties.containsKey(locale)) {
                    this.changedI18NProperties.put(locale, new ArrayList());
                }
                GWTJahiaNodePropertyValue wipValue = new GWTJahiaNodePropertyValue(String.valueOf(this.workInProgressByLocale.get(locale)), 6);
                this.changedI18NProperties.get(locale).add(new GWTJahiaNodeProperty("j:workInProgress", wipValue));
            }
        }
    }

    protected boolean isNodeOfJmixLastPublishedType() {
        return this.getNode() != null && this.getNode().isNodeType("jmix:lastPublished");
    }
}

