/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.ColumnLayout;
import com.extjs.gxt.ui.client.widget.layout.FillLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGrid;
import com.extjs.gxt.ui.client.widget.treegrid.WidgetTreeGridCellRenderer;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACL;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.util.content.JCRClientUtils;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.AsyncTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;
import org.jahia.ajax.gwt.client.widget.node.GWTJahiaNodeTreeFactory;

public class CategoriesTabItem
extends EditEngineTabItem {
    private transient List<GWTJahiaNode> catStore;
    private transient GWTJahiaNodeProperty categoryProperty;
    private transient ContentPanel topPanel;
    private transient GWTJahiaNodeTreeFactory treeGridFactory;

    @Override
    public void init(NodeHolder engine, AsyncTabItem tab, String locale) {
        if (!engine.isExistingNode() || engine.getNode() != null) {
            tab.setProcessed(true);
            tab.setLayout((Layout)new BorderLayout());
            this.topPanel = new ContentPanel((Layout)new ColumnLayout());
            this.topPanel.removeAll();
            this.topPanel.setScrollMode(Style.Scroll.AUTOY);
            this.topPanel.setHeadingHtml(Messages.get("label.selected.categories"));
            this.catStore = new ArrayList<GWTJahiaNode>();
            this.treeGridFactory = new GWTJahiaNodeTreeFactory(Arrays.asList("$systemsite/categories/*"), Arrays.asList("icon", "childrenInfo", "name", "displayName"));
            GWTJahiaNode node = engine.getNode();
            this.categoryProperty = engine.getProperties().get("j:defaultCategory");
            if (this.categoryProperty != null) {
                List<GWTJahiaNodePropertyValue> propertyValues = this.categoryProperty.getValues();
                for (GWTJahiaNodePropertyValue propertyValue : propertyValues) {
                    this.catStore.add(propertyValue.getNode());
                    this.topPanel.add((Widget)this.getOrCreateButton(propertyValue.getNode()));
                }
            }
            tab.add((Widget)this.topPanel, (LayoutData)new BorderLayoutData(Style.LayoutRegion.NORTH, 75.0f));
            if (!engine.isExistingNode() || PermissionsUtils.isPermitted("jcr:modifyProperties", node) && !node.isLocked().booleanValue()) {
                tab.add((Widget)this.createCategoriedPickerPanel(), (LayoutData)new BorderLayoutData(Style.LayoutRegion.CENTER, 250.0f));
            }
            tab.layout();
        }
    }

    private Component createCategoriedPickerPanel() {
        this.treeGridFactory.setNodeTypes(JCRClientUtils.CATEGORY_NODETYPES);
        ColumnConfig name = new ColumnConfig();
        name.setId("displayName");
        name.setHeaderHtml(Messages.get("label.title"));
        name.setWidth(5000);
        name.setRenderer((GridCellRenderer)new WidgetTreeGridCellRenderer<GWTJahiaNode>(){

            public String getId(TreeGrid<GWTJahiaNode> grid, GWTJahiaNode model, String property, int rowIndex, int colIndex) {
                return "JahiaGxtCategory_" + model.getName().replace(":", "_");
            }

            public Widget getWidget(final GWTJahiaNode model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<GWTJahiaNode> store, Grid<GWTJahiaNode> grid) {
                CheckBox checkBox = new CheckBox();
                checkBox.setValue(Boolean.valueOf(CategoriesTabItem.this.catStore.contains(model)));
                checkBox.addListener(Events.Change, (Listener)new Listener<ComponentEvent>(){

                    public void handleEvent(ComponentEvent event) {
                        Button button = CategoriesTabItem.this.getOrCreateButton(model);
                        if (!CategoriesTabItem.this.catStore.contains(model)) {
                            CategoriesTabItem.this.catStore.add(model);
                            CategoriesTabItem.this.topPanel.add((Widget)button);
                        } else {
                            CategoriesTabItem.this.catStore.remove(model);
                            CategoriesTabItem.this.topPanel.remove((Widget)button);
                        }
                        CategoriesTabItem.this.topPanel.layout();
                    }
                });
                checkBox.setBoxLabel(this.getText((TreeGrid)grid, (ModelData)model, property, rowIndex, colIndex));
                return checkBox;
            }
        });
        name.setFixed(true);
        GWTJahiaNodeTreeFactory.GWTJahiaNodeTreeGrid treeGrid = this.treeGridFactory.getTreeGrid(new ColumnModel(Arrays.asList(name)));
        treeGrid.setLayoutData(new FillLayout());
        treeGrid.setIconProvider(null);
        treeGrid.getStyle().setNodeCloseIcon(null);
        treeGrid.getStyle().setNodeOpenIcon(null);
        treeGrid.setBorders(true);
        treeGrid.setAutoExpandMax(5000);
        treeGrid.setAutoExpandColumn("displayName");
        treeGrid.getTreeView().setRowHeight(25);
        this.treeGridFactory.getLoader().load();
        return treeGrid;
    }

    private Button getOrCreateButton(GWTJahiaNode n) {
        for (Component c : this.topPanel.getItems()) {
            Button b;
            if (!(c instanceof Button) || !n.equals((b = (Button)c).getData("associatedNode"))) continue;
            return b;
        }
        Button button = new Button(n.getDisplayName(), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent buttonEvent) {
                GWTJahiaNode cat = (GWTJahiaNode)buttonEvent.getButton().getData("associatedNode");
                CategoriesTabItem.this.topPanel.remove((Widget)buttonEvent.getButton());
                CategoriesTabItem.this.topPanel.layout();
                CategoriesTabItem.this.catStore.remove(cat);
                CategoriesTabItem.this.treeGridFactory.getLoader().load();
            }
        });
        button.addStyleName("button-remove");
        button.setTitle(Messages.get("label.remove"));
        button.setData("associatedNode", (Object)n);
        button.setIcon(StandardIconsProvider.STANDARD_ICONS.minusRound());
        button.setId("JahiaGxtCategoryRemoveButton_" + ((GWTJahiaNode)button.getData("associatedNode")).getName().replace(":", "_"));
        return button;
    }

    @Override
    public void doSave(GWTJahiaNode node, List<GWTJahiaNodeProperty> changedProperties, Map<String, List<GWTJahiaNodeProperty>> changedI18NProperties, Set<String> addedTypes, Set<String> removedTypes, List<GWTJahiaNode> chidren, GWTJahiaNodeACL acl) {
        if (this.catStore == null) {
            return;
        }
        ArrayList<GWTJahiaNodePropertyValue> values = new ArrayList<GWTJahiaNodePropertyValue>(this.catStore.size());
        for (GWTJahiaNode gwtJahiaNode : this.catStore) {
            values.add(new GWTJahiaNodePropertyValue(gwtJahiaNode, 9));
        }
        GWTJahiaNodeProperty gwtJahiaNodeProperty = new GWTJahiaNodeProperty();
        gwtJahiaNodeProperty.setMultiple(true);
        gwtJahiaNodeProperty.setValues(values);
        gwtJahiaNodeProperty.setName("j:defaultCategory");
        if (this.categoryProperty != null) {
            if (values.isEmpty()) {
                addedTypes.remove("jmix:categorized");
                removedTypes.add("jmix:categorized");
            } else {
                changedProperties.add(gwtJahiaNodeProperty);
            }
        } else if (!values.isEmpty()) {
            addedTypes.add("jmix:categorized");
            changedProperties.add(gwtJahiaNodeProperty);
        }
    }

    @Override
    public void setProcessed(boolean processed) {
        if (!processed && this.catStore != null) {
            this.catStore = null;
            this.categoryProperty = null;
        }
        super.setProcessed(processed);
    }
}

