/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.form.AdapterField;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.FillLayout;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.extjs.gxt.ui.client.widget.layout.HBoxLayout;
import com.extjs.gxt.ui.client.widget.layout.HBoxLayoutData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEngineTab;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.util.Formatter;
import org.jahia.ajax.gwt.client.util.URL;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.AsyncTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.AbstractContentEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineValidation;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;
import org.jahia.ajax.gwt.client.widget.contentengine.PropertiesTabItem;
import org.jahia.ajax.gwt.client.widget.definition.PropertiesEditor;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.Module;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.ModuleHelper;

public class ContentTabItem
extends PropertiesTabItem {
    protected int maxNameSize = 32;
    private transient boolean isNodeNameFieldDisplayed = false;
    protected transient Field name;
    protected transient CheckBox autoUpdateName;
    protected transient Field<String> nameText;
    protected transient FieldSet nameFieldSet;
    protected transient Label autoUpdateLabel;
    private boolean nameEditable = true;
    private List<String> nameNotEditableForTypes;
    private List<String> invalidLanguagesAvailableForTypes;
    private transient List<CheckBox> invalidLanguagesCheckBoxes;
    private transient FieldSet invalidLanguagesFieldSet;
    private boolean defaultAutoUpdate = true;

    public Field<String> getName() {
        return this.nameText;
    }

    public List<CheckBox> getCheckedLanguagesCheckBox() {
        ArrayList<CheckBox> values = new ArrayList<CheckBox>();
        if (this.invalidLanguagesCheckBoxes != null) {
            for (CheckBox check : this.invalidLanguagesCheckBoxes) {
                if (!check.getValue().booleanValue()) continue;
                values.add(check);
            }
            return values;
        }
        return null;
    }

    @Override
    public AsyncTabItem create(GWTEngineTab engineTab, NodeHolder engine) {
        this.setMultiLang(true);
        this.nameText = null;
        this.autoUpdateName = null;
        this.nameFieldSet = null;
        this.nameEditable = true;
        if (this.dataType == null) {
            this.dataType = Arrays.asList("content");
        }
        this.invalidLanguagesCheckBoxes = null;
        this.invalidLanguagesFieldSet = null;
        return super.create(engineTab, engine);
    }

    @Override
    public void init(final NodeHolder engine, AsyncTabItem tab, String language) {
        super.init(engine, tab, language);
        if (engine.getMixin() != null && this.nameFieldSet != null) {
            Field<?> titleField;
            PropertiesEditor.PropertyAdapterField adapterField = this.propertiesEditor.getFieldsMap().get("jcr:title");
            if (adapterField != null) {
                ((FieldSet)adapterField.getParent()).insert((Component)this.name, 0);
                titleField = adapterField.getField();
                FieldSet titleFieldSet = this.propertiesEditor.getFieldSetsMap().get(adapterField.getDefinition().getDeclaringNodeType());
                this.propertiesEditor.remove((Widget)titleFieldSet);
                this.propertiesEditor.insert((Widget)titleFieldSet, 0);
            } else {
                this.propertiesEditor.insert((Widget)this.nameFieldSet, 0);
                titleField = null;
            }
            if (this.nameEditable && !engine.isMultipleSelection()) {
                if (this.autoUpdateName != null) {
                    this.autoUpdateName.removeAllListeners();
                }
                if (titleField != null) {
                    ArrayList listeners = new ArrayList(titleField.getListeners(Events.KeyUp));
                    for (Listener listener : listeners) {
                        titleField.removeListener(Events.KeyUp, listener);
                    }
                }
                this.isNodeNameFieldDisplayed = true;
                boolean autoUpdate = this.defaultAutoUpdate;
                boolean nameEditingAllowed = this.isNameEditableForType(engine);
                if (nameEditingAllowed && this.autoUpdateName != null) {
                    if (autoUpdate && (engine.isExistingNode() || !JahiaGWTParameters.getLanguage().equals(language))) {
                        if (titleField != null && titleField.getValue() != null) {
                            String generated = this.generateNodeName((String)titleField.getValue());
                            autoUpdate = ((String)this.nameText.getValue()).equals(generated);
                        } else {
                            autoUpdate = false;
                        }
                    }
                    this.autoUpdateName.setValue(Boolean.valueOf(autoUpdate));
                    this.autoUpdateName.setVisible(true);
                    this.autoUpdateLabel.setHtml("&nbsp;" + Messages.get("label.synchronizeName", "Automatically synchronize name with title") + ":");
                } else {
                    autoUpdate = false;
                    if (this.autoUpdateLabel != null) {
                        this.autoUpdateLabel.setHtml("");
                    }
                    if (this.autoUpdateName != null) {
                        this.autoUpdateName.setVisible(false);
                    }
                }
                this.nameText.setEnabled(nameEditingAllowed && !autoUpdate);
                if (titleField != null && this.autoUpdateName != null) {
                    this.autoUpdateName.addListener(Events.Change, (Listener)new Listener<ComponentEvent>(){

                        public void handleEvent(ComponentEvent event) {
                            ContentTabItem.this.nameText.setEnabled(ContentTabItem.this.autoUpdateName.getValue() == false);
                            if (ContentTabItem.this.autoUpdateName.isEnabled()) {
                                ContentTabItem.this.autoUpdateName.setData("realValue", (Object)ContentTabItem.this.autoUpdateName.getValue());
                            }
                            if (ContentTabItem.this.autoUpdateName.getValue().booleanValue()) {
                                if (titleField.getValue() != null) {
                                    ContentTabItem.this.nameText.setValue((Object)ContentTabItem.this.generateNodeName((String)titleField.getValue()));
                                } else {
                                    ContentTabItem.this.nameText.setValue((Object)engine.getNodeName());
                                }
                            }
                        }
                    });
                    titleField.addListener(Events.KeyUp, (Listener)new Listener<FieldEvent>(){

                        public void handleEvent(FieldEvent fe) {
                            if (ContentTabItem.this.autoUpdateName.getValue().booleanValue()) {
                                if (titleField.getValue() != null && ((String)titleField.getValue()).trim().length() > 0) {
                                    ContentTabItem.this.nameText.setValue((Object)ContentTabItem.this.generateNodeName((String)titleField.getValue()));
                                } else {
                                    ContentTabItem.this.nameText.setValue((Object)engine.getNodeName());
                                }
                            }
                        }
                    });
                }
            } else {
                this.isNodeNameFieldDisplayed = false;
                if (this.autoUpdateName != null) {
                    this.autoUpdateName.setVisible(false);
                }
                this.autoUpdateLabel.setHtml("");
                this.nameText.setValue((Object)"");
                this.nameText.setEnabled(false);
            }
        }
        if (this.invalidLanguagesFieldSet != null) {
            this.propertiesEditor.insert((Widget)this.invalidLanguagesFieldSet, 0);
        }
        tab.layout();
    }

    @Override
    public void attachPropertiesEditor(NodeHolder engine, AsyncTabItem tab) {
        this.setNameField(engine, tab);
        FieldSet fieldSet = new FieldSet();
        FormLayout fl = new FormLayout();
        fl.setLabelWidth(0);
        fieldSet.setLayout((Layout)fl);
        fieldSet.setHeadingHtml(Messages.get("label.information", "Information"));
        FormData fd = new FormData("98%");
        fd.setMargins(new Margins(0));
        GWTJahiaNode selectedNode = engine.getNode();
        Grid g = new Grid(1, 2);
        g.setCellSpacing(10);
        FlowPanel flowPanel = new FlowPanel();
        if (selectedNode != null) {
            String preview;
            String string = preview = selectedNode.getReferencedNode() != null ? selectedNode.getReferencedNode().getPreview() : selectedNode.getPreview();
            if (preview != null) {
                g.setWidget(0, 0, (Widget)new Image(URL.appendTimestamp(preview)));
            }
            if (JahiaGWTParameters.isDevelopmentMode()) {
                List<Module> modules;
                Date date;
                Long s;
                String id;
                String path = selectedNode.getPath();
                if (path != null) {
                    flowPanel.add((Widget)new HTML("<b>" + Messages.get("label.path") + ":</b> " + path));
                }
                if ((id = selectedNode.getUUID()) != null) {
                    flowPanel.add((Widget)new HTML("<b>" + Messages.get("label.id", "ID") + ":</b> " + id));
                }
                if (selectedNode.isFile() != null && selectedNode.isFile().booleanValue() && (s = selectedNode.getSize()) != null) {
                    flowPanel.add((Widget)new HTML("<b>" + Messages.get("label.size") + ":</b> " + Formatter.getFormattedSize(s) + " (" + s.toString() + " bytes)"));
                }
                if ((date = (Date)selectedNode.get("jcr:lastModified")) != null) {
                    flowPanel.add((Widget)new HTML("<b>" + Messages.get("label.lastModif") + ":</b> " + Formatter.getFormattedDate(date, "d/MM/y")));
                }
                if (selectedNode.isLocked() != null && selectedNode.isLocked().booleanValue() && selectedNode.getLockInfos() != null) {
                    StringBuilder infos = new StringBuilder();
                    if (selectedNode.getLockInfos().containsKey(null) && selectedNode.getLockInfos().size() == 1) {
                        for (String s2 : selectedNode.getLockInfos().get(null)) {
                            infos.append(Formatter.getLockLabel(s2));
                        }
                    } else {
                        for (Map.Entry<String, List<String>> entry : selectedNode.getLockInfos().entrySet()) {
                            if (entry.getKey() == null) continue;
                            if (infos.length() > 0) {
                                infos.append("; ");
                            }
                            infos.append(entry.getKey()).append(" : ");
                            int i = 0;
                            for (String s3 : entry.getValue()) {
                                if (i > 0) {
                                    infos.append(", ");
                                }
                                infos.append(Formatter.getLockLabel(s3));
                                ++i;
                            }
                        }
                    }
                    flowPanel.add((Widget)new HTML("<b>" + Messages.get("info.lock.label") + ":</b> " + infos));
                }
                flowPanel.add((Widget)new HTML("<b>" + Messages.get("nodes.label", "Types") + ":</b> " + selectedNode.getNodeTypes()));
                flowPanel.add((Widget)new HTML("<b>" + Messages.get("org.jahia.jcr.edit.tags.tab", "Tags") + ":</b> " + selectedNode.getTags() != null ? selectedNode.getTags() : ""));
                if (engine.getNode() != null && ModuleHelper.getModulesByPath() != null && (modules = ModuleHelper.getModulesByPath().get(engine.getNode().getPath())) != null && modules.size() > 0 && modules.get(0).getScriptInfo() != null) {
                    flowPanel.add((Widget)new HTML("<b>" + Messages.get("script.info.label", "Script info") + ":</b> " + modules.get(0).getScriptInfo()));
                }
                g.setWidget(0, 1, (Widget)flowPanel);
            }
            if (preview != null || JahiaGWTParameters.isDevelopmentMode()) {
                fieldSet.add((Widget)g, (LayoutData)fd);
                this.propertiesEditor.add((Widget)fieldSet);
            }
        }
        List siteLanguages = JahiaGWTParameters.getSiteLanguages();
        if (engine instanceof AbstractContentEngine) {
            siteLanguages = ((AbstractContentEngine)engine).getLanguageSwitcher().getStore().getModels();
        }
        if (this.invalidLanguagesFieldSet == null && siteLanguages.size() > 1 && engine.getNodeTypes().get(0).getSuperTypes().contains("jmix:i18n") && this.isInvalidLanguagesAvailableForType(engine)) {
            List<String> siteMandatoryLanguages = JahiaGWTParameters.getSiteMandatoryLanguages();
            this.invalidLanguagesCheckBoxes = new ArrayList<CheckBox>();
            LayoutContainer layoutContainer1 = new LayoutContainer();
            layoutContainer1.setBorders(false);
            layoutContainer1.setLayout((Layout)new FillLayout(Style.Orientation.HORIZONTAL){

                protected void setSize(Component c, int width, int height) {
                }
            });
            layoutContainer1.setWidth("100%");
            for (GWTJahiaLanguage siteLanguage : siteLanguages) {
                CheckBox checkBox = new CheckBox();
                checkBox.setBoxLabel(siteLanguage.getDisplayName());
                checkBox.setValueAttribute(siteLanguage.getLanguage());
                if (siteMandatoryLanguages.contains(siteLanguage.getLanguage())) {
                    checkBox.setValue(Boolean.valueOf(true));
                    checkBox.setEnabled(false);
                }
                if (selectedNode == null || !selectedNode.getInvalidLanguages().contains(siteLanguage.getLanguage())) {
                    checkBox.setValue(Boolean.valueOf(true));
                }
                layoutContainer1.add((Widget)checkBox);
                this.invalidLanguagesCheckBoxes.add(checkBox);
            }
            this.invalidLanguagesFieldSet = new FieldSet();
            this.invalidLanguagesFieldSet.setHeadingHtml(Messages.get("label.validLanguages", "Valid display languages"));
            this.invalidLanguagesFieldSet.setLayout((Layout)new FormLayout());
            this.invalidLanguagesFieldSet.add((Widget)layoutContainer1, (LayoutData)fd);
        }
        super.attachPropertiesEditor(engine, tab);
    }

    protected void setNameField(NodeHolder engine, AsyncTabItem tab) {
        if (!engine.isMultipleSelection()) {
            String nodeName;
            tab.setLayout((Layout)new RowLayout());
            FormLayout fl = new FormLayout();
            fl.setLabelWidth(0);
            PropertiesEditor.PropertyAdapterField titleField = this.propertiesEditor.getFieldsMap().get("jcr:title");
            if (this.nameText == null) {
                boolean nameWriteable;
                this.nameFieldSet = new FieldSet();
                this.nameFieldSet.setHeadingHtml(Messages.get("label.systemName", "System name"));
                this.nameFieldSet.setLayout((Layout)fl);
                this.nameText = new TextField();
                this.nameText.setId("JahiaGxtField_systemName");
                this.nameText.setWidth("250");
                ((TextField)this.nameText).setMaxLength(this.maxNameSize);
                ((TextField)this.nameText).setAllowBlank(false);
                this.nameText.setStyleAttribute("padding-left", "0");
                this.nameText.setFireChangeEventOnSetValue(true);
                HBoxLayout hBoxLayout = new HBoxLayout();
                hBoxLayout.setHBoxLayoutAlign(HBoxLayout.HBoxLayoutAlign.MIDDLE);
                LayoutContainer panel = new LayoutContainer((Layout)hBoxLayout);
                panel.add(this.nameText, (LayoutData)new HBoxLayoutData(0, 5, 0, 5));
                this.autoUpdateLabel = new Label("");
                panel.add((Widget)this.autoUpdateLabel, (LayoutData)new HBoxLayoutData(0, 5, 0, 5));
                if (titleField != null) {
                    this.autoUpdateName = new CheckBox();
                    this.autoUpdateName.setId("JahiaGxtCheckbox_syncSystemNameWithTitle");
                    this.autoUpdateName.setWidth(10);
                    panel.add((Widget)this.autoUpdateName, (LayoutData)new HBoxLayoutData(0, 5, 5, 5));
                }
                this.name = new AdapterField((Widget)panel);
                this.name.setFieldLabel(Messages.get("label.systemName", "System name"));
                FormData fd = new FormData("98%");
                fd.setMargins(new Margins(0));
                this.nameFieldSet.add((Widget)this.name, (LayoutData)fd);
                boolean bl = nameWriteable = !engine.isExistingNode() || PermissionsUtils.isPermitted("jcr:write_default", engine.getNode()) && engine.getNode().isLocked() == false;
                if (!nameWriteable) {
                    this.nameText.setReadOnly(true);
                    if (this.autoUpdateName != null) {
                        this.autoUpdateName.setEnabled(false);
                    }
                }
                tab.setData("NodeName", null);
            }
            if ((nodeName = (String)tab.getData("NodeName")) == null || !nodeName.equals(engine.getNodeName())) {
                tab.setData("NodeName", engine.getNodeName());
                if (titleField != null) {
                    ArrayList listeners = new ArrayList(titleField.getListeners(Events.KeyUp));
                    for (Listener listener : listeners) {
                        titleField.removeListener(Events.KeyUp, listener);
                    }
                }
                this.nameText.setValue((Object)engine.getNodeName());
                if (this.autoUpdateName != null) {
                    this.autoUpdateName.removeAllListeners();
                    this.autoUpdateName.setData("realValue", null);
                }
            }
        }
    }

    public boolean isNodeNameFieldDisplayed() {
        return this.isNodeNameFieldDisplayed;
    }

    public void setNameEditable(boolean nameEditable) {
        this.nameEditable = nameEditable;
    }

    public String generateNodeName(String text) {
        text = text.replaceAll("[\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5]", "a");
        text = text.replaceAll("\u00e6", "ae");
        text = text.replaceAll("\u00e7", "c");
        text = text.replaceAll("[\u00e8\u00e9\u00ea\u00eb]", "e");
        text = text.replaceAll("[\u00ec\u00ed\u00ee\u00ef]", "i");
        text = text.replaceAll("\u00f1", "n");
        text = text.replaceAll("[\u00f2\u00f3\u00f4\u00f5\u00f6]", "o");
        text = text.replaceAll("\u0153", "oe");
        text = text.replaceAll("[\u00f9\u00fa\u00fb\u00fc]", "u");
        text = text.replaceAll("[\u00fd\u00ff]", "y");
        text = text.replaceAll("[\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5]", "A");
        text = text.replaceAll("\u00c6", "AE");
        text = text.replaceAll("\u00c7", "C");
        text = text.replaceAll("[\u00c8\u00c9\u00ca\u00cb]", "E");
        text = text.replaceAll("[\u00cc\u00cd\u00ce\u00cf]", "I");
        text = text.replaceAll("\u00d1", "N");
        text = text.replaceAll("[\u00d2\u00d3\u00d4\u00d5\u00d6]", "O");
        text = text.replaceAll("\u0152", "OE");
        text = text.replaceAll("[\u00d9\u00da\u00db\u00dc]", "U");
        String nodeName = text = text.replaceAll("[\u00dd\u0178]", "Y");
        char[] chars = nodeName.toCharArray();
        char[] newChars = new char[chars.length];
        int j = 0;
        for (char aChar : chars) {
            if (!Character.isLetterOrDigit(aChar) && aChar != ' ' && aChar != '-') continue;
            newChars[j++] = aChar;
        }
        nodeName = new String(newChars, 0, j).trim().replaceAll(" ", "-").toLowerCase();
        if (nodeName.length() > this.maxNameSize && (nodeName = nodeName.substring(0, this.maxNameSize)).endsWith("-") && nodeName.length() > 2) {
            nodeName = nodeName.substring(0, nodeName.length() - 1);
        }
        return nodeName;
    }

    public void setMaxNameSize(int maxNameSize) {
        this.maxNameSize = maxNameSize;
    }

    @Override
    public void setProcessed(boolean processed) {
        if (!processed) {
            this.isNodeNameFieldDisplayed = false;
            this.nameText = null;
            this.nameEditable = true;
        }
        super.setProcessed(processed);
    }

    public void setNameNotEditableForTypes(List<String> nameNotEditableForTypes) {
        this.nameNotEditableForTypes = nameNotEditableForTypes;
    }

    private boolean isNameEditableForType(NodeHolder engine) {
        return this.nameNotEditableForTypes == null || this.nameNotEditableForTypes.isEmpty() || engine == null || !engine.isExistingNode() || !engine.getNode().isNodeType(this.nameNotEditableForTypes);
    }

    public void setInvalidLanguagesAvailableForTypes(List<String> invalidLanguagesAvailableForTypes) {
        this.invalidLanguagesAvailableForTypes = invalidLanguagesAvailableForTypes;
    }

    private boolean isInvalidLanguagesAvailableForType(NodeHolder engine) {
        if (this.invalidLanguagesAvailableForTypes != null && !this.invalidLanguagesAvailableForTypes.isEmpty() && engine != null) {
            for (GWTJahiaNodeType type : engine.getNodeTypes()) {
                if (this.invalidLanguagesAvailableForTypes.contains(type.getName())) {
                    return true;
                }
                for (String superType : type.getSuperTypes()) {
                    if (!this.invalidLanguagesAvailableForTypes.contains(superType)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void doValidate(List<EngineValidation.ValidateResult> validateResult, NodeHolder engine, TabItem tab, String selectedLanguage, Map<String, List<GWTJahiaNodeProperty>> changedI18NProperties, TabPanel tabs) {
        Field<String> nameField = this.getName();
        if (nameField != null && !nameField.isValid()) {
            EngineValidation.ValidateResult result = new EngineValidation.ValidateResult();
            result.canIgnore = false;
            result.errorTab = tab;
            result.errorField = nameField;
            validateResult.add(result);
        }
        super.doValidate(validateResult, engine, tab, selectedLanguage, changedI18NProperties, tabs);
    }

    public void setDefaultAutoUpdate(boolean defaultAutoUpdate) {
        this.defaultAutoUpdate = defaultAutoUpdate;
    }
}

