/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.BoxComponent;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaEditEngineInitBean;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaGetPropertiesResult;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEngineConfiguration;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEngineTab;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.Formatter;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.contentengine.AbstractContentEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.ButtonItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineContainer;

public class EditContentEngine
extends AbstractContentEngine {
    private String contentPath;
    private HandlerRegistration handlerRegistration;
    private Map<String, GWTJahiaGetPropertiesResult> langCodeGWTJahiaGetPropertiesResultMap = new HashMap<String, GWTJahiaGetPropertiesResult>();
    private boolean hasOrderableChildNodes;

    public EditContentEngine(GWTEngineConfiguration configuration, GWTJahiaNode node, Linker linker, EngineContainer engineContainer) {
        super(configuration, linker, node.getPath().substring(0, node.getPath().lastIndexOf(47)));
        this.contentPath = node.getPath();
        this.nodeName = node.getName();
        this.node = node;
        this.init(engineContainer);
        this.loadEngine();
        this.addStyleName("edit-content-engine");
        this.handlerRegistration = Window.addCloseHandler((CloseHandler)new CloseHandler<Window>(){

            public void onClose(CloseEvent<Window> event) {
                EditContentEngine.this.close();
            }
        });
    }

    @Override
    public void close() {
        super.close();
        JahiaContentManagementService.App.getInstance().closeEditEngine(this.contentPath, new BaseAsyncCallback<Object>(){

            public void onSuccess(Object result) {
            }
        });
        this.closeEngine();
    }

    protected void closeEngine() {
        if (this.handlerRegistration != null) {
            this.handlerRegistration.removeHandler();
            this.handlerRegistration = null;
        }
        this.container.closeEngine();
    }

    protected void initTabs() {
        this.tabs.setId("JahiaGxtEditEngineTabs");
        for (GWTEngineTab tabConfig : this.config.getEngineTabs()) {
            EditEngineTabItem tabItem = tabConfig.getTabItem();
            if (tabConfig.getRequiredPermission() != null && !PermissionsUtils.isPermitted(tabConfig.getRequiredPermission(), JahiaGWTParameters.getSiteNode()) || !tabItem.getHideForTypes().isEmpty() && this.node.isNodeType(tabItem.getHideForTypes()) || (!this.hasOrderableChildNodes || !tabItem.isOrderableTab()) && (tabItem.isOrderableTab() || !tabItem.getShowForTypes().isEmpty() && !this.node.isNodeType(tabItem.getShowForTypes()))) continue;
            this.tabs.add((TabItem)tabItem.create(tabConfig, this));
        }
        this.tabs.setSelection((TabItem)this.tabs.getItem(0));
    }

    @Override
    protected void initFooter() {
        for (ButtonItem buttonItem : this.config.getEditionButtons()) {
            BoxComponent button = buttonItem.create(this);
            this.saveButtons.add(button);
            this.buttonBar.add((Component)button);
        }
        for (ButtonItem buttonItem : this.config.getCommonButtons()) {
            this.buttonBar.add((Component)buttonItem.create(this));
        }
        this.setButtonsEnabled(false);
    }

    private void loadProperties() {
        JahiaContentManagementService.App.getInstance().getProperties(this.contentPath, this.getSelectedLanguage(), (AsyncCallback<GWTJahiaGetPropertiesResult>)new BaseAsyncCallback<GWTJahiaGetPropertiesResult>(){

            @Override
            public void onApplicationFailure(Throwable throwable) {
                Log.debug((String)"Cannot get properties", (Throwable)throwable);
            }

            public void onSuccess(GWTJahiaGetPropertiesResult result) {
                EditContentEngine.this.node = result.getNode();
                EditContentEngine.this.nodeTypes = result.getNodeTypes();
                EditContentEngine.this.properties = result.getProperties();
                EditContentEngine.this.currentLanguageBean = result.getCurrentLocale();
                if (EditContentEngine.this.getSelectedLanguage() != null) {
                    EditContentEngine.this.langCodeGWTJahiaGetPropertiesResultMap.put(EditContentEngine.this.getSelectedLanguage(), result);
                }
                EditContentEngine.this.setWorkInProgress(EditContentEngine.this.workInProgressCheckedByDefault || EditContentEngine.this.node.get("j:workInProgress") != null && (Boolean)EditContentEngine.this.node.get("j:workInProgress") != false);
                EditContentEngine.this.fillCurrentTab();
                EditContentEngine.this.refreshButtons();
            }
        });
    }

    private void loadEngine() {
        JahiaContentManagementService.App.getInstance().initializeEditEngine(this.contentPath, true, (AsyncCallback<GWTJahiaEditEngineInitBean>)new BaseAsyncCallback<GWTJahiaEditEngineInitBean>(){

            public void onSuccess(GWTJahiaEditEngineInitBean result) {
                if (EditContentEngine.this.closed) {
                    return;
                }
                EditContentEngine.this.node = result.getNode();
                EditContentEngine.this.nodeTypes = result.getNodeTypes();
                EditContentEngine.this.properties = result.getProperties();
                EditContentEngine.this.currentLanguageBean = result.getCurrentLocale();
                EditContentEngine.this.defaultLanguageCode = result.getDefaultLanguageCode();
                EditContentEngine.this.hasOrderableChildNodes = result.hasOrderableChildNodes();
                EditContentEngine.this.langCodeGWTJahiaGetPropertiesResultMap.put(EditContentEngine.this.currentLanguageBean.getLanguage(), result);
                EditContentEngine.this.acl = result.getAcl();
                EditContentEngine.this.referencesWarnings = result.getReferencesWarnings();
                EditContentEngine.this.heading = !PermissionsUtils.isPermitted("jcr:modifyProperties", EditContentEngine.this.node) ? Messages.getWithArgs("label.edit.engine.heading.read.only", "Read {0} ({1})", new String[]{EditContentEngine.this.nodeName, ((GWTJahiaNodeType)EditContentEngine.this.nodeTypes.get(0)).getLabel()}) : Messages.getWithArgs("label.edit.engine.heading.edit", "Edit {0} ({1})", new String[]{EditContentEngine.this.nodeName, ((GWTJahiaNodeType)EditContentEngine.this.nodeTypes.get(0)).getLabel()});
                EditContentEngine.this.container.getPanel().setHeadingHtml(EditContentEngine.this.heading);
                if (EditContentEngine.this.node.isLocked().booleanValue()) {
                    StringBuilder infos = new StringBuilder();
                    if (EditContentEngine.this.node.getLockInfos().containsKey(null) && EditContentEngine.this.node.getLockInfos().size() == 1) {
                        for (String s : EditContentEngine.this.node.getLockInfos().get(null)) {
                            infos.append(Formatter.getLockLabel(s));
                        }
                    } else {
                        for (Map.Entry<String, List<String>> entry : EditContentEngine.this.node.getLockInfos().entrySet()) {
                            if (entry.getKey() == null) continue;
                            if (infos.length() > 0) {
                                infos.append("; ");
                            }
                            infos.append(entry.getKey()).append(" : ");
                            int i = 0;
                            for (String s : entry.getValue()) {
                                if (i > 0) {
                                    infos.append(", ");
                                }
                                infos.append(Formatter.getLockLabel(s));
                                ++i;
                            }
                        }
                    }
                    EditContentEngine.this.heading = EditContentEngine.this.heading + "&nbsp;" + Messages.getWithArgs("label.edit.engine.heading.locked.by", "[ locked by {0} ]", new String[]{infos.toString()});
                    EditContentEngine.this.container.getPanel().setHeadingHtml(EditContentEngine.this.heading);
                } else if (EditContentEngine.this.node.getLockInfos() != null && !EditContentEngine.this.node.getLockInfos().isEmpty()) {
                    EditContentEngine.this.heading = EditContentEngine.this.heading + "&nbsp;" + Messages.get("label.edit.engine.heading.locked.by.you", "[ locked by you ]");
                    EditContentEngine.this.container.getPanel().setHeadingHtml(EditContentEngine.this.heading);
                }
                EditContentEngine.this.setWorkInProgress(EditContentEngine.this.workInProgressCheckedByDefault || EditContentEngine.this.node.get("j:workInProgress") != null && (Boolean)EditContentEngine.this.node.get("j:workInProgress") != false);
                EditContentEngine.this.setAvailableLanguages(result.getAvailabledLanguages());
                if (EditContentEngine.this.getSelectedLanguage() != null) {
                    EditContentEngine.this.langCodeGWTJahiaGetPropertiesResultMap.put(EditContentEngine.this.getSelectedLanguage(), result);
                }
                EditContentEngine.this.mixin = result.getMixin();
                EditContentEngine.this.choiceListInitializersValues = result.getInitializersValues();
                EditContentEngine.this.defaultValues = result.getDefaultValues();
                EditContentEngine.this.initTabs();
                EditContentEngine.this.tabs.addListener(Events.Select, (Listener)new Listener<ComponentEvent>(){

                    public void handleEvent(ComponentEvent event) {
                        EditContentEngine.this.fillCurrentTab();
                    }
                });
                EditContentEngine.this.fillCurrentTab();
                if (PermissionsUtils.isPermitted("jcr:modifyProperties", EditContentEngine.this.node) && !EditContentEngine.this.node.isLocked().booleanValue()) {
                    EditContentEngine.this.setButtonsEnabled(true);
                }
                EditContentEngine.this.loaded();
            }

            @Override
            public void onApplicationFailure(Throwable throwable) {
                Log.debug((String)"Cannot get properties", (Throwable)throwable);
                Info.display((String)Messages.get("label.error", "Error"), (String)throwable.getLocalizedMessage());
                EditContentEngine.this.closeEngine();
            }

            @Override
            public void onSessionExpired() {
                EditContentEngine.this.closeEngine();
            }
        });
    }

    @Override
    protected void onLanguageChange(GWTJahiaLanguage previous) {
        GWTJahiaGetPropertiesResult result;
        if (previous != null) {
            String lang = previous.getLanguage();
            for (TabItem item : this.tabs.getItems()) {
                Object itemData;
                if (!this.changedI18NProperties.containsKey(lang)) {
                    this.changedI18NProperties.put(lang, new ArrayList());
                }
                if (!((itemData = item.getData("item")) instanceof EditEngineTabItem)) continue;
                ((EditEngineTabItem)itemData).onLanguageChange(this.getSelectedLanguage(), item);
            }
        }
        if ((result = this.langCodeGWTJahiaGetPropertiesResultMap.get(this.getSelectedLanguage())) == null) {
            this.loadProperties();
        } else {
            this.node = result.getNode();
            this.nodeTypes = result.getNodeTypes();
            this.properties = result.getProperties();
            this.currentLanguageBean = result.getCurrentLocale();
            this.fillCurrentTab();
            this.refreshButtons();
        }
    }

    @Override
    public void setButtonsEnabled(boolean enabled) {
        for (BoxComponent button : this.saveButtons) {
            button.setEnabled(enabled);
        }
    }

    public String toString() {
        return this.node.getPath();
    }
}

