/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.form.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.GWTConstraintViolationException;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;
import org.jahia.ajax.gwt.client.widget.contentengine.PropertiesTabItem;
import org.jahia.ajax.gwt.client.widget.definition.PropertiesEditor;

public class EngineValidation {
    private NodeHolder engine;
    private TabPanel tabs;
    private String selectedLanguage;
    private Map<String, List<GWTJahiaNodeProperty>> changedI18NProperties;

    public EngineValidation(NodeHolder engine, TabPanel tabs, String selectedLanguage, Map<String, List<GWTJahiaNodeProperty>> changedI18NProperties) {
        this.engine = engine;
        this.tabs = tabs;
        this.selectedLanguage = selectedLanguage;
        this.changedI18NProperties = changedI18NProperties;
    }

    public boolean validateData(ValidateCallback callback) {
        ArrayList<ValidateResult> validateResult = new ArrayList<ValidateResult>();
        for (Object tab : this.tabs.getItems()) {
            EditEngineTabItem item = (EditEngineTabItem)tab.getData("item");
            item.doValidate(validateResult, this.engine, (TabItem)tab, this.selectedLanguage, this.changedI18NProperties, this.tabs);
        }
        if (!validateResult.isEmpty()) {
            ArrayList<ValidateResult> r = new ArrayList<ValidateResult>();
            for (ValidateResult result : validateResult) {
                if (result.errorTab == this.tabs.getSelectedItem()) {
                    r.add(0, result);
                    continue;
                }
                r.add(result);
            }
            Iterator<ValidateResult> it = r.iterator();
            this.displayValidationError(it, callback);
            return false;
        }
        return true;
    }

    private void displayValidationError(final Iterator<ValidateResult> it, final ValidateCallback callback) {
        final ValidateResult result = it.next();
        callback.handleValidationResult(result);
        Listener<MessageBoxEvent> boxCallback = new Listener<MessageBoxEvent>(){

            public void handleEvent(MessageBoxEvent be) {
                if (result.canIgnore && be.getButtonClicked().equals(be.getDialog().getButtonById("yes"))) {
                    if (it.hasNext()) {
                        EngineValidation.this.displayValidationError(it, callback);
                    } else {
                        callback.saveAnyway();
                    }
                } else {
                    callback.close();
                }
            }
        };
        if (result.canIgnore) {
            String continueMessage = Messages.get("label.continueAnyway", "Do you want to continue anyway ?");
            MessageBox.confirm((String)Messages.get("label.error", "Error"), (String)(result.message + "</br><b>" + continueMessage + "</b>"), (Listener)boxCallback);
        } else {
            MessageBox.alert((String)Messages.get("label.error", "Error"), (String)result.message, (Listener)boxCallback).getDialog().addStyleName("engine-save-error");
        }
    }

    public ValidateResult getValidationFromException(List<GWTConstraintViolationException> errors) {
        HashMap<String, GWTConstraintViolationException> errorMap = new HashMap<String, GWTConstraintViolationException>();
        for (GWTConstraintViolationException error : errors) {
            if (error.getPropertyName() == null) continue;
            errorMap.put(error.getPropertyName(), error);
        }
        ValidateResult validateResult = new ValidateResult();
        for (TabItem tab : this.tabs.getItems()) {
            EditEngineTabItem item = (EditEngineTabItem)tab.getData("item");
            if (!(item instanceof PropertiesTabItem)) continue;
            PropertiesTabItem propertiesTabItem = (PropertiesTabItem)item;
            PropertiesEditor pe = ((PropertiesTabItem)item).getPropertiesEditor();
            if (pe == null) continue;
            Map<String, PropertiesEditor.PropertyAdapterField> fieldsMap = pe.getFieldsMap();
            for (String fieldName : fieldsMap.keySet()) {
                if (!errorMap.containsKey(fieldName)) continue;
                Field<?> field = fieldsMap.get(fieldName).getField();
                GWTConstraintViolationException error = (GWTConstraintViolationException)errorMap.get(fieldName);
                field.markInvalid(error.getConstraintMessage());
                validateResult.errorTab = tab;
                validateResult.errorField = field;
                validateResult.errorLang = error.getLocale();
                validateResult.canIgnore = false;
            }
        }
        return validateResult;
    }

    public static interface ValidateCallback {
        public void handleValidationResult(ValidateResult var1);

        public void saveAnyway();

        public void close();
    }

    public static class ValidateResult {
        public boolean canIgnore = true;
        public TabItem errorTab = null;
        public Field<?> errorField = null;
        public String errorLang = null;
        public String message = Messages.get("failure.invalid.constraint.label", "There are some validation errors! Click on the information icon next to the highlighted fields, correct the input and save again.");
    }
}

