/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.BoxComponent;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.FormButtonBinding;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.contentengine.AbstractContentEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.CreateContentEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.SaveButtonItem;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.toolbar.action.SiteSwitcherActionItem;

public class SaveAsViewButtonItem
extends SaveButtonItem {
    public static final int INDEX_OF_MODULE_NAME = 2;
    public static final int INDEX_OF_FILE_TYPE = 8;
    public static final int INDEX_OF_FILE_NAME = 10;
    public static final int INDEX_OF_TEMPLATE_TYPE = 9;
    public static final String VIEWS_SOURCE_PATH = "/sources/src/main/resources";

    @Override
    public BoxComponent create(final AbstractContentEngine engine) {
        Button button = new Button(Messages.get("label.saveAs", "Save as ..."));
        button.addStyleName("button-saveas");
        button.setHeight(24);
        button.setIcon(StandardIconsProvider.STANDARD_ICONS.engineButtonOK());
        button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                String fileTemplateType;
                String fileName;
                String fileView;
                String fileType;
                String moduleVersion;
                String[] filePath;
                GWTJahiaNode node = engine.getNode();
                if (node == null) {
                    node = engine.getTargetNode();
                }
                if ("modules".equals((filePath = node.getPath().split("/"))[1])) {
                    moduleVersion = (String)JahiaGWTParameters.getSiteNode().getProperties().get("j:versionInfo");
                    if (engine instanceof CreateContentEngine) {
                        String targetName = ((CreateContentEngine)engine).getTargetName();
                        int periodIndex = targetName.indexOf(46);
                        if (periodIndex > 0) {
                            fileType = targetName.substring(0, periodIndex);
                            fileView = targetName.substring(periodIndex + 1);
                        } else {
                            fileType = targetName;
                            fileView = "default";
                        }
                        int nsIndex = fileType.indexOf(95);
                        fileName = nsIndex > 1 ? fileType.substring(nsIndex + 1) + ".jsp" : fileType + ".jsp";
                        fileTemplateType = "html";
                    } else {
                        fileType = filePath[8];
                        fileName = filePath[10];
                        fileTemplateType = filePath[9];
                        fileView = "default";
                    }
                } else {
                    MessageBox.alert((String)Messages.get("label.error", "Error"), (String)Messages.getWithArgs("label.issueOccursTryingResolve", "An issue occurred when trying to resolve {0}", new Object[]{node.getPath()}), null).getDialog().addStyleName("engine-save-error");
                    return;
                }
                final String modulePath = "/modules/" + filePath[2];
                final String moduleName = filePath[2];
                final Window popup = new Window();
                popup.addStyleName("save-as-view-modal");
                popup.setHeadingHtml(Messages.get("label.saveAsView", "Save as view"));
                popup.setHeight(200);
                popup.setWidth(350);
                popup.setModal(true);
                FormPanel f = new FormPanel();
                f.setHeaderVisible(false);
                final SimpleComboBox dependenciesCombo = new SimpleComboBox();
                if (JahiaGWTParameters.getSiteNode() != null) {
                    dependenciesCombo.setStore(new ListStore());
                    dependenciesCombo.setFieldLabel(Messages.get("label.module", "Module"));
                    dependenciesCombo.setTriggerAction(ComboBox.TriggerAction.ALL);
                    dependenciesCombo.add((Object)moduleName);
                    for (GWTJahiaNode n : JahiaGWTParameters.getSitesMap().values()) {
                        dependenciesCombo.add((Object)n.getName());
                    }
                    dependenciesCombo.getStore().sort("value", Style.SortDir.ASC);
                    dependenciesCombo.setSimpleValue((Object)moduleName);
                    f.add((Widget)dependenciesCombo);
                }
                final TextField templateType = new TextField();
                templateType.setFieldLabel(Messages.get("label.templateType", "template Type"));
                templateType.setValue((Object)fileTemplateType);
                f.add((Widget)templateType);
                final TextField viewName = new TextField();
                viewName.setFieldLabel(Messages.get("label.viewName", "View name"));
                viewName.setValue((Object)fileView);
                f.add((Widget)viewName);
                Button b = new Button(Messages.get("label.submit", "submit"));
                b.addStyleName("button-submit");
                f.addButton(b);
                b.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                    public void componentSelected(ButtonEvent buttonEvent) {
                        String templateTypeValue;
                        String newModuleName = moduleName;
                        String newModulePath = modulePath;
                        String newModuleVersion = moduleVersion;
                        GWTJahiaNode newModuleNode = null;
                        String dependenciesValue = (String)dependenciesCombo.getSimpleValue();
                        if (!newModuleName.equals(dependenciesValue)) {
                            for (GWTJahiaNode n : JahiaGWTParameters.getSitesMap().values()) {
                                if (!n.getName().equals(dependenciesValue)) continue;
                                newModuleNode = n;
                                newModuleName = dependenciesValue;
                                newModulePath = n.getPath();
                                newModuleVersion = (String)n.getProperties().get("j:versionInfo");
                                break;
                            }
                        }
                        String newfileTemplateType = !"".equals(templateTypeValue = (String)templateType.getValue()) ? templateTypeValue : fileTemplateType;
                        String viewNameValue = (String)viewName.getValue();
                        String newfileView = viewNameValue == null || viewNameValue.equals("default") || viewNameValue.trim().equals("") ? "" : "." + viewNameValue;
                        String versionSourceTypePath = "/" + newModuleVersion + SaveAsViewButtonItem.VIEWS_SOURCE_PATH + "/" + fileType;
                        String templatePath = versionSourceTypePath + "/" + newfileTemplateType;
                        newModulePath = newModulePath + templatePath;
                        int nsIndex = fileType.indexOf(95);
                        String ft = nsIndex > 1 ? fileType.substring(nsIndex + 1) : fileName;
                        String newViewName = ft + newfileView + fileName.substring(fileName.lastIndexOf(46));
                        LinkedHashMap<String, String> parentNodesType = new LinkedHashMap<String, String>();
                        String modulePathStart = "/modules/" + newModuleName;
                        parentNodesType.put(modulePathStart + versionSourceTypePath, "jnt:folder");
                        parentNodesType.put(modulePathStart + templatePath, "jnt:folder");
                        parentNodesType.put(newfileTemplateType, "jnt:folder");
                        SaveAsViewButtonItem.this.prepareAndSave(newModulePath, newViewName, parentNodesType, engine, newModuleNode);
                        popup.hide();
                    }
                });
                Button c = new Button(Messages.get("label.cancel", "Cancel"));
                c.addStyleName("button-cancel");
                c.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                    public void componentSelected(ButtonEvent buttonEvent) {
                        popup.hide();
                    }
                });
                f.addButton(c);
                f.setButtonAlign(Style.HorizontalAlignment.CENTER);
                FormButtonBinding binding = new FormButtonBinding(f);
                binding.addButton(b);
                popup.add((Widget)f);
                popup.setFocusWidget((Widget)viewName);
                popup.show();
                viewName.setCursorPos(((String)viewName.getValue()).length());
            }
        });
        return button;
    }

    protected void prepareAndSave(String modulePath, String viewName, Map<String, String> parentNodesType, final AbstractContentEngine engine, final GWTJahiaNode newModuleNode) {
        HashSet<String> addedTypes = new HashSet<String>();
        HashSet<String> removedTypes = new HashSet<String>();
        for (TabItem tab : engine.getTabs().getItems()) {
            EditEngineTabItem item = (EditEngineTabItem)tab.getData("item");
            item.doSave(null, engine.getChangedProperties(), engine.getChangedI18NProperties(), addedTypes, removedTypes, null, engine.getAcl());
        }
        List<GWTJahiaNodeProperty> changedProperties = engine.getChangedProperties();
        List<GWTJahiaNodeProperty> properties = null;
        engine.getProperties().remove("nodeTypeName");
        engine.getProperties().remove("scmStatus");
        if (engine.getProperties().size() > 0) {
            HashMap<String, GWTJahiaNodeProperty> engineProperties = new HashMap<String, GWTJahiaNodeProperty>(engine.getProperties());
            for (GWTJahiaNodeProperty changed : changedProperties) {
                GWTJahiaNodeProperty prop = (GWTJahiaNodeProperty)engineProperties.get(changed.getName());
                if (prop == null) continue;
                prop.setValues(changed.getValues());
            }
            properties = new ArrayList(engineProperties.values());
        } else {
            properties = changedProperties;
        }
        JahiaContentManagementService.App.getInstance().createNode(modulePath, viewName, "jnt:viewFile", null, engine.getAcl(), properties, engine.changedI18NProperties, null, parentNodesType, false, new AsyncCallback<GWTJahiaNode>(){

            public void onFailure(Throwable throwable) {
                MessageBox.alert((String)Messages.get("label.error.processingRequestError", "An error occurred while processing your request"), (String)throwable.getMessage(), null).getDialog().addStyleName("engine-save-error");
            }

            public void onSuccess(GWTJahiaNode gwtJahiaNode) {
                Linker linker = engine.getLinker();
                engine.close();
                if (newModuleNode == null) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("node", gwtJahiaNode);
                    linker.refresh(data);
                } else {
                    JahiaGWTParameters.setSiteNode(newModuleNode);
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("refreshAll", true);
                    linker.refresh(data);
                    MainModule.staticGoTo(gwtJahiaNode.getPath(), null);
                    SiteSwitcherActionItem.refreshAllSitesList(linker);
                }
            }
        });
    }

    @Override
    protected void prepareAndSave(AbstractContentEngine engine, boolean closeAfterSave) {
    }
}

