/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.BoxComponent;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.HashMap;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.wcag.WCAGValidationResult;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.GWTCompositeConstraintViolationException;
import org.jahia.ajax.gwt.client.service.GWTConstraintViolationException;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.widget.contentengine.AbstractContentEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.ButtonItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineValidation;
import org.jahia.ajax.gwt.client.widget.contentengine.PropertiesTabItem;
import org.jahia.ajax.gwt.client.widget.definition.PropertiesEditor;
import org.jahia.ajax.gwt.client.widget.form.CKEditorField;

public abstract class SaveButtonItem
implements ButtonItem {
    @Override
    public BoxComponent create(final AbstractContentEngine engine) {
        Button button = new Button(Messages.get("label.save"));
        button.addStyleName("button-save");
        button.setHeight(24);
        button.setIcon(StandardIconsProvider.STANDARD_ICONS.engineButtonOK());
        button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                SaveButtonItem.this.save(engine, true, false);
            }
        });
        return button;
    }

    protected void save(final AbstractContentEngine engine, final boolean closeAfterSave, boolean skipValidation) {
        engine.setWorkInProgressProperty();
        engine.mask(Messages.get("label.saving", "Saving..."), "x-mask-loading");
        engine.setButtonsEnabled(false);
        if (skipValidation || this.validateData(engine, closeAfterSave)) {
            HashMap<String, String> textForWCAGValidation = null;
            Map<String, CKEditorField> toValidate = null;
            if (!skipValidation && (engine.getNode() != null && engine.getNode().isWCAGComplianceCheckEnabled() || engine.getNode() == null && engine.getTargetNode().isWCAGComplianceCheckEnabled())) {
                toValidate = this.getFieldsForWCAGValidation(engine);
                textForWCAGValidation = new HashMap<String, String>(toValidate.size());
                for (Map.Entry<String, CKEditorField> fieldEntry : toValidate.entrySet()) {
                    textForWCAGValidation.put(fieldEntry.getKey(), fieldEntry.getValue().getRawValue());
                }
            }
            if (textForWCAGValidation != null && !textForWCAGValidation.isEmpty()) {
                final Map<String, CKEditorField> fieldsForValidation = toValidate;
                JahiaContentManagementService.App.getInstance().validateWCAG(textForWCAGValidation, (AsyncCallback<Map<String, WCAGValidationResult>>)new BaseAsyncCallback<Map<String, WCAGValidationResult>>(){

                    public void onSuccess(Map<String, WCAGValidationResult> result) {
                        boolean wcagOK = true;
                        for (Map.Entry<String, WCAGValidationResult> wcagEntry : result.entrySet()) {
                            if (wcagEntry.getValue().isEmpty()) continue;
                            wcagOK = false;
                            CKEditorField fld = (CKEditorField)((Object)fieldsForValidation.get(wcagEntry.getKey()));
                            if (fld == null) continue;
                            fld.setWcagValidationResult(wcagEntry.getValue());
                        }
                        if (wcagOK) {
                            SaveButtonItem.this.prepareAndSave(engine, closeAfterSave);
                        } else {
                            SaveButtonItem.this.validateData(engine, closeAfterSave);
                        }
                    }

                    @Override
                    public void onApplicationFailure(Throwable caught) {
                        super.onApplicationFailure(caught);
                        SaveButtonItem.this.prepareAndSave(engine, closeAfterSave);
                    }
                });
            } else {
                this.prepareAndSave(engine, closeAfterSave);
            }
        }
    }

    protected boolean validateData(final AbstractContentEngine engine, final boolean closeAfterSave) {
        EngineValidation e = new EngineValidation(engine, engine.getTabs(), engine.getSelectedLanguage(), engine.getChangedI18NProperties());
        EngineValidation.ValidateCallback callback = new EngineValidation.ValidateCallback(){

            @Override
            public void handleValidationResult(EngineValidation.ValidateResult result) {
                SaveButtonItem.this.handleValidationResult(engine, result);
            }

            @Override
            public void saveAnyway() {
                SaveButtonItem.this.save(engine, closeAfterSave, true);
            }

            @Override
            public void close() {
                engine.unmask();
                engine.setButtonsEnabled(true);
            }
        };
        return e.validateData(callback);
    }

    private void handleValidationResult(AbstractContentEngine engine, EngineValidation.ValidateResult r) {
        if (r.errorLang != null) {
            for (GWTJahiaLanguage jahiaLanguage : engine.getLanguageSwitcher().getStore().getModels()) {
                if (!jahiaLanguage.getLanguage().equals(r.errorLang)) continue;
                engine.getLanguageSwitcher().setValue((ModelData)jahiaLanguage);
                break;
            }
        }
        if (r.errorTab != null && !engine.getTabs().getSelectedItem().equals(r.errorTab)) {
            engine.getTabs().setSelection(r.errorTab);
        }
        if (r.errorField != null) {
            r.errorField.focus();
        }
        if (r.errorTab != null) {
            r.errorTab.layout();
        }
    }

    protected Map<String, CKEditorField> getFieldsForWCAGValidation(AbstractContentEngine engine) {
        HashMap<String, CKEditorField> fieldsToValidate = new HashMap<String, CKEditorField>();
        for (TabItem tab : engine.getTabs().getItems()) {
            EditEngineTabItem item = (EditEngineTabItem)tab.getData("item");
            if (!(item instanceof PropertiesTabItem)) continue;
            Map<String, PropertiesEditor> langPropertiesEditorMap = ((PropertiesTabItem)item).getLangPropertiesEditorMap();
            for (PropertiesEditor pe : langPropertiesEditorMap.values()) {
                if (pe == null) continue;
                for (PropertiesEditor.PropertyAdapterField adapterField : pe.getFieldsMap().values()) {
                    String text;
                    CKEditorField ckfield;
                    Field<?> field = adapterField.getField();
                    if (!(field instanceof CKEditorField) || !field.isEnabled() || field.isReadOnly() || !((FieldSet)adapterField.getParent()).isExpanded() || (ckfield = (CKEditorField)field).isIgnoreWcagWarnings()) continue;
                    if (ckfield.getItemId() == null) {
                        ckfield.setItemId("CKEditorField-" + (fieldsToValidate.size() + 1));
                    }
                    if ((text = ckfield.getRawValue()) == null || text.trim().length() <= 0) continue;
                    fieldsToValidate.put(field.getItemId(), ckfield);
                }
            }
        }
        return fieldsToValidate;
    }

    protected abstract void prepareAndSave(AbstractContentEngine var1, boolean var2);

    protected void failSave(final AbstractContentEngine engine, Throwable throwable) {
        if (throwable instanceof GWTCompositeConstraintViolationException) {
            final GWTCompositeConstraintViolationException cve = (GWTCompositeConstraintViolationException)throwable;
            StringBuilder nodeLevelMessages = new StringBuilder();
            boolean hasFieldErrors = false;
            for (GWTConstraintViolationException violationException : cve.getErrors()) {
                if (violationException.getPropertyName() == null || violationException.getPropertyName().equals("")) {
                    nodeLevelMessages.append("<br>").append(violationException.getConstraintMessage());
                    continue;
                }
                hasFieldErrors = true;
            }
            final boolean fHasFieldErrors = hasFieldErrors;
            MessageBox.alert((String)Messages.get("label.error", "Error"), (String)((hasFieldErrors ? Messages.get("failure.invalid.constraint.label", "There are some validation errors! Click on the information icon next to the highlighted fields, correct the input and save again.") : "") + nodeLevelMessages.toString()), (Listener)new Listener<MessageBoxEvent>(){

                public void handleEvent(MessageBoxEvent be) {
                    if (fHasFieldErrors) {
                        EngineValidation e = new EngineValidation(engine, engine.getTabs(), engine.getSelectedLanguage(), engine.getChangedI18NProperties());
                        EngineValidation.ValidateResult r = e.getValidationFromException(cve.getErrors());
                        SaveButtonItem.this.handleValidationResult(engine, r);
                    }
                }
            }).getDialog().addStyleName("engine-save-error");
        } else {
            String message = throwable.getMessage();
            MessageBox.alert((String)Messages.get("label.error"), (String)(Messages.get("failure.properties.save", "Properties save failed") + "\n\n" + message), null).getDialog().addStyleName("engine-save-error");
            Log.error((String)"failed", (Throwable)throwable);
        }
        engine.unmask();
        engine.setButtonsEnabled(true);
    }
}

