/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.mainarea;

import com.extjs.gxt.ui.client.core.El;
import com.extjs.gxt.ui.client.dnd.DND;
import com.extjs.gxt.ui.client.dnd.DropTarget;
import com.extjs.gxt.ui.client.dnd.Insert;
import com.extjs.gxt.ui.client.event.DNDEvent;
import com.extjs.gxt.ui.client.util.Rectangle;
import com.extjs.gxt.ui.client.widget.Component;
import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.Element;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.Module;

public class ModuleDropTarget
extends DropTarget {
    private Module module;
    protected String targetType;

    public ModuleDropTarget(Module target, String targetType) {
        super((Component)target.getContainer());
        this.module = target;
        this.setOperation(DND.Operation.COPY);
        this.targetType = targetType;
    }

    public Module getModule() {
        return this.module;
    }

    protected void onDragMove(DNDEvent event) {
        super.onDragMove(event);
        event.setCancelled(false);
    }

    protected void showFeedback(DNDEvent event) {
        this.showInsert(event, this.getComponent().getElement(), true);
    }

    private void showInsert(DNDEvent event, Element row, boolean before) {
        if (PermissionsUtils.isPermitted("jcr:addChildNodes", this.module.getParentModule().getNode()) && !this.module.getParentModule().getNode().isLocked().booleanValue()) {
            Insert insert = Insert.get();
            insert.setVisible(true);
            MainModule.getInstance().getInnerElement().appendChild((Node)insert.getElement());
            Rectangle rect = El.fly((Element)row).getBounds();
            int y = !before ? rect.y + rect.height - 4 : rect.y - 2;
            insert.el().setBounds(rect.x, y, rect.width, 20);
        }
    }

    private boolean checkNodeType(DNDEvent e, String nodetypes) {
        boolean allowed = true;
        if (nodetypes != null && nodetypes.length() > 0) {
            GWTJahiaNodeType type;
            List sources = (List)e.getStatus().getData("sourceNodes");
            if (sources != null) {
                String[] allowedTypes = nodetypes.split(" |,");
                for (GWTJahiaNode source : sources) {
                    boolean nodeAllowed = false;
                    String[] stringArray = allowedTypes;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String type2 = stringArray[i];
                        if (!source.isNodeType(type2) && (!source.isReference() || source.getReferencedNode() == null || !source.getReferencedNode().isNodeType(type2))) continue;
                        nodeAllowed = true;
                        break;
                    }
                    allowed &= nodeAllowed;
                }
            }
            if ((type = (GWTJahiaNodeType)e.getStatus().getData("sourceNodeType")) != null) {
                String[] allowedTypes = nodetypes.split(" ");
                boolean typeAllowed = false;
                for (String t : allowedTypes) {
                    if (type.isMixin() || !t.equals(type.getName()) && !type.getSuperTypes().contains(t)) continue;
                    typeAllowed = true;
                    break;
                }
                allowed &= typeAllowed;
            }
        }
        return allowed;
    }

    protected void onDragEnter(DNDEvent e) {
        Module parentModule = this.module.getParentModule();
        GWTJahiaNode jahiaNode = parentModule.getNode();
        if (PermissionsUtils.isPermitted("jcr:addChildNodes", jahiaNode) && !jahiaNode.isLocked().booleanValue()) {
            boolean allowed;
            List sources;
            String nodetypes = parentModule.getNodeTypes();
            if (this.targetType.equals("placeholder") && this.module.getNodeTypes() != null && this.module.getNodeTypes().length() > 0) {
                nodetypes = this.module.getNodeTypes();
            }
            int listLimit = parentModule.getListLimit();
            int childCount = parentModule.getChildCount();
            if ("emptyarea".equals(this.targetType)) {
                nodetypes = this.module.getNodeTypes();
                listLimit = this.module.getListLimit();
                childCount = this.module.getChildCount();
            }
            int totalCount = childCount + ((sources = (List)e.getStatus().getData("sourceNodes")) == null ? 1 : sources.size());
            if (e.getStatus().getData("sourceModules") != null) {
                Set modules = (Set)e.getStatus().getData("sourceModules");
                for (Module moduleToCopy : modules) {
                    if (!((Object)((Object)parentModule)).equals((Object)moduleToCopy.getParentModule())) continue;
                    --totalCount;
                }
            }
            if (totalCount > listLimit && listLimit != -1) {
                e.getStatus().setStatus(false);
                e.setCancelled(false);
                return;
            }
            boolean bl = allowed = !"content".equals(e.getStatus().getData("sourceType")) && this.checkNodeType(e, nodetypes);
            if (allowed) {
                e.getStatus().setData("targetType", (Object)this.targetType);
                e.getStatus().setData("targetRefType", null);
                e.getStatus().setData("targetPath", (Object)this.module.getPath());
                e.getStatus().setData("targetNode", (Object)(this.module.getNode() != null ? this.module.getNode() : jahiaNode));
            } else {
                String refTypes = parentModule.getReferenceTypes();
                if (this.targetType.equals("emptyarea")) {
                    refTypes = this.module.getReferenceTypes();
                } else if (this.targetType.equals("placeholder") && this.module.getReferenceTypes() != null) {
                    refTypes = this.module.getReferenceTypes();
                }
                if (refTypes.length() > 0 && e.getStatus().getData("sourceNodes") != null) {
                    String[] refs = refTypes.split(" ");
                    ArrayList<String> allowedRefs = new ArrayList<String>();
                    for (String ref : refs) {
                        String[] types = ref.split("\\[|\\]");
                        if (!this.checkNodeType(e, types[1])) continue;
                        allowedRefs.add(types[0]);
                    }
                    if (allowedRefs.size() > 0) {
                        allowed = true;
                        e.getStatus().setData("targetType", (Object)this.targetType);
                        e.getStatus().setData("targetRefType", allowedRefs);
                        e.getStatus().setData("targetPath", (Object)this.module.getPath());
                        e.getStatus().setData("targetNode", (Object)(this.module.getNode() != null ? this.module.getNode() : jahiaNode));
                    }
                }
            }
            e.getStatus().setStatus(allowed);
            e.setCancelled(false);
        } else {
            e.getStatus().setStatus(false);
        }
    }
}

