/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.sidepanel;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelIconProvider;
import com.extjs.gxt.ui.client.dnd.DND;
import com.extjs.gxt.ui.client.dnd.TreeGridDropTarget;
import com.extjs.gxt.ui.client.event.DNDEvent;
import com.extjs.gxt.ui.client.event.DNDListener;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.VBoxLayout;
import com.extjs.gxt.ui.client.widget.layout.VBoxLayoutData;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGrid;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTSidePanelTab;
import org.jahia.ajax.gwt.client.util.icons.ContentModelIconProvider;
import org.jahia.ajax.gwt.client.widget.NodeColumnConfigList;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.SidePanelTabItem;
import org.jahia.ajax.gwt.client.widget.node.GWTJahiaNodeTreeFactory;

abstract class BrowseTabItem
extends SidePanelTabItem {
    protected List<String> folderTypes = new ArrayList<String>();
    protected List<String> excludedFolderTypes = new ArrayList<String>();
    private List<String> paths = new ArrayList<String>();
    protected transient LayoutContainer treeContainer;
    protected transient TreeGrid<GWTJahiaNode> tree;
    protected transient TreeGridDropTarget treeDropTarget;
    protected transient String repositoryType;
    protected transient GWTJahiaNodeTreeFactory factory;

    BrowseTabItem() {
    }

    @Override
    public TabItem create(GWTSidePanelTab config) {
        super.create(config);
        VBoxLayout l = new VBoxLayout();
        l.setVBoxLayoutAlign(VBoxLayout.VBoxLayoutAlign.STRETCH);
        this.tab.setLayout((Layout)l);
        this.treeContainer = new LayoutContainer();
        this.treeContainer.setBorders(false);
        this.treeContainer.setScrollMode(Style.Scroll.AUTO);
        this.treeContainer.setLayout((Layout)new FitLayout());
        this.factory = new GWTJahiaNodeTreeFactory(this.paths);
        this.factory.setNodeTypes(this.folderTypes);
        this.factory.setHiddenTypes(this.excludedFolderTypes);
        this.factory.setFields(config.getTreeColumnKeys());
        NodeColumnConfigList columns = new NodeColumnConfigList(config.getTreeColumns());
        columns.init();
        ((ColumnConfig)columns.get(0)).setRenderer(NodeColumnConfigList.NAME_TREEGRID_RENDERER);
        this.tree = this.factory.getTreeGrid(new ColumnModel((List)columns));
        this.tree.setAutoExpandColumn(columns.getAutoExpand());
        this.tree.getTreeView().setRowHeight(25);
        this.tree.getTreeView().setForceFit(true);
        this.tree.setHeight("100%");
        this.tree.setIconProvider((ModelIconProvider)ContentModelIconProvider.getInstance());
        this.treeContainer.add(this.tree);
        VBoxLayoutData treeVBoxData = new VBoxLayoutData();
        treeVBoxData.setFlex(1.0);
        this.tab.add((Widget)this.treeContainer, (LayoutData)treeVBoxData);
        return this.tab;
    }

    @Override
    public void initWithLinker(EditLinker linker) {
        super.initWithLinker(linker);
        if (linker.getConfig().isDragAndDropEnabled()) {
            this.treeDropTarget = new BrowseTreeGridDropTarget();
            this.treeDropTarget.addDNDListener((DNDListener)linker.getDndListener());
            this.treeDropTarget.setAllowDropOnLeaf(true);
            this.treeDropTarget.setAllowSelfAsSource(false);
            this.treeDropTarget.setAutoExpand(true);
            this.treeDropTarget.setFeedback(DND.Feedback.APPEND);
        }
    }

    @Override
    public boolean needRefresh(Map<String, Object> data) {
        return data.containsKey("event") && ("unmount".equals(data.get("event")) || "fileUploaded".equals(data.get("event")) || "publicationSuccess".equals(data.get("event")) || "browseTreeGridDrop".equals(data.get("event")));
    }

    @Override
    public void doRefresh() {
        List<String> selectedPath = this.factory.getSelectedPath();
        this.factory.getStore().removeAll();
        this.factory.setSelectedPath(selectedPath);
        this.factory.getLoader().load();
    }

    protected abstract boolean acceptNode(GWTJahiaNode var1);

    public List<String> getFolderTypes() {
        return this.folderTypes;
    }

    public void setFolderTypes(List<String> folderTypes) {
        this.folderTypes = folderTypes;
    }

    public List<String> getExcludedFolderTypes() {
        return this.excludedFolderTypes;
    }

    public void setExcludedFolderTypes(List<String> excludedFolderTypes) {
        this.excludedFolderTypes = excludedFolderTypes;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    class BrowseTreeGridDropTarget
    extends TreeGridDropTarget {
        public BrowseTreeGridDropTarget() {
            super(BrowseTabItem.this.tree);
        }

        protected void onDragEnter(DNDEvent e) {
            super.onDragEnter(e);
            this.setStatus(e);
        }

        private void setStatus(DNDEvent e) {
            if ("simpleModule".equals(e.getStatus().getData("sourceType"))) {
                List nodes = (List)e.getStatus().getData("sourceNodes");
                if (BrowseTabItem.this.acceptNode((GWTJahiaNode)nodes.get(0))) {
                    e.getStatus().setData("targetType", (Object)"browseTree");
                    e.getStatus().setStatus(true);
                } else {
                    e.getStatus().setStatus(false);
                }
            } else {
                e.getStatus().setStatus(false);
            }
            e.setCancelled(false);
        }

        protected void showFeedback(DNDEvent e) {
            super.showFeedback(e);
            this.setStatus(e);
            if (this.activeItem != null) {
                GWTJahiaNode activeNode = (GWTJahiaNode)this.activeItem.getModel();
                e.getStatus().setData("targetPath", activeNode.get("path"));
            } else {
                e.getStatus().setData("targetPath", null);
            }
        }

        public AsyncCallback<Object> getCallback() {
            BaseAsyncCallback<Object> callback = new BaseAsyncCallback<Object>(){

                public void onSuccess(Object o) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("event", "browseTreeGridDrop");
                    BrowseTabItem.this.refresh(data);
                }
            };
            return callback;
        }
    }
}

