/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.sidepanel;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.dnd.GridDragSource;
import com.extjs.gxt.ui.client.dnd.GridDropTarget;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.DNDEvent;
import com.extjs.gxt.ui.client.event.DNDListener;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.StoreSorter;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.VBoxLayout;
import com.extjs.gxt.ui.client.widget.layout.VBoxLayoutData;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTSidePanelTab;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.Collator;
import org.jahia.ajax.gwt.client.util.icons.ToolbarIconProvider;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.SidePanelTabItem;

class DependenciesTabItem
extends SidePanelTabItem {
    protected transient Grid<GWTJahiaNode> availableModules;
    protected transient ToolBar buttonBar;
    protected transient Grid<GWTJahiaNode> dependencyModules;
    protected transient ListStore modulesStore;
    protected transient ListStore dependenciesStore;
    protected GWTJahiaNode curentModuleVersion;

    DependenciesTabItem() {
    }

    @Override
    public TabItem create(GWTSidePanelTab config) {
        super.create(config);
        VBoxLayout l = new VBoxLayout();
        l.setVBoxLayoutAlign(VBoxLayout.VBoxLayoutAlign.STRETCH);
        this.tab.setLayout((Layout)l);
        StoreSorter storeSorter = new StoreSorter((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    return Collator.getInstance().localeCompare(s1, s2);
                }
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return 0;
            }
        });
        StoreSorter availableModulestoreSorter = new StoreSorter((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    return Collator.getInstance().localeCompare(s1, s2);
                }
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return 0;
            }
        });
        this.modulesStore = new ListStore();
        this.modulesStore.setStoreSorter(availableModulestoreSorter);
        this.modulesStore.setSortField("displayName");
        this.modulesStore.setSortDir(Style.SortDir.ASC);
        this.dependenciesStore = new ListStore();
        this.dependenciesStore.setStoreSorter(storeSorter);
        this.dependenciesStore.setSortField("displayName");
        this.dependenciesStore.setSortDir(Style.SortDir.ASC);
        this.loadStores();
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setId("displayName");
        columnConfig.setHeaderHtml(Messages.get("label.module", "Module"));
        this.availableModules = new Grid(this.modulesStore, new ColumnModel(Arrays.asList(columnConfig)));
        this.availableModules.setAutoExpandColumn("displayName");
        new GridDragSource(this.availableModules);
        new GridDropTarget(this.availableModules).addDNDListener(new DNDListener(){

            public void dragDrop(DNDEvent e) {
                DependenciesTabItem.this.saveDependencies();
            }
        });
        LayoutContainer modulesContainer = new LayoutContainer();
        modulesContainer.setBorders(false);
        modulesContainer.setScrollMode(Style.Scroll.AUTO);
        modulesContainer.setLayout((Layout)new FitLayout());
        modulesContainer.add(this.availableModules);
        VBoxLayoutData modulesVBoxData = new VBoxLayoutData();
        modulesVBoxData.setFlex(1.0);
        this.tab.add((Widget)modulesContainer, (LayoutData)modulesVBoxData);
        this.buttonBar = new ToolBar();
        this.buttonBar.setAlignment(Style.HorizontalAlignment.CENTER);
        Button up = new Button();
        up.setIcon(ToolbarIconProvider.getInstance().getIcon("sort_up_minus"));
        up.setToolTip(Messages.get("label.removeDependency", "Click to remove the dependency"));
        up.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                DependenciesTabItem.this.removeDependencies();
            }
        });
        this.buttonBar.add((Component)up);
        Button down = new Button();
        down.setIcon(ToolbarIconProvider.getInstance().getIcon("sort_down_plus"));
        down.setToolTip(Messages.get("label.addDependency", "Click to add a dependency"));
        down.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                DependenciesTabItem.this.addDependencies();
            }
        });
        this.buttonBar.add((Component)down);
        this.tab.add((Widget)this.buttonBar);
        columnConfig = new ColumnConfig();
        columnConfig.setId("displayName");
        columnConfig.setHeaderHtml(Messages.get("label.dependency", "Dependency"));
        this.dependencyModules = new Grid(this.dependenciesStore, new ColumnModel(Arrays.asList(columnConfig)));
        this.dependencyModules.setAutoExpandColumn("displayName");
        new GridDragSource(this.dependencyModules);
        new GridDropTarget(this.dependencyModules).addDNDListener(new DNDListener(){

            public void dragDrop(DNDEvent e) {
                DependenciesTabItem.this.saveDependencies();
            }
        });
        LayoutContainer dependenciesContainer = new LayoutContainer();
        dependenciesContainer.setBorders(false);
        dependenciesContainer.setScrollMode(Style.Scroll.AUTO);
        dependenciesContainer.setLayout((Layout)new FitLayout());
        dependenciesContainer.add(this.dependencyModules);
        VBoxLayoutData dependenciesVBoxData = new VBoxLayoutData();
        dependenciesVBoxData.setFlex(1.0);
        this.tab.add((Widget)dependenciesContainer, (LayoutData)dependenciesVBoxData);
        this.dependencyModules.addListener(Events.CellDoubleClick, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                DependenciesTabItem.this.removeDependencies();
            }
        });
        this.availableModules.addListener(Events.CellDoubleClick, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                DependenciesTabItem.this.addDependencies();
            }
        });
        return this.tab;
    }

    protected void loadStores() {
        final GWTJahiaNode currentModule = JahiaGWTParameters.getSiteNode();
        if (!currentModule.getNodeTypes().contains("jnt:module")) {
            return;
        }
        String version = (String)currentModule.get("j:versionInfo");
        JahiaContentManagementService.App.getInstance().getNodes(Arrays.asList(currentModule.getPath() + "/" + version), Arrays.asList("j:dependencies"), (AsyncCallback<List<GWTJahiaNode>>)new BaseAsyncCallback<List<GWTJahiaNode>>(){

            public void onSuccess(List<GWTJahiaNode> gwtJahiaNodes) {
                if (gwtJahiaNodes.isEmpty()) {
                    return;
                }
                DependenciesTabItem.this.curentModuleVersion = gwtJahiaNodes.get(0);
                List dependencies = (List)DependenciesTabItem.this.curentModuleVersion.get("j:dependencies");
                if (dependencies == null) {
                    return;
                }
                Collection<GWTJahiaNode> modules = JahiaGWTParameters.getSitesMap().values();
                for (GWTJahiaNode module : modules) {
                    if (currentModule.getName().equals(module.getName())) continue;
                    if (dependencies.contains(module.getName())) {
                        DependenciesTabItem.this.dependenciesStore.add((ModelData)module);
                        continue;
                    }
                    DependenciesTabItem.this.modulesStore.add((ModelData)module);
                }
            }
        });
    }

    protected void removeDependencies() {
        List modules = this.dependencyModules.getSelectionModel().getSelectedItems();
        for (GWTJahiaNode module : modules) {
            this.dependencyModules.getStore().remove((ModelData)module);
        }
        if (!modules.isEmpty()) {
            this.availableModules.getStore().add(modules);
            this.saveDependencies();
        }
    }

    protected void addDependencies() {
        List modules = this.availableModules.getSelectionModel().getSelectedItems();
        for (GWTJahiaNode module : modules) {
            this.availableModules.getStore().remove((ModelData)module);
        }
        if (!modules.isEmpty()) {
            this.dependencyModules.getStore().add(modules);
            this.saveDependencies();
        }
    }

    protected void saveDependencies() {
        ArrayList<GWTJahiaNodeProperty> properties = new ArrayList<GWTJahiaNodeProperty>();
        GWTJahiaNodeProperty gwtJahiaNodeProperty = new GWTJahiaNodeProperty();
        gwtJahiaNodeProperty.setName("j:dependencies");
        ArrayList<GWTJahiaNodePropertyValue> values = new ArrayList<GWTJahiaNodePropertyValue>();
        for (GWTJahiaNode node : this.dependencyModules.getStore().getModels()) {
            values.add(new GWTJahiaNodePropertyValue(node.getName(), 1));
        }
        gwtJahiaNodeProperty.setMultiple(true);
        gwtJahiaNodeProperty.setValues(values);
        properties.add(gwtJahiaNodeProperty);
        this.buttonBar.mask(Messages.get("label.saving", "Saving..."));
        JahiaContentManagementService.App.getInstance().saveProperties(Arrays.asList(this.curentModuleVersion), properties, null, new BaseAsyncCallback(){

            public void onSuccess(Object result) {
                DependenciesTabItem.this.buttonBar.unmask();
            }

            @Override
            public void onApplicationFailure(Throwable caught) {
                DependenciesTabItem.this.buttonBar.unmask();
            }
        });
    }

    @Override
    public boolean needRefresh(Map<String, Object> data) {
        return super.needRefresh(data);
    }

    @Override
    public void doRefresh() {
        this.modulesStore.removeAll();
        this.dependenciesStore.removeAll();
        this.loadStores();
    }
}

