/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.sidepanel;

import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.IconButtonEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.event.TabPanelEvent;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.button.ToolButton;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.storage.client.Storage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEditConfiguration;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.data.toolbar.GWTSidePanelTab;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.ToolbarHeader;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.Module;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.SidePanelTabItem;
import org.jahia.ajax.gwt.client.widget.toolbar.action.SiteSwitcherActionItem;

public class SidePanel
extends ContentPanel {
    private final List<SidePanelTabItem> tabs;
    private GWTEditConfiguration config;
    private ToolButton refreshButton;
    private TabPanel tabPanel;

    public SidePanel(GWTEditConfiguration config) {
        super((Layout)new FitLayout());
        this.head = new ToolbarHeader();
        this.tabs = new ArrayList<SidePanelTabItem>();
        this.initTabs(config);
    }

    public void initTabs(GWTEditConfiguration config) {
        this.removeAll();
        this.tabs.clear();
        this.config = config;
        final Storage storage = Storage.getSessionStorageIfSupported();
        this.tabPanel = new TabPanel();
        this.tabPanel.setBorders(false);
        this.tabPanel.setBodyBorder(false);
        this.tabPanel.setId("JahiaGxtSidePanelTabs");
        this.tabPanel.addListener(Events.Select, (Listener)new Listener<TabPanelEvent>(){

            public void handleEvent(TabPanelEvent be) {
                SidePanelTabItem selectedTab = (SidePanelTabItem)SidePanel.this.tabPanel.getSelectedItem().getData("tabItem");
                selectedTab.refresh(selectedTab.getAutoRefreshData());
                SidePanel.this.updateRefreshButton();
                if (storage != null) {
                    storage.setItem(SidePanel.this.config.getName() + "_selectedTab", Integer.toString(SidePanel.this.tabPanel.getItems().indexOf(SidePanel.this.tabPanel.getSelectedItem())));
                }
            }
        });
        int selectedTab = 0;
        if (storage != null && storage.getItem(config.getName() + "_selectedTab") != null) {
            selectedTab = Integer.parseInt(storage.getItem(config.getName() + "_selectedTab"));
        }
        for (GWTSidePanelTab tabConfig : config.getTabs()) {
            SidePanelTabItem tabItem = tabConfig.getTabItem();
            this.tabs.add(tabItem);
            this.tabPanel.add(tabItem.create(tabConfig));
        }
        this.tabPanel.setSelection((TabItem)this.tabPanel.getItem(selectedTab));
        this.add((Component)this.tabPanel);
    }

    public void initWithLinker(final EditLinker editLinker) {
        Component collapse = null;
        if (this.head.getTools().size() == 1) {
            HorizontalPanel hp = (HorizontalPanel)this.head.getTools().get(0);
            collapse = hp.getItem(hp.getItemCount() - 1);
        }
        ((ToolbarHeader)this.head).removeAllTools();
        if (this.config.getSidePanelToolbar() != null) {
            for (GWTJahiaToolbarItem item : this.config.getSidePanelToolbar().getGwtToolbarItems()) {
                ((ToolbarHeader)this.head).addItem(editLinker, item);
            }
        }
        this.refreshButton = new ToolButton("x-tool-refresh", (SelectionListener)new SelectionListener<IconButtonEvent>(){

            public void componentSelected(IconButtonEvent event) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("refreshAll", true);
                if (SidePanel.this.tabs.size() == 1) {
                    ((SidePanelTabItem)SidePanel.this.tabs.get(0)).refresh(data);
                } else {
                    ((SidePanelTabItem)SidePanel.this.tabPanel.getSelectedItem().getData("tabItem")).refresh(data);
                }
                SidePanel.this.updateRefreshButton();
                SiteSwitcherActionItem.reloadAndRefreshAllSitesList(SidePanel.this.config.getSitesLocation(), editLinker);
            }
        });
        this.refreshButton.setId("JahiaGxtRefreshSidePanelButton");
        this.head.addTool((Component)this.refreshButton);
        if (collapse != null) {
            this.head.addTool(collapse);
        }
        ((ToolbarHeader)this.head).attachTools();
        for (SidePanelTabItem tab : this.tabs) {
            tab.initWithLinker(editLinker);
        }
        this.layout();
    }

    public void enable() {
        for (SidePanelTabItem tab : this.tabs) {
            tab.enable();
        }
    }

    public void disable() {
        for (SidePanelTabItem tab : this.tabs) {
            tab.disable();
        }
    }

    private void updateRefreshButton() {
        if (this.tabPanel.getSelectedItem() != null) {
            boolean needRefresh = ((SidePanelTabItem)this.tabPanel.getSelectedItem().getData("tabItem")).isNeedManualRefresh();
            if (needRefresh && !this.refreshButton.getStyleName().contains("x-tool-refresh-red")) {
                this.refreshButton.setToolTip(Messages.get("label.refresh.modify"));
                this.refreshButton.removeStyleName("x-tool-refresh");
                this.refreshButton.addStyleName("x-tool-refresh-red");
            } else if (!needRefresh && this.refreshButton.getStyleName().contains("x-tool-refresh-red")) {
                this.refreshButton.removeStyleName("x-tool-refresh-red");
                this.refreshButton.addStyleName("x-tool-refresh");
                this.refreshButton.removeToolTip();
            }
        }
    }

    public void handleNewModuleSelection(Module selectedModule) {
        for (SidePanelTabItem tab : this.tabs) {
            tab.handleNewModuleSelection(selectedModule);
        }
        ((ToolbarHeader)this.head).handleNewLinkerSelection();
    }

    public void handleNewMainNodeLoaded(GWTJahiaNode node) {
        for (SidePanelTabItem tab : this.tabs) {
            tab.handleNewMainNodeLoaded(node);
        }
        ((ToolbarHeader)this.head).handleNewMainNodeLoaded(node);
        this.layout();
    }

    public void handleNewMainSelection(String path) {
        for (SidePanelTabItem tab : this.tabs) {
            tab.handleNewMainSelection(path);
        }
        ((ToolbarHeader)this.head).handleNewLinkerSelection();
    }

    public void markForManualRefresh(Map<String, Object> data) {
        for (SidePanelTabItem tab : this.tabs) {
            tab.markForManualRefresh(data);
        }
        this.updateRefreshButton();
    }

    public void refresh(Map<String, Object> data) {
        if (this.tabPanel.getSelectedItem() != null) {
            SidePanelTabItem selected = (SidePanelTabItem)this.tabPanel.getSelectedItem().getData("tabItem");
            for (SidePanelTabItem tab : this.tabs) {
                if (tab == selected) {
                    tab.refresh(data);
                    continue;
                }
                tab.markForAutoRefresh(data);
            }
            this.updateRefreshButton();
        }
    }

    public void setConfig(GWTEditConfiguration config) {
        this.config = config;
        this.setVisible(!config.getTabs().isEmpty());
        this.tabPanel.unmask();
        this.initTabs(config);
    }
}

