/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.form;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FormEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.FileUploadField;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.HiddenField;
import com.google.gwt.i18n.client.Dictionary;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HTML;
import org.jahia.ajax.gwt.client.messages.Messages;

public abstract class FormDeployPortletDefinition
extends FormPanel {
    private boolean doCloseParent = true;

    public FormDeployPortletDefinition() {
        this.createUI();
    }

    protected void createUI() {
        this.setAction(FormDeployPortletDefinition.getPortletDeploymentParam("formActionUrl"));
        this.setEncoding(FormPanel.Encoding.MULTIPART);
        this.setMethod(FormPanel.Method.POST);
        this.setBodyBorder(false);
        this.setFrame(false);
        this.setAutoHeight(true);
        this.setHeaderVisible(false);
        this.setButtonAlign(Style.HorizontalAlignment.CENTER);
        this.setStyleAttribute("padding", "4");
        this.setLabelWidth(200);
        this.setFieldWidth(300);
        final FileUploadField portletDefinitionField = new FileUploadField();
        portletDefinitionField.setAllowBlank(false);
        portletDefinitionField.setName("portletDefinition");
        portletDefinitionField.setWidth(290);
        portletDefinitionField.setFieldLabel(Messages.get("org.jahia.engines.PortletsManager.wizard.upload.label", "Portlets WAR file"));
        this.add((Component)portletDefinitionField);
        final HiddenField preparePortlet = new HiddenField();
        preparePortlet.setName("doPrepare");
        preparePortlet.setValue((Object)false);
        this.add((Component)preparePortlet);
        final HiddenField deployPortlet = new HiddenField();
        deployPortlet.setName("doDeploy");
        deployPortlet.setValue((Object)false);
        this.add((Component)deployPortlet);
        HiddenField jcrReturnContentType = new HiddenField();
        jcrReturnContentType.setName("jcrReturnContentType");
        jcrReturnContentType.setValue((Object)"json");
        this.add((Component)jcrReturnContentType);
        Button prepareButton = new Button(Messages.get("label.portletPrepareWar", "Prepare"));
        prepareButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                preparePortlet.setValue((Object)true);
                FormDeployPortletDefinition.this.doCloseParent = true;
                FormDeployPortletDefinition.this.submitAfterValidation(portletDefinitionField);
            }
        });
        this.addButton(prepareButton);
        final boolean autoDeploySupported = FormDeployPortletDefinition.autoDeploySupported();
        Button deployButton = new Button(Messages.get("label.deployNewPortlet", "Deploy"));
        deployButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                if (autoDeploySupported) {
                    deployPortlet.setValue((Object)true);
                    FormDeployPortletDefinition.this.doCloseParent = true;
                    FormDeployPortletDefinition.this.submitAfterValidation(portletDefinitionField);
                } else {
                    FormDeployPortletDefinition.this.doCloseParent = false;
                    Window.open((String)FormDeployPortletDefinition.getAppserverDeployerUrl(), (String)"_blank", (String)"");
                }
            }
        });
        this.addButton(deployButton);
        if (autoDeploySupported) {
            Button prepareAndDeployButton = new Button(Messages.get("label.prepareAndDeployWar", "Prepare and deploy"));
            prepareAndDeployButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent ce) {
                    deployPortlet.setValue((Object)true);
                    preparePortlet.setValue((Object)true);
                    FormDeployPortletDefinition.this.doCloseParent = true;
                    FormDeployPortletDefinition.this.submitAfterValidation(portletDefinitionField);
                }
            });
            this.addButton(prepareAndDeployButton);
        }
        Button helpButton = new Button("?");
        helpButton.setWidth(30);
        helpButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent buttonEvent) {
                deployPortlet.setValue((Object)false);
                preparePortlet.setValue((Object)false);
                FormDeployPortletDefinition.this.doCloseParent = false;
                FormDeployPortletDefinition.this.submit();
            }
        });
        this.addButton(helpButton);
        final FormDeployPortletDefinition form = this;
        this.addListener(Events.BeforeSubmit, (Listener)new Listener<FormEvent>(){

            public void handleEvent(FormEvent formEvent) {
                form.mask(Messages.get("label.loading", "Loading..."));
            }
        });
        this.addListener(Events.Submit, (Listener)new Listener<FormEvent>(){

            public void handleEvent(FormEvent formEvent) {
                JSONValue rspValue;
                HTML responseHTML;
                String response;
                if (FormDeployPortletDefinition.this.doCloseParent) {
                    FormDeployPortletDefinition.this.closeParent();
                }
                if (!(response = (responseHTML = new HTML(formEvent.getResultHtml())).getText()).trim().isEmpty() && (rspValue = JSONParser.parseStrict((String)response)) != null && rspValue.isObject() != null && rspValue.isObject().containsKey("dspMsg")) {
                    String dspMsg = rspValue.isObject().get("dspMsg").isString().stringValue();
                    MessageBox.info((String)Messages.get("label.deployNewPortlet", "Deploy new portlets"), (String)dspMsg, (Listener)new Listener<MessageBoxEvent>(){

                        public void handleEvent(MessageBoxEvent be) {
                            FormDeployPortletDefinition.this.refreshParent();
                        }
                    });
                }
                form.unmask();
            }
        });
        this.layout();
    }

    private void submitAfterValidation(FileUploadField portletDefinitionField) {
        if (portletDefinitionField.getValue() != null && ((String)portletDefinitionField.getValue()).length() > 0) {
            this.submit();
        } else {
            MessageBox.alert((String)Messages.get("label.deployNewPortlet", "Deploy new portlets"), (String)Messages.get("message.selectFileForUpload", "Please select a *.war file"), null);
        }
    }

    public static String getPortletDeploymentParam(String key) {
        try {
            Dictionary dictionary = Dictionary.getDictionary((String)"portletDeployment");
            return dictionary.get(key.replace('.', '_'));
        }
        catch (Exception e) {
            Log.error((String)("Can't retrieve [" + key + "]"), (Throwable)e);
            return key;
        }
    }

    public static boolean autoDeploySupported() {
        try {
            return Boolean.valueOf(FormDeployPortletDefinition.getPortletDeploymentParam("autoDeploySupported"));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getAppserverDeployerUrl() {
        try {
            return FormDeployPortletDefinition.getPortletDeploymentParam("appserverDeployerUrl");
        }
        catch (Exception e) {
            return "";
        }
    }

    public abstract void closeParent();

    public abstract void refreshParent();
}

