/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.publication;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import java.util.HashMap;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.publication.GWTJahiaPublicationInfo;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineContainer;
import org.jahia.ajax.gwt.client.widget.publication.PublicationStatusGrid;
import org.jahia.ajax.gwt.client.widget.toolbar.action.WorkInProgressActionItem;

public class PublicationStatusWindow
extends LayoutContainer {
    protected Linker linker;
    protected Button noWorkflow;
    protected Button cancel;
    protected boolean unpublish;
    protected EngineContainer container;
    protected List<String> uuids;

    public PublicationStatusWindow(Linker linker, List<String> uuids, List<GWTJahiaPublicationInfo> infos, final EngineContainer container, boolean unpublish) {
        this.setLayout((Layout)new FitLayout());
        this.linker = linker;
        this.unpublish = unpublish;
        this.uuids = uuids;
        this.addStyleName("publication-status-window");
        this.setScrollMode(Style.Scroll.NONE);
        TableData d = new TableData(Style.HorizontalAlignment.CENTER, Style.VerticalAlignment.MIDDLE);
        d.setMargin(5);
        PublicationStatusGrid grid = new PublicationStatusGrid(infos, true, linker, container);
        this.add((Component)grid);
        this.cancel = new Button(Messages.get("label.cancel"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                container.closeEngine();
            }
        });
        this.cancel.addStyleName("button-cancel");
        ButtonBar bar = new ButtonBar();
        bar.setAlignment(Style.HorizontalAlignment.CENTER);
        String language = null;
        if (uuids != null && infos != null && !infos.isEmpty() && infos.get(0).isAllowedToPublishWithoutWorkflow().booleanValue()) {
            this.noWorkflow = new Button(Messages.get("label.bypassWorkflow", "Bypass workflow"));
            this.noWorkflow.addStyleName("button-noworkflow");
            this.noWorkflow.addSelectionListener((SelectionListener)new ButtonEventSelectionListener(uuids));
            String workflowGroup = infos.get(0).getWorkflowGroup();
            language = workflowGroup.substring(0, workflowGroup.indexOf(" "));
            bar.add((Component)this.noWorkflow);
        }
        bar.add((Component)this.cancel);
        this.container = container;
        container.setEngine((Component)this, "Publish", bar, JahiaGWTParameters.getLanguage(language), linker);
    }

    public List<String> getUuids() {
        return this.uuids;
    }

    public boolean isUnpublish() {
        return this.unpublish;
    }

    private class ButtonEventSelectionListener
    extends SelectionListener<ButtonEvent> {
        private List<String> uuids;
        protected boolean workflow;

        public ButtonEventSelectionListener(List<String> uuids) {
            this.uuids = uuids;
        }

        public void componentSelected(ButtonEvent event) {
            if (PublicationStatusWindow.this.noWorkflow != null) {
                PublicationStatusWindow.this.noWorkflow.setEnabled(false);
            }
            PublicationStatusWindow.this.cancel.setEnabled(false);
            PublicationStatusWindow.this.container.closeEngine();
            if (PublicationStatusWindow.this.unpublish) {
                final String status = Messages.get("label.publication.unpublished.task", "Unpublishing content");
                Info.display((String)status, (String)status);
                WorkInProgressActionItem.setStatus(status);
                JahiaContentManagementService.App.getInstance().unpublish(this.uuids, new BaseAsyncCallback(){

                    @Override
                    public void onApplicationFailure(Throwable caught) {
                        WorkInProgressActionItem.removeStatus(status);
                        Info.display((String)"Cannot unpublish", (String)"Cannot unpublish");
                        Log.error((String)"Cannot unpublish", (Throwable)caught);
                    }

                    public void onSuccess(Object result) {
                        WorkInProgressActionItem.removeStatus(status);
                        Info.display((String)Messages.get("label.publication.unpublished"), (String)Messages.get("label.publication.unpublished"));
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("refreshAll", true);
                        PublicationStatusWindow.this.linker.refresh(data);
                    }
                });
            } else {
                final String status = Messages.get("label.publication.task", "Publishing content");
                Info.display((String)status, (String)status);
                WorkInProgressActionItem.setStatus(status);
                JahiaContentManagementService.App.getInstance().publish(this.uuids, null, null, new BaseAsyncCallback(){

                    @Override
                    public void onApplicationFailure(Throwable caught) {
                        WorkInProgressActionItem.removeStatus(status);
                        Info.display((String)"Cannot publish", (String)"Cannot publish");
                        Log.error((String)"Cannot publish", (Throwable)caught);
                    }

                    public void onSuccess(Object result) {
                        WorkInProgressActionItem.removeStatus(status);
                        Info.display((String)Messages.get("message.content.published"), (String)Messages.get("message.content.published"));
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("refreshAll", true);
                        PublicationStatusWindow.this.linker.refresh(data);
                    }
                });
            }
        }
    }
}

