/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.publication;

import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.publication.GWTJahiaPublicationInfo;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.publication.PublicationStatusGrid;
import org.jahia.ajax.gwt.client.widget.publication.PublicationWorkflow;
import org.jahia.ajax.gwt.client.widget.toolbar.action.WorkInProgressActionItem;
import org.jahia.ajax.gwt.client.widget.workflow.WorkflowActionDialog;

public class UnpublicationWorkflow
extends PublicationWorkflow {
    private static final long serialVersionUID = -4916142720074054130L;

    public UnpublicationWorkflow() {
    }

    public UnpublicationWorkflow(List<GWTJahiaPublicationInfo> publicationInfos) {
        super(publicationInfos);
    }

    @Override
    protected void initDialog(WorkflowActionDialog dialog) {
        TabItem tab = new TabItem("Unpublication infos");
        tab.setLayout((Layout)new FitLayout());
        PublicationStatusGrid g = new PublicationStatusGrid(this.publicationInfos, true, dialog.getLinker(), dialog.getContainer());
        tab.add((Widget)g);
        dialog.getTabPanel().add(tab);
    }

    @Override
    protected void doPublish(List<GWTJahiaNodeProperty> nodeProperties, final WorkflowActionDialog dialog) {
        final String status = Messages.get("label.publication.unpublished.task", "Unpublishing content");
        Info.display((String)status, (String)status);
        WorkInProgressActionItem.setStatus(status);
        final List<String> allUuids = this.getAllUuids();
        BaseAsyncCallback callback = new BaseAsyncCallback(){

            @Override
            public void onApplicationFailure(Throwable caught) {
                WorkInProgressActionItem.removeStatus(status);
                Info.display((String)"Cannot unpublish", (String)"Cannot unpublish");
                Window.alert((String)("Cannot unpublish " + caught.getMessage()));
            }

            public void onSuccess(Object result) {
                WorkInProgressActionItem.removeStatus(status);
                if (allUuids.size() < 20) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("refreshMain", true);
                    data.put("event", "unpublicationSuccess");
                    dialog.getLinker().refresh(data);
                }
            }
        };
        JahiaContentManagementService.App.getInstance().unpublish(allUuids, callback);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnpublicationWorkflow that = (UnpublicationWorkflow)o;
        return !(this.publicationInfos != null ? !this.publicationInfos.equals(that.publicationInfos) : that.publicationInfos != null);
    }

    @Override
    public int hashCode() {
        int result = this.publicationInfos != null ? this.publicationInfos.hashCode() : 0;
        return result;
    }
}

