/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import java.util.ArrayList;
import java.util.List;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbar;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarMenu;
import org.jahia.ajax.gwt.client.util.icons.ToolbarIconProvider;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.toolbar.ActionToolbarMenu;
import org.jahia.ajax.gwt.client.widget.toolbar.ToolbarGroup;
import org.jahia.ajax.gwt.client.widget.toolbar.action.ActionItem;
import org.jahia.ajax.gwt.client.widget.toolbar.action.SeparatorActionItem;

public class ActionToolbar
extends ToolBar
implements ToolbarGroup {
    private Linker linker;
    private List<ActionItem> actionItems = new ArrayList<ActionItem>();
    private GWTJahiaToolbar gwtToolbar;
    private boolean loaded = false;

    public ActionToolbar(GWTJahiaToolbar gwtToolbar, Linker linker) {
        this.gwtToolbar = gwtToolbar;
        this.linker = linker;
    }

    public void createToolBar() {
        if (!this.loaded) {
            this.loaded = true;
            if (this.gwtToolbar.isDisplayTitle() && this.gwtToolbar.getTitle() != null && this.gwtToolbar.getTitle().length() > 0) {
                LabelToolItem titleItem = new LabelToolItem(this.gwtToolbar.getTitle() + ":");
                titleItem.addStyleName("gwt-toolbar-title");
                this.add((Component)titleItem);
            }
            List<GWTJahiaToolbarItem> itemsGroupList = this.gwtToolbar.getGwtToolbarItems();
            for (int i = 0; i < itemsGroupList.size(); ++i) {
                GWTJahiaToolbarItem item = itemsGroupList.get(i);
                this.addItem(item);
            }
        }
    }

    @Override
    public void addItem(GWTJahiaToolbarItem gwtToolbarItem) {
        if (gwtToolbarItem instanceof GWTJahiaToolbarMenu) {
            GWTJahiaToolbarMenu gwtToolbarMenu = (GWTJahiaToolbarMenu)gwtToolbarItem;
            ActionToolbarMenu menu = new ActionToolbarMenu(this.linker);
            menu.addStyleName("action-bar-menu");
            menu.addStyleName("menu-" + gwtToolbarMenu.getClassName());
            menu.setActionItems(this.actionItems);
            for (GWTJahiaToolbarItem subItem : gwtToolbarMenu.getGwtToolbarItems()) {
                menu.addItem(subItem);
            }
            Button menuToolItem = new Button(gwtToolbarMenu.getItemsGroupTitle());
            String minIconStyle = gwtToolbarMenu.getIcon();
            if (minIconStyle != null) {
                menuToolItem.setIcon(ToolbarIconProvider.getInstance().getIcon(gwtToolbarMenu.getIcon()));
            }
            menuToolItem.setMenu((Menu)menu);
            menuToolItem.addStyleName("action-bar-tool-item");
            gwtToolbarItem.addClasses((Component)menuToolItem);
            this.add((Component)menuToolItem);
        } else {
            ActionItem actionItem = gwtToolbarItem.getActionItem();
            this.actionItems.add(actionItem);
            if (actionItem != null) {
                actionItem.init(gwtToolbarItem, this.linker);
                if (actionItem.getCustomItem() != null) {
                    this.add(actionItem.getCustomItem());
                } else if (ActionToolbar.isSeparator(gwtToolbarItem)) {
                    this.add((Component)new SeparatorToolItem());
                } else {
                    this.add(actionItem.getTextToolItem());
                }
            }
        }
    }

    public static boolean isSeparator(GWTJahiaToolbarItem gwtToolbarItem) {
        return gwtToolbarItem.getActionItem() != null && gwtToolbarItem.getActionItem() instanceof SeparatorActionItem;
    }

    public void handleNewLinkerSelection() {
        for (ActionItem item : this.actionItems) {
            try {
                item.handleNewLinkerSelection();
            }
            catch (Exception exception) {}
        }
    }

    public void handleNewMainNodeLoaded(GWTJahiaNode node) {
        for (ActionItem item : this.actionItems) {
            try {
                item.handleNewMainNodeLoaded(node);
            }
            catch (Exception exception) {}
        }
    }
}

