/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Arrays;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.URL;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineLoader;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.ModuleHelper;
import org.jahia.ajax.gwt.client.widget.toolbar.action.NodeTypeAwareBaseActionItem;

public class EditContentActionItem
extends NodeTypeAwareBaseActionItem {
    private static final long serialVersionUID = 1899385924986263120L;
    private boolean allowRootNodeEditing;
    private boolean useMainNode = false;
    private String path = null;
    private String configurationName;

    @Override
    public void onComponentSelection() {
        if (this.path != null) {
            String replacedPath = URL.replacePlaceholders(this.path, this.linker.getSelectionContext().getSingleSelection());
            JahiaContentManagementService.App.getInstance().getNodes(Arrays.asList(replacedPath), null, (AsyncCallback<List<GWTJahiaNode>>)new BaseAsyncCallback<List<GWTJahiaNode>>(){

                public void onSuccess(List<GWTJahiaNode> result) {
                    EngineLoader.showEditEngine(EditContentActionItem.this.linker, result.get(0), EditContentActionItem.this.linker.getConfig().getEngineConfiguration(EditContentActionItem.this.configurationName));
                }
            });
            return;
        }
        GWTJahiaNode singleSelection = this.useMainNode ? this.linker.getSelectionContext().getMainNode() : this.linker.getSelectionContext().getSingleSelection();
        EngineLoader.showEditEngine(this.linker, singleSelection, this.linker.getConfig().getEngineConfiguration(this.configurationName));
    }

    @Override
    public void handleNewLinkerSelection() {
        LinkerSelectionContext lh = this.linker.getSelectionContext();
        GWTJahiaNode singleSelection = lh.getSingleSelection();
        this.setEnabled(singleSelection != null && this.isNodeTypeAllowed(singleSelection) && this.hasPermission(lh.getSelectionPermissions()) && (this.allowRootNodeEditing || !lh.isRootNode()) && PermissionsUtils.isPermitted("jcr:modifyProperties", lh.getSelectionPermissions()));
    }

    public void setAllowRootNodeEditing(boolean allowRootNodeEditing) {
        this.allowRootNodeEditing = allowRootNodeEditing;
    }

    public void setUseMainNode(boolean useMainNode) {
        this.useMainNode = useMainNode;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    @Override
    protected boolean isNodeTypeAllowed(GWTJahiaNode selectedNode) {
        GWTJahiaNodeType nodeType = ModuleHelper.getNodeType(selectedNode.getNodeTypes().get(0));
        if (nodeType != null && !ModuleHelper.canUseComponentForEdit(nodeType)) {
            return false;
        }
        return super.isNodeTypeAllowed(selectedNode);
    }
}

