/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.WindowEvent;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.InfoConfig;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseActionItem;
import org.jahia.ajax.gwt.client.widget.toolbar.action.SiteSwitcherActionItem;

public class NewModuleActionItem
extends BaseActionItem {
    private String siteType = null;

    public void setSiteType(String siteType) {
        this.siteType = siteType;
    }

    @Override
    public void onComponentSelection() {
        final Dialog dialog = new Dialog();
        dialog.setHeadingHtml(Messages.get("label.moduleCreate", "Create module"));
        dialog.setButtons("okcancel");
        dialog.setModal(true);
        dialog.setHideOnButtonClick(true);
        dialog.setWidth(500);
        dialog.setHeight(300);
        dialog.setLayout((Layout)new FitLayout());
        final FormPanel form = new FormPanel();
        form.setHeaderVisible(false);
        form.setFrame(false);
        form.setLabelWidth(125);
        final SimpleComboBox moduleTypeCombo = new SimpleComboBox();
        if (this.siteType == null) {
            moduleTypeCombo.setStore(new ListStore());
            moduleTypeCombo.setFieldLabel(Messages.get("label.moduleType", "Module type"));
            moduleTypeCombo.add((Object)"module");
            moduleTypeCombo.add((Object)"templatesSet");
            moduleTypeCombo.setSimpleValue((Object)"module");
            moduleTypeCombo.setTriggerAction(ComboBox.TriggerAction.ALL);
            form.add((Widget)moduleTypeCombo);
        }
        final TextField moduleName = new TextField();
        moduleName.setName("moduleName");
        moduleName.setAllowBlank(false);
        moduleName.setFieldLabel(Messages.get("label.moduleName", "Module name"));
        form.add((Widget)moduleName);
        final TextField artifactId = new TextField();
        artifactId.setName("artifactId");
        artifactId.setFieldLabel(Messages.get("label.moduleId", "Module ID (artifactId)"));
        artifactId.setEmptyText(Messages.get("label.moduleId.empty", "Generated from module name"));
        form.add((Widget)artifactId);
        final TextField groupId = new TextField();
        groupId.setName("groupId");
        groupId.setFieldLabel(Messages.get("label.groupId", "groupId"));
        groupId.setEmptyText(Messages.get("label.groupId.empty", "org.jahia.modules"));
        form.add((Widget)groupId);
        final TextField sources = new TextField();
        sources.setName("sources");
        sources.setFieldLabel(Messages.get("label.sources.folder", "Sources folder (optional - will be created with new sources)"));
        sources.setEmptyText(JahiaGWTParameters.getModulesSourcesDiskPath());
        sources.addListener(Events.OnClick, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                if (!sources.isDirty()) {
                    sources.setRawValue(JahiaGWTParameters.getModulesSourcesDiskPath());
                }
            }
        });
        form.add((Widget)sources);
        dialog.add((Widget)form);
        dialog.addListener(Events.Hide, (Listener)new Listener<WindowEvent>(){

            public void handleEvent(WindowEvent be) {
                if (be.getButtonClicked().getItemId().equalsIgnoreCase("ok")) {
                    if (form.isValid()) {
                        NewModuleActionItem.this.linker.loading(Messages.get("statusbar.creatingModule.label", "Creating module..."));
                        JahiaContentManagementService.App.getInstance().createModule((String)moduleName.getValue(), (String)artifactId.getValue(), (String)groupId.getValue(), NewModuleActionItem.this.siteType != null ? NewModuleActionItem.this.siteType : (String)moduleTypeCombo.getSimpleValue(), (String)sources.getValue(), (AsyncCallback<GWTJahiaNode>)new BaseAsyncCallback<GWTJahiaNode>(){

                            public void onSuccess(GWTJahiaNode result) {
                                NewModuleActionItem.this.linker.loaded();
                                Info.display((String)Messages.get("label.information", "Information"), (String)Messages.get("message.moduleCreated", "Module successfully created"));
                                JahiaGWTParameters.getSitesMap().put(result.getUUID(), result);
                                JahiaGWTParameters.setSiteNode(result);
                                if (((EditLinker)NewModuleActionItem.this.linker).getSidePanel() != null) {
                                    HashMap<String, Object> data = new HashMap<String, Object>();
                                    data.put("refreshAll", true);
                                    ((EditLinker)NewModuleActionItem.this.linker).getSidePanel().refresh(data);
                                }
                                MainModule.staticGoTo(result.getPath(), null);
                                SiteSwitcherActionItem.refreshAllSitesList(NewModuleActionItem.this.linker);
                            }

                            @Override
                            public void onApplicationFailure(Throwable caught) {
                                NewModuleActionItem.this.linker.loaded();
                                InfoConfig config = new InfoConfig(Messages.get("label.error", "Error"), caught.getLocalizedMessage());
                                config.display = 5000;
                                config.height = 100;
                                config.width = 250;
                                Info.display((InfoConfig)config);
                            }
                        });
                    } else {
                        dialog.show();
                    }
                }
            }
        });
        dialog.show();
    }
}

