/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.widget.Info;
import com.google.gwt.user.client.rpc.AsyncCallback;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.poller.Poller;
import org.jahia.ajax.gwt.client.widget.poller.TaskEvent;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseActionItem;

public class NumberOfTasksWorkflowMenuActionItem
extends BaseActionItem
implements Poller.PollListener<TaskEvent> {
    @Override
    public void init(GWTJahiaToolbarItem gwtToolbarItem, Linker linker) {
        super.init(gwtToolbarItem, linker);
        JahiaContentManagementService.App.getInstance().getNumberOfTasksForUser((AsyncCallback<Integer>)new BaseAsyncCallback<Integer>(){

            public void onSuccess(Integer result) {
                NumberOfTasksWorkflowMenuActionItem.this.updateLabel(result);
            }
        });
        Poller.getInstance().registerListener(this, TaskEvent.class);
    }

    @Override
    public void handlePollingResult(TaskEvent result) {
        if (result.getNumberOfTasks() != null) {
            this.updateLabel(result.getNumberOfTasks());
        }
        if (result.getNewTask() != null) {
            Info.display((String)Messages.get("label.tasks.new", "You have a new task to do"), (String)result.getNewTask());
        }
        if (result.getEndedWorkflow() != null) {
            Info.display((String)Messages.get("label.workflow.ended", "A workflow has ended"), (String)result.getEndedWorkflow());
        }
    }

    private void updateLabel(Integer nb) {
        if (nb == 0) {
            this.updateTitle(Messages.get("label.numberoftasksforuser.notasks", "No Waiting tasks"));
        } else {
            this.updateTitle(this.getGwtToolbarItem().getTitle() + " (" + nb + ")");
        }
    }

    @Override
    public void handleNewLinkerSelection() {
        this.setEnabled(false);
    }
}

