/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Window;
import java.util.Iterator;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaProperty;
import org.jahia.ajax.gwt.client.util.URL;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseActionItem;

public class OpenWindowActionItem
extends BaseActionItem {
    @Override
    public void onComponentSelection() {
        String name;
        Map<String, GWTJahiaProperty> preferences = this.getGwtToolbarItem().getProperties();
        GWTJahiaProperty windowUrl = preferences.get("url");
        if (Log.isDebugEnabled()) {
            Iterator<String> it = preferences.keySet().iterator();
            while (it.hasNext()) {
                Log.debug((String)("Found property: " + it.next()));
            }
        }
        String wOptions = "";
        GWTJahiaProperty noOptions = preferences.get("no-options");
        if (noOptions == null) {
            GWTJahiaProperty windowWidth = preferences.get("width");
            String wWidth = "";
            if (windowWidth == null) {
                Log.debug((String)("Warning: width not found - nb. preferences:" + preferences.size()));
                wWidth = ",width=900";
            } else {
                wWidth = ",width=" + windowWidth.getValue();
            }
            GWTJahiaProperty windowHeight = preferences.get("height");
            String wHeight = "";
            wHeight = windowHeight == null ? ",height=600" : ",height=" + windowHeight.getValue();
            wOptions = "scrollbars=yes,resizable=yes,status=no,location=no" + wWidth + wHeight;
        }
        name = (name = this.getPropertyValue(this.getGwtToolbarItem(), "target")) != null ? name : this.getGwtToolbarItem().getTitle().replaceAll(" ", "_").replaceAll("-", "_");
        String jsUrl = this.getPropertyValue(this.getGwtToolbarItem(), "js.url");
        if (jsUrl != null) {
            Window.open((String)JahiaGWTParameters.getParam(jsUrl), (String)name, (String)wOptions);
        } else if (windowUrl != null && windowUrl.getValue() != null) {
            String value = URL.replacePlaceholders(windowUrl.getValue(), this.linker.getSelectionContext().getSingleSelection());
            Window.open((String)value, (String)name, (String)wOptions);
        }
    }

    @Override
    public void handleNewLinkerSelection() {
        Map<String, GWTJahiaProperty> preferences = this.getGwtToolbarItem().getProperties();
        GWTJahiaProperty windowUrl = preferences.get("url");
        if (!this.hasPermission(JahiaGWTParameters.getSiteNode())) {
            this.setEnabled(false);
        } else if (windowUrl != null && windowUrl.getValue() != null) {
            try {
                URL.replacePlaceholders(windowUrl.getValue(), this.linker.getSelectionContext().getSingleSelection());
                this.setEnabled(true);
            }
            catch (Exception e) {
                this.setEnabled(false);
            }
        }
    }

    public static class OpenWindowForSingleFileActionItem
    extends OpenWindowActionItem {
        @Override
        public void handleNewLinkerSelection() {
            LinkerSelectionContext lh = this.linker.getSelectionContext();
            this.setEnabled(lh.getSingleSelection() != null);
        }
    }
}

