/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import java.util.List;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.util.content.CopyPasteEngine;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.content.ManagerLinker;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.toolbar.action.NodeTypeAwareBaseActionItem;

public class PasteActionItem
extends NodeTypeAwareBaseActionItem {
    private boolean pasteInMainNode;
    private List<String> childNodeTypesToSkip;

    public boolean isPasteInMainNode() {
        return this.pasteInMainNode;
    }

    public void setPasteInMainNode(boolean pasteInMainNode) {
        this.pasteInMainNode = pasteInMainNode;
    }

    @Override
    public void onComponentSelection() {
        GWTJahiaNode m = this.linker.getSelectionContext().getSingleSelection();
        if (this.pasteInMainNode) {
            m = this.linker.getSelectionContext().getMainNode();
        }
        if (m != null) {
            String pastingMessage = Messages.get("statusbar.pasting.label");
            String messageStyleName = "x-mask-loading";
            if (this.linker instanceof ManagerLinker) {
                ManagerLinker managerLinker = (ManagerLinker)this.linker;
                managerLinker.getLeftComponent().mask(pastingMessage, "x-mask-loading");
                managerLinker.getTopRightComponent().mask(pastingMessage, "x-mask-loading");
            } else {
                this.linker.loading(pastingMessage);
            }
            CopyPasteEngine copyPasteEngine = CopyPasteEngine.getInstance();
            copyPasteEngine.paste(m, this.linker, this.childNodeTypesToSkip);
        }
    }

    @Override
    public void handleNewLinkerSelection() {
        LinkerSelectionContext lh = this.linker.getSelectionContext();
        boolean b = false;
        CopyPasteEngine copyPasteEngine = CopyPasteEngine.getInstance();
        if (!copyPasteEngine.getCopiedNodes().isEmpty()) {
            if (this.pasteInMainNode) {
                b = lh.getMainNode() != null && this.hasPermission(lh.getMainNode()) && PermissionsUtils.isPermitted("jcr:addChildNodes", lh.getMainNode());
            } else {
                boolean bl = b = lh.getSingleSelection() != null && this.hasPermission(lh.getSelectionPermissions()) && PermissionsUtils.isPermitted("jcr:addChildNodes", lh.getSelectionPermissions()) && lh.isPasteAllowed();
            }
            if (b && this.linker instanceof EditLinker) {
                List<String> nodeTypeNames = this.linker.getSelectionContext().getSingleSelection().getNodeTypes();
                StringBuilder nodeTypes = new StringBuilder(nodeTypeNames.size() * 15);
                boolean isFirst = true;
                for (String nodeType : nodeTypeNames) {
                    if (isFirst) {
                        nodeTypes.append(nodeType);
                        isFirst = false;
                        continue;
                    }
                    nodeTypes.append(",").append(nodeType);
                }
                b = copyPasteEngine.checkNodeType(nodeTypes.toString());
            }
        }
        boolean isCutWithNodeTypesSkipped = this.childNodeTypesToSkip != null && copyPasteEngine.isCut();
        this.setEnabled(b && !isCutWithNodeTypesSkipped && super.isNodeTypeAllowed(copyPasteEngine.getCopiedNodes()));
    }

    public void setChildNodeTypesToSkip(List childNodeTypesToSkip) {
        this.childNodeTypesToSkip = childNodeTypesToSkip;
    }
}

