/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.publication.GWTJahiaPublicationInfo;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseActionItem;

public class PublicationStatusActionItem
extends BaseActionItem {
    private transient HorizontalPanel panel;

    @Override
    public void handleNewMainNodeLoaded(GWTJahiaNode node) {
        GWTJahiaPublicationInfo info = node.getAggregatedPublicationInfo();
        if (info != null) {
            this.displayInfo(info);
        } else {
            JahiaContentManagementService.App.getInstance().getNodes(Arrays.asList(node.getPath()), Arrays.asList("publicationInfo"), (AsyncCallback<List<GWTJahiaNode>>)new BaseAsyncCallback<List<GWTJahiaNode>>(){

                public void onSuccess(List<GWTJahiaNode> result) {
                    GWTJahiaPublicationInfo info = result.get(0).getAggregatedPublicationInfo();
                    if (info != null) {
                        PublicationStatusActionItem.this.displayInfo(info);
                    }
                }
            });
        }
    }

    private void displayInfo(GWTJahiaPublicationInfo info) {
        Image res = GWTJahiaPublicationInfo.renderPublicationStatusImage(info);
        this.panel.removeAll();
        if (this.getGwtToolbarItem().getTitle() != null) {
            this.panel.add((Widget)new Html(this.getGwtToolbarItem().getTitle() + "&nbsp;:&nbsp;"));
        }
        this.panel.add((Widget)res);
        this.panel.layout();
    }

    @Override
    public void init(GWTJahiaToolbarItem gwtToolbarItem, Linker linker) {
        super.init(gwtToolbarItem, linker);
        this.panel = new HorizontalPanel();
        this.panel.addStyleName(this.getGwtToolbarItem().getClassName());
        this.panel.addStyleName("action-bar-menu-item");
    }

    @Override
    public Component getCustomItem() {
        return this.panel;
    }
}

