/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.publication.GWTJahiaPublicationInfo;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowDefinition;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowType;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.publication.PublicationWorkflow;
import org.jahia.ajax.gwt.client.widget.toolbar.action.NodeTypeAwareBaseActionItem;

public class PublishActionItem
extends NodeTypeAwareBaseActionItem {
    protected transient String workflowType = "publish";
    protected transient boolean checkForUnpublication = false;
    protected boolean allSubTree = false;
    protected boolean allLanguages = false;

    public static boolean isChildOfMarkedForDeletion(LinkerSelectionContext selection) {
        GWTJahiaNode node;
        if (selection.getMultipleSelection().size() == 0) {
            return false;
        }
        boolean markedForDeletion = false;
        Iterator<GWTJahiaNode> iterator = selection.getMultipleSelection().iterator();
        while (iterator.hasNext() && (markedForDeletion = (node = iterator.next()).getNodeTypes().contains("jmix:markedForDeletion") && !node.getNodeTypes().contains("jmix:markedForDeletionRoot"))) {
        }
        return markedForDeletion;
    }

    @Override
    public void handleNewLinkerSelection() {
        boolean hasOnlyOneLanguage;
        this.setEnabled(false);
        this.getGwtToolbarItem().setHideWhenDisabled(true);
        LinkerSelectionContext ctx = this.linker.getSelectionContext();
        boolean bl = hasOnlyOneLanguage = JahiaGWTParameters.getSiteLanguages().size() == 1;
        if (this.allLanguages) {
            if (hasOnlyOneLanguage) {
                this.setEnabled(false);
                return;
            }
            if (ctx.getMultipleSelection() != null && ctx.getMultipleSelection().size() > 1) {
                if (!PublishActionItem.isChildOfMarkedForDeletion(ctx) && this.hasPermission(ctx.getSelectionPermissions()) && this.supportPublication(ctx.getMultipleSelection()) && this.isNodeTypeAllowed(ctx.getMultipleSelection())) {
                    this.setEnabled(true);
                    if (this.allSubTree) {
                        this.updateTitle(Messages.get("label.publish.all.selected.items.all.languages", "Publish all under selected items in all languages"));
                    } else {
                        this.updateTitle(Messages.get("label.publish.selected.items.all.languages", "Publish all selected items in all languages"));
                    }
                }
            } else {
                GWTJahiaNode gwtJahiaNode = ctx.getSingleSelection();
                if (this.isWorkInProgress(gwtJahiaNode)) {
                    this.setEnabled(false);
                } else if (gwtJahiaNode != null) {
                    String title = this.allSubTree ? Messages.getWithArgs("label.publishall.all.languages", "Publish all under {0} in all languages", new String[]{gwtJahiaNode.getDisplayName()}) : Messages.getWithArgs("label.publish.languages", "Publish {0} in all languages", new String[]{gwtJahiaNode.getDisplayName()});
                    this.updateItem(ctx, gwtJahiaNode, title);
                }
            }
        } else if (this.allSubTree) {
            if (ctx.getMultipleSelection() != null && ctx.getMultipleSelection().size() > 1) {
                if (!PublishActionItem.isChildOfMarkedForDeletion(ctx) && this.hasPermission(ctx.getSelectionPermissions()) && this.supportPublication(ctx.getMultipleSelection()) && this.isNodeTypeAllowed(ctx.getMultipleSelection())) {
                    this.setEnabled(true);
                    this.updateTitle(Messages.get("label.publish.all.selected.items"));
                }
            } else {
                GWTJahiaNode gwtJahiaNode = ctx.getSingleSelection();
                if (this.isWorkInProgress(gwtJahiaNode)) {
                    this.setEnabled(false);
                } else if (gwtJahiaNode != null) {
                    String title = Messages.get("label.publishall") + " " + gwtJahiaNode.getDisplayName() + " - " + JahiaGWTParameters.getLanguageDisplayName();
                    this.updateItem(ctx, gwtJahiaNode, title);
                }
            }
        } else if (ctx.getMultipleSelection() != null && ctx.getMultipleSelection().size() > 1) {
            if (!PublishActionItem.isChildOfMarkedForDeletion(ctx) && this.hasPermission(ctx.getSelectionPermissions()) && this.supportPublication(ctx.getMultipleSelection()) && this.isNodeTypeAllowed(ctx.getMultipleSelection())) {
                this.setEnabled(true);
                this.updateTitle(this.getGwtToolbarItem().getTitle());
            }
        } else {
            GWTJahiaNode gwtJahiaNode = ctx.getSingleSelection();
            if (this.isWorkInProgress(gwtJahiaNode)) {
                this.setEnabled(false);
            } else if (gwtJahiaNode != null && !PublishActionItem.isChildOfMarkedForDeletion(ctx) && Boolean.TRUE.equals(gwtJahiaNode.get("supportsPublication")) && this.hasPermission(gwtJahiaNode) && this.isNodeTypeAllowed(gwtJahiaNode)) {
                this.setEnabled(true);
                if (this.checkForUnpublication) {
                    GWTJahiaPublicationInfo publicationInfo;
                    GWTJahiaPublicationInfo gWTJahiaPublicationInfo = publicationInfo = gwtJahiaNode.getAggregatedPublicationInfo() != null ? gwtJahiaNode.getAggregatedPublicationInfo() : gwtJahiaNode.getQuickPublicationInfo();
                    if (publicationInfo != null && !publicationInfo.isUnpublishable()) {
                        this.setEnabled(false);
                    }
                } else if (gwtJahiaNode.getAggregatedPublicationInfo() != null) {
                    GWTJahiaPublicationInfo info = gwtJahiaNode.getAggregatedPublicationInfo();
                    GWTJahiaWorkflowDefinition def = null;
                    if (gwtJahiaNode.getWorkflowInfo() != null) {
                        def = gwtJahiaNode.getWorkflowInfo().getPossibleWorkflows().get(new GWTJahiaWorkflowType(this.workflowType));
                    }
                    this.setEnabled(info.isPublishable() && (def != null || info.isAllowedToPublishWithoutWorkflow() != false));
                }
                if (gwtJahiaNode.isFile().booleanValue() || gwtJahiaNode.isNodeType("nt:folder")) {
                    this.updateTitle(this.getGwtToolbarItem().getTitle() + " " + gwtJahiaNode.getDisplayName());
                } else {
                    this.updateTitle(this.getGwtToolbarItem().getTitle() + " " + gwtJahiaNode.getDisplayName() + " - " + JahiaGWTParameters.getLanguageDisplayName());
                }
            }
        }
    }

    protected boolean isWorkInProgress(GWTJahiaNode gwtJahiaNode) {
        return gwtJahiaNode != null && gwtJahiaNode.get("j:workInProgress") != null && (Boolean)gwtJahiaNode.get("j:workInProgress") != false && !gwtJahiaNode.getNodeTypes().contains("jmix:markedForDeletion");
    }

    @Override
    public void init(GWTJahiaToolbarItem gwtToolbarItem, Linker linker) {
        super.init(gwtToolbarItem, linker);
        this.getGwtToolbarItem().setHideWhenDisabled(true);
        this.setEnabled(false);
    }

    @Override
    public void onComponentSelection() {
        LinkerSelectionContext ctx = this.linker.getSelectionContext();
        if (!ctx.getMultipleSelection().isEmpty()) {
            ArrayList<String> uuids = new ArrayList<String>();
            List<GWTJahiaNode> jahiaNodes = ctx.getMultipleSelection();
            if (jahiaNodes.size() > 1) {
                for (GWTJahiaNode jahiaNode : jahiaNodes) {
                    uuids.add(jahiaNode.getUUID());
                }
            } else {
                uuids.add(ctx.getSingleSelection().getUUID());
            }
            this.linker.loading(Messages.get("label.gettingPublicationInfo", "Getting publication information"));
            BaseAsyncCallback<List<GWTJahiaPublicationInfo>> asyncCallback = new BaseAsyncCallback<List<GWTJahiaPublicationInfo>>(){

                @Override
                public void onApplicationFailure(Throwable caught) {
                    PublishActionItem.this.linker.loaded();
                    Window.alert((String)("Cannot get status: " + caught.getMessage()));
                }

                public void onSuccess(List<GWTJahiaPublicationInfo> result) {
                    PublishActionItem.this.linker.loaded();
                    PublishActionItem.this.callback(result);
                }
            };
            if (!this.allLanguages) {
                JahiaContentManagementService.App.getInstance().getPublicationInfo(uuids, this.allSubTree, this.checkForUnpublication, (AsyncCallback<List<GWTJahiaPublicationInfo>>)asyncCallback);
            } else {
                HashSet<String> languages = new HashSet<String>();
                for (GWTJahiaLanguage gwtJahiaLanguage : JahiaGWTParameters.getSiteLanguages()) {
                    if (!gwtJahiaLanguage.isActive().booleanValue()) continue;
                    languages.add(gwtJahiaLanguage.getLanguage());
                }
                JahiaContentManagementService.App.getInstance().getPublicationInfo(uuids, this.allSubTree, this.checkForUnpublication, languages, (AsyncCallback<List<GWTJahiaPublicationInfo>>)asyncCallback);
            }
        }
    }

    protected void callback(final List<GWTJahiaPublicationInfo> result) {
        if (result.isEmpty()) {
            MessageBox.info((String)Messages.get("label.publish", "Publication"), (String)Messages.get("label.publication.nothingToPublish", "Nothing to publish"), null);
        } else {
            ArrayList<GWTJahiaPublicationInfo> unpublishable = new ArrayList<GWTJahiaPublicationInfo>();
            for (GWTJahiaPublicationInfo info : result) {
                Integer status = info.getStatus();
                if (status != 6 && status != 9) continue;
                unpublishable.add(info);
            }
            result.removeAll(unpublishable);
            if (unpublishable.isEmpty()) {
                PublicationWorkflow.create(result, this.linker, this.checkForUnpublication);
            } else {
                Integer status;
                StringBuilder message = new StringBuilder();
                HashMap unpublishableMap = new HashMap();
                for (GWTJahiaPublicationInfo gWTJahiaPublicationInfo : unpublishable) {
                    status = gWTJahiaPublicationInfo.getStatus();
                    if (!unpublishableMap.containsKey(status)) {
                        unpublishableMap.put(status, new ArrayList());
                    }
                    ((List)unpublishableMap.get(status)).add(gWTJahiaPublicationInfo.getTitle() + " (" + gWTJahiaPublicationInfo.getPath() + ")");
                }
                for (Map.Entry entry : unpublishableMap.entrySet()) {
                    int i;
                    status = (Integer)entry.getKey();
                    List values = (List)entry.getValue();
                    String labelKey = GWTJahiaPublicationInfo.statusToLabel.get(status);
                    message.append(Messages.get("label.publication." + labelKey, labelKey)).append(" : ").append((String)values.get(0));
                    if (values.size() > 10) {
                        for (i = 1; i < 10; ++i) {
                            message.append(", ").append((String)values.get(i));
                        }
                        message.append(", ...");
                        continue;
                    }
                    for (i = 1; i < values.size(); ++i) {
                        message.append(", ").append((String)values.get(i));
                    }
                }
                if (!result.isEmpty()) {
                    message.append("<br/>").append(Messages.get("message.continue"));
                    MessageBox.confirm((String)Messages.get("label.publish", "Publication"), (String)message.toString(), (Listener)new Listener<MessageBoxEvent>(){

                        public void handleEvent(MessageBoxEvent be) {
                            if (be.getButtonClicked().getItemId().equalsIgnoreCase("yes")) {
                                PublicationWorkflow.create(result, PublishActionItem.this.linker, PublishActionItem.this.checkForUnpublication);
                            }
                        }
                    });
                } else {
                    MessageBox.info((String)Messages.get("label.publish", "Publication"), (String)message.toString(), null);
                }
            }
        }
    }

    public void setAllSubTree(boolean allSubTree) {
        this.allSubTree = allSubTree;
    }

    public void setAllLanguages(boolean allLanguages) {
        this.allLanguages = allLanguages;
    }

    private void updateItem(LinkerSelectionContext ctx, GWTJahiaNode gwtJahiaNode, String title) {
        if (!PublishActionItem.isChildOfMarkedForDeletion(ctx) && Boolean.TRUE.equals(gwtJahiaNode.get("supportsPublication")) && this.hasPermission(gwtJahiaNode) && this.isNodeTypeAllowed(gwtJahiaNode)) {
            this.setEnabled(true);
            if ((gwtJahiaNode.isFile().booleanValue() || gwtJahiaNode.isNodeType("nt:folder")) && gwtJahiaNode.isFile().booleanValue()) {
                this.setEnabled(false);
            }
            this.updateTitle(title);
        }
    }

    private boolean supportPublication(List<GWTJahiaNode> multipleSelection) {
        for (GWTJahiaNode gwtJahiaNode : multipleSelection) {
            if (Boolean.TRUE.equals(gwtJahiaNode.get("supportsPublication"))) continue;
            return false;
        }
        return true;
    }
}

