/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.FormButtonBinding;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.GWTJahiaProperty;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseActionItem;

public class SaveAsReferencesMenuActionItem
extends BaseActionItem {
    private GWTJahiaProperty targetName;
    private GWTJahiaProperty allowedNodeType;

    @Override
    public void init(GWTJahiaToolbarItem gwtToolbarItem, Linker linker) {
        super.init(gwtToolbarItem, linker);
        this.setEnabled(false);
        this.targetName = gwtToolbarItem.getProperties().get("targetName");
        this.allowedNodeType = gwtToolbarItem.getProperties().get("allowedNodeType");
    }

    @Override
    public void onComponentSelection() {
        JahiaContentManagementService.App.getInstance().getPortalNodes(this.targetName.getValue(), (AsyncCallback<List<GWTJahiaNode>>)new BaseAsyncCallback<List<GWTJahiaNode>>(){

            public void onSuccess(List<GWTJahiaNode> result) {
                if (result == null || result.size() == 0) {
                    MessageBox.alert((String)Messages.get("label.saveAsPortalComponent"), (String)Messages.get("label.saveAsPortalComponent.portalComponents.nonedeclared", "There is no Portal Components folder declared. The component can not be saved"), null);
                } else if (result.size() == 1) {
                    SaveAsReferencesMenuActionItem.this.saveInPortalNode(result.get(0));
                } else {
                    final Window popup = new Window();
                    popup.addStyleName("save-as-reference-modal");
                    popup.setHeadingHtml(Messages.get("label.saveAsPortalComponent.portalComponents.select", "Select a Portal Components folder"));
                    popup.setWidth(500);
                    popup.setAutoHeight(true);
                    popup.setModal(true);
                    FormPanel f = new FormPanel();
                    f.setHeaderVisible(false);
                    final ComboBox portalNodesCombo = new ComboBox();
                    portalNodesCombo.setStore(new ListStore());
                    portalNodesCombo.setDisplayField("path");
                    portalNodesCombo.setTriggerAction(ComboBox.TriggerAction.ALL);
                    portalNodesCombo.setForceSelection(true);
                    portalNodesCombo.getStore().add(result);
                    ContentPanel p = new ContentPanel();
                    p.setLayout((Layout)new FitLayout());
                    p.setCollapsible(false);
                    p.setFrame(false);
                    p.setAnimCollapse(false);
                    p.setBorders(false);
                    p.setBodyBorder(false);
                    p.setHeaderVisible(false);
                    p.add((Widget)portalNodesCombo);
                    f.add((Widget)p);
                    Button b = new Button(Messages.get("label.save", "Save"));
                    f.addButton(b);
                    b.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                        public void componentSelected(ButtonEvent buttonEvent) {
                            GWTJahiaNode portalNode = (GWTJahiaNode)portalNodesCombo.getValue();
                            if (portalNode != null) {
                                SaveAsReferencesMenuActionItem.this.saveInPortalNode(portalNode);
                            }
                            popup.hide();
                        }
                    });
                    b.addStyleName("button-save");
                    Button c = new Button(Messages.get("label.cancel", "Cancel"));
                    c.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                        public void componentSelected(ButtonEvent buttonEvent) {
                            popup.hide();
                        }
                    });
                    c.addStyleName("button-cancel");
                    f.addButton(c);
                    f.setButtonAlign(Style.HorizontalAlignment.CENTER);
                    FormButtonBinding binding = new FormButtonBinding(f);
                    binding.addButton(b);
                    popup.add((Widget)f);
                    popup.show();
                }
            }

            @Override
            public void onApplicationFailure(Throwable caught) {
                Info.display((String)Messages.get("label.saveAsPortalComponent"), (String)Messages.get("label.saveAsPortalComponent.cannotGetPortalNodes"));
            }
        });
    }

    @Override
    public void handleNewLinkerSelection() {
        LinkerSelectionContext lh = this.linker.getSelectionContext();
        this.setEnabled(lh.getSingleSelection() != null && this.hasPermission(lh.getSingleSelection()) && lh.getSingleSelection().getInheritedNodeTypes().contains(this.allowedNodeType.getValue()));
    }

    private void saveInPortalNode(final GWTJahiaNode portalNode) {
        if (PermissionsUtils.isPermitted("jcr:write", portalNode.getPermissions())) {
            LinkerSelectionContext lh = this.linker.getSelectionContext();
            GWTJahiaNode target = lh.getSingleSelection();
            if (target != null) {
                JahiaContentManagementService.App.getInstance().pasteReferences(Arrays.asList(target.getPath()), portalNode.getPath(), null, new BaseAsyncCallback<Object>(){

                    @Override
                    public void onApplicationFailure(Throwable caught) {
                        Info.display((String)Messages.get("label.saveAsPortalComponent"), (String)Messages.get("label.saveAsPortalComponent.failure"));
                    }

                    public void onSuccess(Object result) {
                        com.google.gwt.user.client.Window.alert((String)Messages.getWithArgs("label.saveAsPortalComponent.success", "Component saved in {0}. It will be available for My Portal users only after publication. To proceed, go in the Content Tab to the selected Portal Components folder, select the component you want to publish in the lower tab then publish it (use right click).", new Object[]{portalNode.getPath()}));
                    }
                });
            }
        } else {
            MessageBox.alert((String)Messages.get("label.saveAsPortalComponent"), (String)Messages.get("label.saveAsPortalComponent.denied"), null);
        }
    }
}

