/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.google.gwt.user.client.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.ExistingFileException;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.toolbar.action.NodeTypeAwareBaseActionItem;

public class ZipActionItem
extends NodeTypeAwareBaseActionItem {
    @Override
    public void onComponentSelection() {
        GWTJahiaNode selection;
        final List<GWTJahiaNode> selectedItems = this.linker.getSelectionContext().getMultipleSelection();
        if (selectedItems != null && selectedItems.size() > 0 && (selection = selectedItems.get(0)) != null) {
            this.linker.loading(Messages.get("statusbar.zipping.label"));
            String defaultArchName = selectedItems.size() == 1 ? selection.getName() + ".zip" : "archive.zip";
            final String archName = Window.prompt((String)Messages.get("confirm.archiveName.label"), (String)defaultArchName);
            if (archName != null && archName.length() > 0) {
                String parentPath = selection.getPath().substring(0, selection.getPath().lastIndexOf(47));
                JahiaContentManagementService.App.getInstance().checkExistence(parentPath + "/" + archName, new BaseAsyncCallback<Boolean>(){

                    @Override
                    public void onApplicationFailure(Throwable throwable) {
                        if (throwable instanceof ExistingFileException) {
                            if (Window.confirm((String)(Messages.get("alreadyExists.label") + "\n" + Messages.get("confirm.overwrite.label")))) {
                                ZipActionItem.forceZip(selectedItems, archName, ZipActionItem.this.linker);
                            }
                        } else {
                            Window.alert((String)(Messages.get("failure.zip.label") + "\n" + throwable.getLocalizedMessage()));
                            ZipActionItem.this.linker.loaded();
                        }
                    }

                    public void onSuccess(Boolean aBoolean) {
                        ZipActionItem.forceZip(selectedItems, archName, ZipActionItem.this.linker);
                    }
                });
            }
        }
    }

    private static void forceZip(List<GWTJahiaNode> selectedItems, String archName, final Linker linker) {
        ArrayList<String> selectedPaths = new ArrayList<String>(selectedItems.size());
        for (GWTJahiaNode node : selectedItems) {
            selectedPaths.add(node.getPath());
        }
        JahiaContentManagementService.App.getInstance().zip(selectedPaths, archName, new BaseAsyncCallback(){

            @Override
            public void onApplicationFailure(Throwable throwable) {
                Window.alert((String)(Messages.get("failure.zip.label") + "\n" + throwable.getLocalizedMessage()));
                linker.loaded();
            }

            public void onSuccess(Object o) {
                linker.loaded();
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("refreshMain", true);
                linker.refresh(data);
            }
        });
    }

    @Override
    public void handleNewLinkerSelection() {
        LinkerSelectionContext lh = this.linker.getSelectionContext();
        Boolean isContentType = lh.getSingleSelection() != null && this.isNodeTypeAllowed(lh.getSingleSelection());
        this.setEnabled(lh.getMultipleSelection().size() > 0 && this.hasPermission(lh.getSelectionPermissions()) && lh.isParentWriteable() && !lh.isSecondarySelection() && isContentType != false);
    }
}

