/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.trash;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseListLoader;
import com.extjs.gxt.ui.client.data.DataProxy;
import com.extjs.gxt.ui.client.data.ListLoader;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.PagingLoadResult;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementServiceAsync;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.NodeColumnConfigList;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineContainer;
import org.jahia.ajax.gwt.client.widget.trash.PreviewWindow;

public class TrashboardEngine
extends Window {
    private static final List<String> FIELDS = new ArrayList<String>(GWTJahiaNode.DEFAULT_FIELDS);
    private final Linker linker;
    private EngineContainer container;
    private Grid<GWTJahiaNode> grid;
    private ButtonBar bar;

    public TrashboardEngine(Linker linker) {
        this.addStyleName("trashboard-engine");
        this.linker = linker;
        this.container = this.container;
        this.init();
    }

    private void init() {
        this.setHeadingHtml(Messages.get("label.trashboard", "Trash Board"));
        this.setLayout((Layout)new FitLayout());
        this.setSize(800, 600);
        this.setBorders(false);
        this.setBodyBorder(false);
        this.setModal(true);
        this.setMaximizable(true);
        this.setDraggable(false);
        this.getHeader().setBorders(false);
        RpcProxy<PagingLoadResult<GWTJahiaNode>> proxy = new RpcProxy<PagingLoadResult<GWTJahiaNode>>(){

            protected void load(Object loadConfig, AsyncCallback<PagingLoadResult<GWTJahiaNode>> callback) {
                JahiaContentManagementService.App.getInstance().searchSQL("select * from [jmix:markedForDeletionRoot] where isdescendantnode(['" + JahiaGWTParameters.getSiteNode().getPath().replace("'", "''") + "'])", -1, 0, null, FIELDS, true, callback);
            }
        };
        BaseListLoader loader = new BaseListLoader((DataProxy)proxy);
        final ListStore deletedNodes = new ListStore((ListLoader)loader);
        ArrayList<ColumnConfig> columns = new ArrayList<ColumnConfig>();
        ColumnConfig column = new ColumnConfig("icon", "", 40);
        column.setResizable(false);
        column.setSortable(false);
        column.setMenuDisabled(true);
        column.setAlignment(Style.HorizontalAlignment.CENTER);
        column.setRenderer(NodeColumnConfigList.ICON_RENDERER);
        columns.add(column);
        column = new ColumnConfig("displayName", Messages.get("label.name", "Name"), 100);
        columns.add(column);
        column = new ColumnConfig("j:deletionDate", Messages.get("label.deletionDate", "Deletion date"), 150);
        columns.add(column);
        column = new ColumnConfig("j:deletionUser", Messages.get("label.deletionUser", "User"), 150);
        columns.add(column);
        final JahiaContentManagementServiceAsync service = JahiaContentManagementService.App.getInstance();
        column = new ColumnConfig("undelete", Messages.get("label.undelete", "Undelete"), 100);
        column.setRenderer((GridCellRenderer)new GridCellRenderer<GWTJahiaNode>(){

            public Object render(final GWTJahiaNode gwtJahiaNode, String property, ColumnData columnData, int rowIndex, int colIndex, ListStore<GWTJahiaNode> listStore, Grid<GWTJahiaNode> grid) {
                Button button = new Button(Messages.get("label.undelete", "Undelete"), (SelectionListener)new SelectionListener<ButtonEvent>(){

                    public void componentSelected(ButtonEvent buttonEvent) {
                        MessageBox.confirm((String)Messages.get("label.information", "Information"), (String)Messages.getWithArgs("message.undelete.confirm", "Do you really want to undelete the selected resource {0}?", new String[]{gwtJahiaNode.getDisplayName()}), (Listener)new Listener<MessageBoxEvent>(){

                            public void handleEvent(MessageBoxEvent be) {
                                if (be.getButtonClicked().getItemId().equalsIgnoreCase("yes")) {
                                    service.undeletePaths(Arrays.asList(gwtJahiaNode.getPath()), new BaseAsyncCallback(){

                                        @Override
                                        public void onApplicationFailure(Throwable throwable) {
                                            Log.error((String)throwable.getMessage(), (Throwable)throwable);
                                            MessageBox.alert((String)Messages.get("label.error", "Error"), (String)throwable.getMessage(), null);
                                        }

                                        public void onSuccess(Object result) {
                                            deletedNodes.remove((ModelData)gwtJahiaNode);
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
                button.addStyleName("button-undelete");
                button.setIcon(StandardIconsProvider.STANDARD_ICONS.restore());
                return button;
            }
        });
        columns.add(column);
        column = new ColumnConfig("Delete", Messages.get("label.delete", "Delete"), 80);
        column.setRenderer((GridCellRenderer)new GridCellRenderer<GWTJahiaNode>(){

            public Object render(final GWTJahiaNode gwtJahiaNode, String property, ColumnData columnData, int rowIndex, int colIndex, ListStore<GWTJahiaNode> listStore, Grid<GWTJahiaNode> grid) {
                if (gwtJahiaNode.getAggregatedPublicationInfo().getStatus() != 4) {
                    return null;
                }
                Button button = new Button(Messages.get("label.delete", "Delete"), (SelectionListener)new SelectionListener<ButtonEvent>(){

                    public void componentSelected(ButtonEvent buttonEvent) {
                        MessageBox.confirm((String)Messages.get("label.warning", "Warning"), (String)(Messages.getWithArgs("message.remove.single.confirm", "Do you really want to remove the selected resource {0}?", new String[]{gwtJahiaNode.getDisplayName()}) + Messages.get("message.remove.warning", "<br/><span style=\"font-style:bold;color:red;\">Warning: this will erase the content definitively from the repository.</span>")), (Listener)new Listener<MessageBoxEvent>(){

                            public void handleEvent(MessageBoxEvent be) {
                                if (be.getButtonClicked().getItemId().equalsIgnoreCase("yes")) {
                                    service.deletePaths(Arrays.asList(gwtJahiaNode.getPath()), new BaseAsyncCallback(){

                                        @Override
                                        public void onApplicationFailure(Throwable throwable) {
                                            Log.error((String)throwable.getMessage(), (Throwable)throwable);
                                            MessageBox.alert((String)Messages.get("label.error", "Error"), (String)throwable.getMessage(), null);
                                        }

                                        public void onSuccess(Object result) {
                                            deletedNodes.remove((ModelData)gwtJahiaNode);
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
                button.addStyleName("button-delete");
                button.setIcon(StandardIconsProvider.STANDARD_ICONS.delete());
                return button;
            }
        });
        columns.add(column);
        column = new ColumnConfig("infos", "", 100);
        column.setRenderer(new GridCellRenderer(){

            public Object render(final ModelData modelData, String property, ColumnData columnData, int rowIndex, int colIndex, ListStore listStore, Grid grid) {
                Button button = new Button(Messages.get("label.information", "Information"), (SelectionListener)new SelectionListener<ButtonEvent>(){

                    public void componentSelected(ButtonEvent buttonEvent) {
                        PreviewWindow w = new PreviewWindow(TrashboardEngine.this.linker, (GWTJahiaNode)modelData);
                        w.show();
                    }
                });
                button.addStyleName("button-info");
                button.setIcon(StandardIconsProvider.STANDARD_ICONS.information());
                return button;
            }
        });
        columns.add(column);
        ColumnModel cm = new ColumnModel(columns);
        this.grid = new Grid(deletedNodes, cm);
        this.grid.setAutoExpandColumn("displayName");
        this.grid.setAutoExpandMax(1000);
        this.add((Component)this.grid);
        this.bar = new ButtonBar();
        this.bar.setAlignment(Style.HorizontalAlignment.CENTER);
        Button cancel = new Button(Messages.get("label.close", "Close"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                TrashboardEngine.this.container.closeEngine();
            }
        });
        cancel.addStyleName("button-close");
        this.bar.add((Component)cancel);
        loader.load();
    }

    static {
        FIELDS.add("j:deletionUser");
        FIELDS.add("j:deletionDate");
        FIELDS.add("j:deletionMessage");
        FIELDS.add("publicationInfo");
    }
}

