/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.core;

import com.google.gwt.dom.client.Document;
import com.google.gwt.i18n.client.Dictionary;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.jahia.ajax.gwt.client.data.GWTJahiaChannel;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;

public class JahiaGWTParameters {
    public static final String SERVICE_ENTRY_POINT = "serviceEntryPoint";
    public static final String JAHIA_GWT_PARAMETERS = "jahiaGWTParameters";
    public static final String CURRENT_USER_NAME = "currentUser";
    public static final String CURRENT_USER_PATH = "currentUserPath";
    public static final String COPYRIGHT = "copyright";
    public static final String UI_LANGUAGE = "uilang";
    public static final String UI_LANGUAGE_DISPLAY_NAME = "uilangdisplayname";
    public static final String ENGINE_LANGUAGE = "enginelang";
    public static final String LANGUAGE = "lang";
    public static final String LANGUAGE_DISPLAY_NAME = "langdisplayname";
    public static final String CHANNEL_IDENTIFIER = "channelIdentifier";
    public static final String CHANNEL_ORIENTATION = "channelOrientation";
    public static final String SITE_UUID = "siteUuid";
    public static final String SITE_KEY = "siteKey";
    public static final String WORKSPACE = "workspace";
    public static final String PATH_INFO = "pathInfo";
    public static final String CONTEXT_PATH = "contextPath";
    public static final String SERVLET_PATH = "servletPath";
    public static final String QUERY_STRING = "queryString";
    public static final String STUDIO_URL = "studioUrl";
    public static final String STUDIO_VISUAL_URL = "studioVisualUrl";
    public static final String BASE_URL = "baseUrl";
    public static final String DEVELOPMENT_MODE = "developmentMode";
    public static final String MODULES_SOURCES_DISK_PATH = "modulesSourcesDiskPath";
    public static final String TOOLBAR_MESSAGES = "toolbarMessages";
    public static final String USE_WEBSOCKETS = "useWebsockets";
    public static final String AREA_AUTO_ACTIVATED = "areaAutoActivated";
    public static final String DX_VERSION = "dxVersion";
    public static final String SYSTEM_USER = " system ";
    private static Dictionary jahiaParamDictionary = Dictionary.getDictionary((String)"jahiaGWTParameters");
    private static String baseUrl;
    private static String language;
    private static String languageDisplayName;
    private static String siteUUID;
    private static String siteKey;
    private static String workspace;
    private static String channelIdentifier;
    private static String channelOrientation;
    private static List<GWTJahiaChannel> channels;
    private static Map<String, GWTJahiaNode> sitesMap;
    private static GWTJahiaNode siteNode;
    static List<UrlUpdater> updaters;

    public static String getServiceEntryPoint() {
        return jahiaParamDictionary.get(SERVICE_ENTRY_POINT);
    }

    public static String getCurrentUser() {
        return jahiaParamDictionary.get(CURRENT_USER_NAME);
    }

    public static String getCurrentUserPath() {
        return jahiaParamDictionary.get(CURRENT_USER_PATH);
    }

    public static boolean isDevelopmentMode() {
        return "true".equals(jahiaParamDictionary.get(DEVELOPMENT_MODE));
    }

    public static String getModulesSourcesDiskPath() {
        return jahiaParamDictionary.get(MODULES_SOURCES_DISK_PATH);
    }

    public static String getPathInfo() {
        return jahiaParamDictionary.get(PATH_INFO);
    }

    public static String getQueryString() {
        return jahiaParamDictionary.get(QUERY_STRING);
    }

    public static String getCopyright() {
        return jahiaParamDictionary.get(COPYRIGHT);
    }

    public static Boolean isWebSockets() {
        try {
            return Boolean.parseBoolean(jahiaParamDictionary.get(USE_WEBSOCKETS));
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public static boolean isAreaAutoActivated() {
        return "true".equals(jahiaParamDictionary.get(AREA_AUTO_ACTIVATED));
    }

    public static String getUILanguage() {
        return jahiaParamDictionary.get(UI_LANGUAGE);
    }

    public static String getDxVersion() {
        return jahiaParamDictionary.get(DX_VERSION);
    }

    public static String getUILanguageDisplayName() {
        return jahiaParamDictionary.get(UI_LANGUAGE_DISPLAY_NAME);
    }

    public static String getLanguageDisplayName() {
        if (languageDisplayName == null) {
            languageDisplayName = jahiaParamDictionary.get(LANGUAGE_DISPLAY_NAME);
        }
        return languageDisplayName;
    }

    public static String getLanguage() {
        if (language == null) {
            language = jahiaParamDictionary.get(LANGUAGE);
        }
        return language;
    }

    public static void setLanguage(GWTJahiaLanguage newLanguage) {
        language = newLanguage.getLanguage();
        languageDisplayName = newLanguage.getDisplayName();
        for (UrlUpdater urlUpdater : updaters) {
            urlUpdater.updateEntryPointUrl();
        }
        baseUrl = JahiaGWTParameters.getBaseUrl();
        baseUrl = baseUrl.substring(0, baseUrl.lastIndexOf(47) + 1) + language;
        JahiaGWTParameters.setNativeLanguage(newLanguage.getLanguage());
        Document.get().getBody().setAttribute("data-lang", language);
        Document.get().getBody().setAttribute("data-langdisplayname", languageDisplayName);
    }

    public static void changeServletMapping(String oldMapping, String newMapping) {
        baseUrl = baseUrl.replaceFirst(oldMapping, newMapping);
    }

    private static native void setNativeLanguage(String var0);

    public static native void setEngineLanguage(String var0);

    public static native void removeEngineLanguage();

    public static String getSiteUUID() {
        if (siteUUID == null) {
            siteUUID = jahiaParamDictionary.keySet().contains(SITE_UUID) ? jahiaParamDictionary.get(SITE_UUID) : "";
        }
        return siteUUID;
    }

    private static void setSiteUUID(String newSiteUUID) {
        siteUUID = newSiteUUID;
        for (UrlUpdater urlUpdater : updaters) {
            urlUpdater.updateEntryPointUrl();
        }
        JahiaGWTParameters.setNativeSiteUUID(newSiteUUID);
        Document.get().getBody().setAttribute("data-siteUuid", newSiteUUID);
    }

    private static native void setNativeSiteUUID(String var0);

    public static String getSiteKey() {
        if (siteKey == null) {
            siteKey = jahiaParamDictionary.keySet().contains(SITE_KEY) ? jahiaParamDictionary.get(SITE_KEY) : "";
        }
        return siteKey;
    }

    private static void setSiteKey(String newSiteKey) {
        siteKey = newSiteKey;
        JahiaGWTParameters.setNativeSiteKey(newSiteKey);
        Document.get().getBody().setAttribute("data-siteKey", newSiteKey);
    }

    private static native void setNativeSiteKey(String var0);

    public static GWTJahiaNode getSiteNode() {
        return siteNode;
    }

    public static void setSiteNode(GWTJahiaNode siteNode) {
        JahiaGWTParameters.siteNode = siteNode;
        JahiaGWTParameters.setSiteUUID(siteNode.getSiteUUID());
        JahiaGWTParameters.setSiteKey(siteNode.getSiteKey());
    }

    public static List<GWTJahiaLanguage> getSiteLanguages() {
        return (List)JahiaGWTParameters.getSiteNode().get("siteLanguages");
    }

    public static GWTJahiaLanguage getLanguage(String language) {
        if (language != null) {
            for (GWTJahiaLanguage jahiaLanguage : JahiaGWTParameters.getSiteLanguages()) {
                if (!jahiaLanguage.getLanguage().equals(language)) continue;
                return jahiaLanguage;
            }
        }
        return null;
    }

    public static List<String> getSiteMandatoryLanguages() {
        return (List)JahiaGWTParameters.getSiteNode().get("siteMandatoryLanguages");
    }

    public static Map<String, GWTJahiaNode> getSitesMap() {
        return sitesMap;
    }

    public static void setSitesMap(Map<String, GWTJahiaNode> sitesMap) {
        JahiaGWTParameters.sitesMap = sitesMap;
    }

    public static String getWorkspace() {
        if (workspace == null) {
            workspace = jahiaParamDictionary.keySet().contains(WORKSPACE) ? jahiaParamDictionary.get(WORKSPACE) : "";
        }
        return workspace;
    }

    public static void setWorkspace(String newWorkspace) {
        baseUrl = baseUrl.replaceFirst(workspace, newWorkspace);
        workspace = newWorkspace;
        for (UrlUpdater urlUpdater : updaters) {
            urlUpdater.updateEntryPointUrl();
        }
        JahiaGWTParameters.setNativeWorkspace(newWorkspace);
        Document.get().getBody().setAttribute("data-workspace", newWorkspace);
    }

    private static native void setNativeWorkspace(String var0);

    public static String getContextPath() {
        return jahiaParamDictionary.get(CONTEXT_PATH);
    }

    public static String getServletPath() {
        return jahiaParamDictionary.get(SERVLET_PATH);
    }

    public static String getParameter(String name) {
        return jahiaParamDictionary.get(name);
    }

    public static String getBaseUrl() {
        if (baseUrl == null) {
            baseUrl = jahiaParamDictionary.get(BASE_URL);
        }
        return baseUrl;
    }

    public static String getParam(String name) {
        if (!jahiaParamDictionary.keySet().contains(name)) {
            return null;
        }
        return jahiaParamDictionary.get(name);
    }

    public static void addUpdater(UrlUpdater updater) {
        updaters.add(updater);
    }

    public static void setChannels(List<GWTJahiaChannel> channels) {
        JahiaGWTParameters.channels = channels;
    }

    public static List<GWTJahiaChannel> getChannels() {
        return channels;
    }

    static {
        for (String s : jahiaParamDictionary.keySet()) {
            String param = jahiaParamDictionary.get(s);
            Document.get().getBody().setAttribute("data-" + s, param);
        }
        updaters = new ArrayList<UrlUpdater>();
    }

    public static interface UrlUpdater {
        public void updateEntryPointUrl();
    }
}

