/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.util.content;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.core.client.JsArrayUtils;
import com.google.gwt.user.client.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.content.JCRClientUtils;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.content.ManagerLinker;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.PlaceholderModule;
import org.jahia.ajax.gwt.client.widget.toolbar.action.ClipboardActionItem;

public class CopyPasteEngine {
    private static CopyPasteEngine m_instance = null;
    private List<PlaceholderModule> placeholders = new ArrayList<PlaceholderModule>();
    private final List<GWTJahiaNode> copiedNodes = new ArrayList<GWTJahiaNode>();
    private boolean cut;

    public static CopyPasteEngine getInstance() {
        if (m_instance == null) {
            m_instance = new CopyPasteEngine();
        }
        return m_instance;
    }

    protected CopyPasteEngine() {
        this.exportStaticMethod();
    }

    public void paste(final GWTJahiaNode m, final Linker linker, List<String> childNodeTypesToSkip, String newName) {
        if (!this.getCopiedNodes().isEmpty()) {
            JahiaContentManagementService.App.getInstance().paste(JCRClientUtils.getPathesList(this.getCopiedNodes()), m.getPath(), newName, this.isCut(), childNodeTypesToSkip, new BaseAsyncCallback(){

                @Override
                public void onApplicationFailure(Throwable throwable) {
                    String message = CopyPasteEngine.this.isCut() ? throwable.getLocalizedMessage() : Messages.get("failure.paste.label") + "\n" + throwable.getLocalizedMessage();
                    Window.alert((String)message);
                    if (linker instanceof ManagerLinker) {
                        ManagerLinker managerLinker = (ManagerLinker)linker;
                        managerLinker.getLeftComponent().unmask();
                        managerLinker.getTopRightComponent().unmask();
                    } else {
                        linker.loaded();
                    }
                }

                public void onSuccess(Object o) {
                    CopyPasteEngine.this.afterPaste(linker, m);
                }
            });
        }
    }

    public void pasteReference(final GWTJahiaNode m, final Linker linker) {
        JahiaContentManagementService.App.getInstance().pasteReferences(JCRClientUtils.getPathesList(this.getCopiedNodes()), m.getPath(), null, new BaseAsyncCallback(){

            @Override
            public void onApplicationFailure(Throwable throwable) {
                String message = CopyPasteEngine.this.isCut() ? throwable.getLocalizedMessage() : Messages.get("failure.paste.label") + "\n" + throwable.getLocalizedMessage();
                Window.alert((String)message);
                if (linker instanceof ManagerLinker) {
                    ManagerLinker managerLinker = (ManagerLinker)linker;
                    managerLinker.getLeftComponent().unmask();
                    managerLinker.getTopRightComponent().unmask();
                } else {
                    linker.loaded();
                }
            }

            public void onSuccess(Object o) {
                CopyPasteEngine.this.afterPaste(linker, m);
            }
        });
    }

    private void afterPaste(Linker linker, GWTJahiaNode target) {
        linker.loaded();
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<String> newPaths = new ArrayList<String>();
        for (GWTJahiaNode node : this.getCopiedNodes()) {
            newPaths.add(target.getPath() + "/" + node.getName());
        }
        data.put("node", this.getCopiedNodes().get(0));
        data.put("nodes", newPaths);
        if (linker instanceof ManagerLinker) {
            ManagerLinker managerLinker = (ManagerLinker)linker;
            managerLinker.getLeftComponent().unmask();
            managerLinker.getTopRightComponent().unmask();
            data.put("refreshAll", true);
            linker.refresh(data);
        } else if (this.isCut() && MainModule.getInstance().getPath().contains(this.getCopiedNodes().get(0).getPath())) {
            MainModule.staticGoTo((String)newPaths.get(0), MainModule.getInstance().getTemplate());
        } else {
            data.put("refreshMain", true);
            linker.refresh(data);
        }
        this.onPastedPath();
    }

    public List<GWTJahiaNode> getCopiedNodes() {
        return this.copiedNodes;
    }

    public native void exportStaticMethod();

    private JsArray<JavaScriptObject> getCopiedNodesAsJs() {
        ArrayList<JavaScriptObject> l = new ArrayList<JavaScriptObject>();
        for (GWTJahiaNode gwtJahiaNode : this.copiedNodes) {
            l.add(this.convertGwtNode(gwtJahiaNode.getName(), gwtJahiaNode.getPath(), gwtJahiaNode.getUUID(), gwtJahiaNode.getNodeTypes() != null && gwtJahiaNode.getNodeTypes().size() > 0 ? gwtJahiaNode.getNodeTypes().get(0) : null));
        }
        return JsArrayUtils.readOnlyJsArray((JavaScriptObject[])l.toArray(new JavaScriptObject[l.size()]));
    }

    private native JavaScriptObject convertGwtNode(String var1, String var2, String var3, String var4);

    private native void sendCopyEvent(JsArray<JavaScriptObject> var1, String var2);

    public void setCopiedNodes(List<GWTJahiaNode> copiedPaths) {
        this.cut = false;
        this.copiedNodes.clear();
        this.copiedNodes.addAll(copiedPaths);
        ClipboardActionItem.setCopied(copiedPaths);
        this.updatePlaceholders();
        this.sendCopyEvent(this.getCopiedNodesAsJs(), "copy");
    }

    public void setCutPaths(List<GWTJahiaNode> cutPaths) {
        this.copiedNodes.clear();
        this.copiedNodes.addAll(cutPaths);
        this.cut = true;
        ClipboardActionItem.setCopied(cutPaths);
        this.updatePlaceholders();
        this.sendCopyEvent(this.getCopiedNodesAsJs(), "cut");
    }

    public void onPastedPath() {
        ClipboardActionItem.removeCopied(this.copiedNodes);
        this.copiedNodes.clear();
        this.cut = false;
        this.updatePlaceholders();
        this.sendCopyEvent(this.getCopiedNodesAsJs(), "copy");
    }

    public boolean isCut() {
        return this.cut;
    }

    public boolean canCopyTo(GWTJahiaNode dest) {
        if (dest == null) {
            return false;
        }
        if (this.copiedNodes == null) {
            return false;
        }
        Iterator<GWTJahiaNode> iterator = this.copiedNodes.iterator();
        if (iterator.hasNext()) {
            GWTJahiaNode copiedPath = iterator.next();
            if ((dest.getPath() + "/").startsWith(copiedPath.getPath() + "/")) {
                return false;
            }
            return !this.isCut() || !copiedPath.getPath().substring(0, copiedPath.getPath().lastIndexOf(47)).equals(dest.getPath());
        }
        return true;
    }

    public boolean checkNodeType(String nodetypes, boolean checkReferences) {
        List<GWTJahiaNode> sources = this.getCopiedNodes();
        boolean allowed = true;
        if (nodetypes != null && nodetypes.length() > 0) {
            if (!sources.isEmpty()) {
                String[] allowedTypes = nodetypes.split(" |,");
                for (GWTJahiaNode source : sources) {
                    boolean nodeAllowed = false;
                    for (String type : allowedTypes) {
                        if (source.isNodeType(type) || source.isReference() && source.getReferencedNode() != null && source.getReferencedNode().isNodeType(type)) {
                            nodeAllowed = true;
                            break;
                        }
                        if (!checkReferences || !type.equals("jnt:contentReference") || !source.isNodeType("jmix:droppableContent")) continue;
                        nodeAllowed = true;
                        break;
                    }
                    allowed &= nodeAllowed;
                }
            }
        } else {
            allowed = false;
        }
        return allowed;
    }

    public boolean canPasteAsReference() {
        if (this.isCut()) {
            return false;
        }
        List<GWTJahiaNode> sources = this.getCopiedNodes();
        if (!sources.isEmpty()) {
            for (GWTJahiaNode source : sources) {
                if (!source.isReference()) continue;
                return false;
            }
        }
        return true;
    }

    private void updatePlaceholders() {
        for (PlaceholderModule module : this.placeholders) {
            module.updatePasteButton();
        }
    }

    public void addPlaceholder(PlaceholderModule module) {
        this.placeholders.add(module);
    }
}

