/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.util.definition;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.GXT;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.Store;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.form.AdapterField;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.DateField;
import com.extjs.gxt.ui.client.widget.form.DateTimePropertyEditor;
import com.extjs.gxt.ui.client.widget.form.DualListField;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.ListField;
import com.extjs.gxt.ui.client.widget.form.NumberField;
import com.extjs.gxt.ui.client.widget.form.StoreFilterField;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.form.TriggerField;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Accessibility;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTChoiceListInitializer;
import org.jahia.ajax.gwt.client.data.GWTJahiaValueDisplayBean;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaItemDefinition;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeDefinition;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaPropertyDefinition;
import org.jahia.ajax.gwt.client.data.node.GWTBitSet;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.ckeditor.CKEditorConfig;
import org.jahia.ajax.gwt.client.widget.content.ColorPickerField;
import org.jahia.ajax.gwt.client.widget.content.ContentPickerField;
import org.jahia.ajax.gwt.client.widget.content.CronField;
import org.jahia.ajax.gwt.client.widget.content.MultipleNumberField;
import org.jahia.ajax.gwt.client.widget.content.MultipleTextField;
import org.jahia.ajax.gwt.client.widget.definition.PropertiesEditor;
import org.jahia.ajax.gwt.client.widget.form.CKEditorField;
import org.jahia.ajax.gwt.client.widget.form.CalendarField;
import org.jahia.ajax.gwt.client.widget.form.FileUploadField;
import org.jahia.ajax.gwt.client.widget.form.tag.TagField;

public class FormFieldCreator {
    private static final int DUAL_LIST_ITEM_COUNT_TO_FILTER = 5;
    public static final DateTimeFormat dateTimeFormat = DateTimeFormat.getFormat((String)"dd.MM.yyyy HH:mm");
    public static final DateTimeFormat dateFormat = DateTimeFormat.getFormat((String)"dd.MM.yyyy");
    private static final int FILTER_FIELD_HEIGHT = 22;

    public static Field<?> createField(GWTJahiaItemDefinition definition, GWTJahiaNodeProperty property, GWTChoiceListInitializer initializer, boolean displayHiddenProperty, GWTBitSet permissions, List<GWTJahiaNodePropertyValue> defaultValues) {
        Object field = null;
        String className = "";
        if (definition.isHidden() && !displayHiddenProperty) {
            return null;
        }
        if (definition.getName().equals("*")) {
            return null;
        }
        if (!definition.isNode()) {
            GWTJahiaPropertyDefinition propDefinition = (GWTJahiaPropertyDefinition)definition;
            String emptyText = "";
            boolean isMutliple = ((GWTJahiaPropertyDefinition)definition).isMultiple();
            block0 : switch (definition.getSelector()) {
                case 1: {
                    if (!definition.isProtected() && isMutliple) {
                        switch (propDefinition.getRequiredType()) {
                            case 3: {
                                field = new MultipleNumberField();
                                ((MultipleNumberField)((Object)field)).setAllowDecimals(false);
                                ((MultipleNumberField)((Object)field)).setType(Long.class);
                                break block0;
                            }
                            case 4: {
                                field = new MultipleNumberField();
                                break block0;
                            }
                        }
                        field = new MultipleTextField();
                        break;
                    }
                    switch (propDefinition.getRequiredType()) {
                        case 3: {
                            if (definition.isProtected() && isMutliple) {
                                field = new TextFieldWithClass();
                                break block0;
                            }
                            field = new NumberField();
                            ((NumberField)field).setAllowDecimals(false);
                            ((NumberField)field).setPropertyEditorType(Long.class);
                            break block0;
                        }
                        case 4: {
                            if (definition.isProtected() && isMutliple) {
                                field = new TextFieldWithClass();
                                break block0;
                            }
                            field = new NumberField();
                            ((NumberField)field).setAllowDecimals(true);
                            break block0;
                        }
                        case 12: {
                            field = new NumberField();
                            ((NumberField)field).setAllowDecimals(true);
                            break block0;
                        }
                    }
                    final TextFieldWithClass f = new TextFieldWithClass();
                    f.addListener(Events.Change, (Listener)new Listener<ComponentEvent>(){

                        public void handleEvent(ComponentEvent event) {
                            String s = (String)f.getValue();
                            if (s != null) {
                                f.setValue((Object)s.trim());
                            }
                        }
                    });
                    field = f;
                    if (definition.getSelectorOptions().get("password") == null) break;
                    ((TextField)field).setPassword(true);
                    break;
                }
                case 5: {
                    field = new TextArea();
                    String height = propDefinition.getSelectorOptions().get("height");
                    if (height == null) break;
                    field.setSize(Integer.toString(field.getWidth()), height);
                    break;
                }
                case 2: {
                    field = new CKEditorField(FormFieldCreator.getCKEditorConfig(propDefinition, permissions));
                    field.setAutoWidth(false);
                    field.setAutoHeight(false);
                    field.setHeight(300);
                    break;
                }
                case 3: {
                    if (isMutliple) {
                        return null;
                    }
                    field = new CalendarField();
                    if (propDefinition.getSelectorOptions().get("format") != null) {
                        ((CalendarField)((Object)field)).getPropertyEditor().setFormat(DateTimeFormat.getFormat((String)propDefinition.getSelectorOptions().get("format")));
                        break;
                    }
                    ((CalendarField)((Object)field)).getPropertyEditor().setFormat(dateTimeFormat);
                    ((CalendarField)((Object)field)).setHideTrigger(propDefinition.isProtected());
                    break;
                }
                case 4: {
                    if (isMutliple) {
                        return null;
                    }
                    field = new DateField();
                    if (propDefinition.getSelectorOptions().get("format") != null) {
                        ((DateField)field).getPropertyEditor().setFormat(DateTimeFormat.getFormat((String)propDefinition.getSelectorOptions().get("format")));
                    } else {
                        ((DateField)field).getPropertyEditor().setFormat(dateFormat);
                    }
                    ((DateField)field).setHideTrigger(propDefinition.isProtected());
                    break;
                }
                case 11: {
                    if (isMutliple) {
                        return null;
                    }
                    field = new CheckBox();
                    ((CheckBox)field).setBoxLabel(definition.getLabel());
                    break;
                }
                case 12: {
                    field = new ColorPickerField();
                    break;
                }
                case 15: {
                    field = new CronField();
                    break;
                }
                case 13: {
                    field = new ContentPickerField(definition.getSelectorOptions(), propDefinition.getValueConstraints(), null, null, "categorypicker", propDefinition.isMultiple());
                    break;
                }
                case 9: {
                    field = new ContentPickerField(definition.getSelectorOptions(), propDefinition.getValueConstraints(), FormFieldCreator.getSelectorOptionAsList(definition, "filters"), FormFieldCreator.getSelectorOptionAsList(definition, "mime"), definition.getSelectorOptions().get("type") != null ? definition.getSelectorOptions().get("type") + "picker" : "editorialpicker", propDefinition.isMultiple());
                    break;
                }
                case 14: {
                    ListStore store = new ListStore();
                    if (initializer != null) {
                        store.add(initializer.getDisplayValues());
                    } else if (propDefinition.getValueConstraints() != null) {
                        for (String s : propDefinition.getValueConstraints()) {
                            if (propDefinition.getRequiredType() != 1 && s.contains("[") && s.contains(",")) {
                                s = s.substring(s.indexOf("[") + 1, s.indexOf(","));
                            }
                            store.add((ModelData)new GWTJahiaValueDisplayBean(s, s));
                        }
                    }
                    if (propDefinition.isMultiple()) {
                        CustomDualListField lists = new CustomDualListField();
                        ListField from = lists.getFromList();
                        from.setStore(store);
                        from.setDisplayField("display");
                        store.sort("display", Style.SortDir.ASC);
                        if (store.getCount() > 5) {
                            StoreFilterField<GWTJahiaValueDisplayBean> filterField = new StoreFilterField<GWTJahiaValueDisplayBean>(){

                                protected boolean doSelect(Store<GWTJahiaValueDisplayBean> store, GWTJahiaValueDisplayBean parent, GWTJahiaValueDisplayBean record, String property, String filter) {
                                    String s = filter.toLowerCase();
                                    return record.getValue().toLowerCase().contains(s) || record.getDisplay().toLowerCase().contains(s);
                                }
                            };
                            filterField.bind((Store)store);
                            filterField.setHeight(22);
                            filterField.setEmptyText(Messages.get("label.type.here.to.filter", "Type here to filter the list"));
                            lists.setFilterField(filterField);
                        }
                        ListField to = lists.getToList();
                        to.setDisplayField("display");
                        ListStore tostore = new ListStore();
                        to.setStore(tostore);
                        tostore.sort("display", Style.SortDir.ASC);
                        field = lists;
                        className = "list-store-field";
                    } else {
                        ComboBox<GWTJahiaValueDisplayBean> combo = new ComboBox<GWTJahiaValueDisplayBean>(){

                            public void expand() {
                                super.expand();
                                Timer t = new Timer(){

                                    public void run() {
                                        this.restrict();
                                    }
                                };
                                t.schedule(500);
                            }

                            public void markInvalid(String msg) {
                                super.markInvalid(msg);
                                if (this.errorIcon != null) {
                                    this.errorIcon.addStyleName("invalid-icon");
                                }
                            }
                        };
                        combo.setStore(store);
                        combo.setDisplayField("display");
                        combo.setTypeAhead(true);
                        combo.setTriggerAction(ComboBox.TriggerAction.ALL);
                        combo.setForceSelection(true);
                        combo.setTemplate(FormFieldCreator.getComboTemplate());
                        field = combo;
                        className = "combo-box-field";
                    }
                    if (!store.getModels().isEmpty()) break;
                    emptyText = Messages.get("label.no.values");
                    break;
                }
                case 16: {
                    if (propDefinition.getRequiredType() == 1 && ((GWTJahiaPropertyDefinition)definition).isMultiple()) {
                        field = new TagField(definition.getSelectorOptions().get("separator"), definition.getSelectorOptions().get("autocomplete"));
                        break;
                    }
                    return null;
                }
                default: {
                    field = propDefinition.getRequiredType() == 9 || propDefinition.getRequiredType() == 10 ? new ContentPickerField(definition.getSelectorOptions(), propDefinition.getValueConstraints(), FormFieldCreator.getSelectorOptionAsList(definition, "filters"), FormFieldCreator.getSelectorOptionAsList(definition, "mime"), "editorialpicker", propDefinition.isMultiple()) : new TextField();
                }
            }
            field.setEmptyText(emptyText);
            if (propDefinition.isInternationalized()) {
                field.setLabelSeparator(" <img width='11px' height='11px' src='" + JahiaGWTParameters.getContextPath() + "/css/images/sharedLang.gif'/>");
            }
        } else {
            GWTJahiaNodeDefinition nodeDefinition = (GWTJahiaNodeDefinition)definition;
            if (nodeDefinition.getName().equals("jcr:content") || nodeDefinition.getRequiredPrimaryTypes()[0].equals("nt:resource") || nodeDefinition.getRequiredPrimaryTypes()[0].equals("jnt:resource")) {
                field = new FileUploadField(definition.getName());
            }
        }
        if (field == null) {
            return null;
        }
        FormFieldCreator.setModifiers((Field)field, definition);
        if (field.getLabelSeparator() != null) {
            field.setLabelSeparator(field.getLabelSeparator() + " :");
        }
        if (property != null) {
            FormFieldCreator.fillValue((Field)field, definition, property, initializer, defaultValues);
        }
        field.getElement().setAttribute("dir", "auto");
        className = "".equals(className) ? field.getClass().getName().substring(field.getClass().getName().lastIndexOf(".") + 1) : className;
        className = className.replaceAll("([a-z])([A-Z]+)", "$1-$2").toLowerCase();
        field.addStyleName(className);
        return field;
    }

    private static CKEditorConfig getCKEditorConfig(GWTJahiaPropertyDefinition propDefinition, GWTBitSet permissions) {
        CKEditorConfig config = new CKEditorConfig();
        boolean toolbarDefined = false;
        for (Map.Entry<String, String> option : propDefinition.getSelectorOptions().entrySet()) {
            if (!option.getKey().startsWith("ckeditor.")) continue;
            String key = option.getKey().substring("ckeditor.".length());
            String value = option.getValue();
            if (value != null && value.contains("$context")) {
                value = value.replace("$context", JahiaGWTParameters.getContextPath());
            }
            config.set(key, value);
            if (!"toolbar".equals(key) && !"customConfig".equals(key)) continue;
            toolbarDefined = true;
        }
        if (!toolbarDefined) {
            String toolbar = "Light";
            if (PermissionsUtils.isPermitted("view-full-wysiwyg-editor", JahiaGWTParameters.getSiteNode()) || PermissionsUtils.isPermitted("studioModeAccess", permissions)) {
                toolbar = "Full";
            } else if (PermissionsUtils.isPermitted("view-basic-wysiwyg-editor", JahiaGWTParameters.getSiteNode())) {
                toolbar = "Basic";
            }
            config.setDefaultToolbar(toolbar);
        }
        return config;
    }

    private static List<String> getSelectorOptionAsList(GWTJahiaItemDefinition definition, String name) {
        String s = definition.getSelectorOptions().get(name);
        if (s == null) {
            return null;
        }
        return Arrays.asList(s.split(","));
    }

    public static void setModifiers(Field field, GWTJahiaItemDefinition definition) {
        Object tField;
        if (field == null || definition == null) {
            return;
        }
        field.setName(definition.getName());
        field.setFieldLabel(definition.getLabel());
        if (!"".equals(definition.getTooltip())) {
            String separator = field.getLabelSeparator() != null ? field.getLabelSeparator() : "";
            field.setLabelSeparator(separator + " <img width='16px' height='16px' src='" + JahiaGWTParameters.getContextPath() + "/modules/default/images/icons/information.png' title='" + definition.getTooltip().replace("'", " ") + "'/>");
        }
        if (field.isReadOnly() || definition.isProtected()) {
            field.setReadOnly(true);
            if (field instanceof TriggerField) {
                ((TriggerField)field).setHideTrigger(true);
            }
        } else {
            field.setReadOnly(false);
        }
        if (field instanceof TextField) {
            tField = (TextField)field;
            tField.setAllowBlank(!definition.isMandatory());
        }
        if (field instanceof CKEditorField) {
            tField = (CKEditorField)field;
            ((CKEditorField)((Object)tField)).setAllowBlank(!definition.isMandatory());
        }
        if (field instanceof CheckBox) {
            field.setHideLabel(true);
            ((CheckBox)field).setBoxLabel(field.getFieldLabel());
        }
        if (field instanceof CustomDualListField) {
            CustomDualListField lists = (CustomDualListField)field;
            lists.setAllowBlank(!definition.isMandatory());
        }
        if (!definition.isNode()) {
            GWTJahiaPropertyDefinition propDefinition = (GWTJahiaPropertyDefinition)definition;
            switch (propDefinition.getRequiredType()) {
                case 1: 
                case 11: {
                    if (14 == definition.getSelector() || propDefinition.getValueConstraints() == null || propDefinition.getValueConstraints().size() != 1) break;
                    String regex = propDefinition.getValueConstraints().get(0);
                    ((TextField)field).setRegex(regex);
                    ((TextField)field).getMessages().setRegexText(propDefinition.getConstraintErrorMessage() != null && propDefinition.getConstraintErrorMessage().length() > 0 ? propDefinition.getConstraintErrorMessage() : Messages.getWithArgs("failure.invalid.regexp.constraint.label", "The field does not match the following regular expression: {0}", new Object[]{regex}));
                    break;
                }
                case 3: 
                case 4: 
                case 12: {
                    if (14 == definition.getSelector()) break;
                    if (propDefinition.getMaxValue() != null) {
                        ((NumberField)field).setMaxValue((Number)Double.parseDouble(propDefinition.getMaxValue()));
                    }
                    if (propDefinition.getMinValue() == null) break;
                    ((NumberField)field).setMinValue((Number)Double.parseDouble(propDefinition.getMinValue()));
                    break;
                }
                case 5: {
                    if (propDefinition.getMaxValue() != null) {
                        ((DateField)field).setMaxValue(new Date(Long.parseLong(propDefinition.getMaxValue())));
                    }
                    if (propDefinition.getMinValue() == null) break;
                    ((DateField)field).setMinValue(new Date(Long.parseLong(propDefinition.getMinValue())));
                }
            }
        }
    }

    public static void fillValue(Field field, GWTJahiaItemDefinition definition, GWTJahiaNodeProperty property, GWTChoiceListInitializer initializer, List<GWTJahiaNodePropertyValue> defaultValues) {
        List<GWTJahiaNodePropertyValue> values = property.getValues();
        if (defaultValues != null && values.size() == 0) {
            values = defaultValues;
        }
        if (initializer != null && values.size() == 0) {
            for (GWTJahiaValueDisplayBean gWTJahiaValueDisplayBean : initializer.getDisplayValues()) {
                if (gWTJahiaValueDisplayBean.get("defaultProperty") == null || !((Boolean)gWTJahiaValueDisplayBean.get("defaultProperty")).booleanValue()) continue;
                values = Arrays.asList(new GWTJahiaNodePropertyValue(gWTJahiaValueDisplayBean.getValue()));
            }
        }
        if (!definition.isNode()) {
            GWTJahiaPropertyDefinition propDefinition = (GWTJahiaPropertyDefinition)definition;
            if (values.size() == 0 && !propDefinition.isMultiple()) {
                return;
            }
            if (propDefinition.getSelector() == 14) {
                ArrayList<GWTJahiaValueDisplayBean> arrayList = new ArrayList<GWTJahiaValueDisplayBean>();
                if (propDefinition.isMultiple()) {
                    CustomDualListField list = (CustomDualListField)field;
                    ArrayList displayBeans = new ArrayList(list.getFromList().getStore().getModels());
                    for (GWTJahiaNodePropertyValue jahiaNodePropertyValue : values) {
                        String val = jahiaNodePropertyValue.getString();
                        if (val == null || val.length() <= 0) continue;
                        for (GWTJahiaValueDisplayBean displayBean : displayBeans) {
                            if (!displayBean.getValue().equals(val)) continue;
                            arrayList.add(displayBean);
                            list.getFromList().getStore().remove((ModelData)displayBean);
                        }
                    }
                    ListStore store = list.getToList().getStore();
                    store.add(arrayList);
                    list.setCustomOriginalValue(arrayList);
                } else {
                    ComboBox combo = (ComboBox)field;
                    String val = values.get(0).getString();
                    for (GWTJahiaValueDisplayBean displayBean : combo.getStore().getModels()) {
                        String value = displayBean.getValue();
                        if (propDefinition.getRequiredType() == 3) {
                            value = Long.toString(new Double(value).longValue());
                        }
                        if (!value.equals(val)) continue;
                        arrayList.add(displayBean);
                    }
                    combo.setSelection(arrayList);
                }
            } else {
                switch (propDefinition.getRequiredType()) {
                    case 2: {
                        break;
                    }
                    case 6: {
                        if (propDefinition.isMultiple()) {
                            return;
                        }
                        field.setValue((Object)values.get(0).getBoolean());
                        break;
                    }
                    case 3: {
                        if (propDefinition.isMultiple()) {
                            if (!propDefinition.isProtected()) {
                                ArrayList<Long> arrayList = new ArrayList<Long>();
                                for (GWTJahiaNodePropertyValue value : values) {
                                    arrayList.add(value.getLong());
                                }
                                field.setValue(arrayList);
                                break;
                            }
                            if (values.size() <= 0) break;
                            field.setValue((Object)FormFieldCreator.join(values));
                            break;
                        }
                        field.setValue((Object)values.get(0).getLong());
                        break;
                    }
                    case 4: {
                        if (propDefinition.isMultiple()) {
                            if (!propDefinition.isProtected()) {
                                ArrayList<Double> arrayList = new ArrayList<Double>();
                                for (GWTJahiaNodePropertyValue value : values) {
                                    arrayList.add(value.getDouble());
                                }
                                field.setValue(arrayList);
                                break;
                            }
                            if (values.size() <= 0) break;
                            field.setValue((Object)FormFieldCreator.join(values));
                            break;
                        }
                        field.setValue((Object)values.get(0).getDouble());
                        break;
                    }
                    case 12: {
                        if (propDefinition.isMultiple()) {
                            return;
                        }
                        field.setValue((Object)values.get(0).getDecimal());
                        break;
                    }
                    case 5: {
                        if (propDefinition.isMultiple()) {
                            return;
                        }
                        Date date = values.get(0).getDate((com.google.gwt.i18n.shared.DateTimeFormat)((DateTimePropertyEditor)field.getPropertyEditor()).getFormat());
                        Log.debug((String)("date: " + date));
                        field.setValue((Object)date);
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 7: 
                    case 8: 
                    case 11: {
                        if (propDefinition.getSelector() == 9) {
                            ArrayList<GWTJahiaNode> v3 = new ArrayList<GWTJahiaNode>();
                            for (GWTJahiaNodePropertyValue value : values) {
                                v3.add(value.getNode());
                            }
                            field.setValue(v3);
                            break;
                        }
                        if (!propDefinition.isProtected() && propDefinition.isMultiple()) {
                            ArrayList<String> v4 = new ArrayList<String>();
                            for (GWTJahiaNodePropertyValue value : values) {
                                v4.add(value.getString());
                            }
                            field.setValue(v4);
                            break;
                        }
                        if (values.size() <= 0) break;
                        field.setValue((Object)FormFieldCreator.join(values));
                        break;
                    }
                    case 9: 
                    case 10: {
                        ArrayList<GWTJahiaNode> v5 = new ArrayList<GWTJahiaNode>();
                        for (GWTJahiaNodePropertyValue value : values) {
                            v5.add(value.getNode());
                        }
                        field.setValue(v5);
                        break;
                    }
                }
            }
        } else {
            if (values.size() == 0) {
                return;
            }
            GWTJahiaNodeDefinition nodeDefinition = (GWTJahiaNodeDefinition)definition;
            if (nodeDefinition.getName().equals("jcr:content") || nodeDefinition.getRequiredPrimaryTypes()[0].equals("nt:resource") || nodeDefinition.getRequiredPrimaryTypes()[0].equals("jnt:resource")) {
                field.setValue((Object)values.get(0).getString());
            } else if (nodeDefinition.getRequiredPrimaryTypes()[0].equals("jmix:link")) {
                ArrayList<GWTJahiaNode> arrayList = new ArrayList<GWTJahiaNode>();
                for (GWTJahiaNodePropertyValue value : values) {
                    arrayList.add(value.getLinkNode());
                }
                field.setValue(arrayList);
            }
        }
    }

    private static String join(List<GWTJahiaNodePropertyValue> values) {
        StringBuilder str = new StringBuilder(values.get(0).getString());
        for (int i = 1; i < values.size(); ++i) {
            str.append(", ");
            str.append(values.get(i).getString());
        }
        return str.toString();
    }

    public static void copyValue(final GWTJahiaNodeProperty sourceProperty, Field<?> f) {
        final Field<?> targetField = f instanceof PropertiesEditor.PropertyAdapterField ? ((PropertiesEditor.PropertyAdapterField)f).getField() : f;
        if (targetField instanceof NumberField) {
            ((NumberField)targetField).setValue((Object)sourceProperty.getValues().get(0).getLong());
        } else if (targetField instanceof CKEditorField) {
            ((CKEditorField)targetField).setValue(sourceProperty.getValues().get(0).getString());
            Timer togglebuttonTimer = new Timer(){

                public void run() {
                    ((CKEditorField)targetField).setValue(sourceProperty.getValues().get(0).getString());
                }
            };
            togglebuttonTimer.schedule(100);
        } else if (targetField instanceof CalendarField) {
            ((CalendarField)targetField).setValue(sourceProperty.getValues().get(0).getDate((com.google.gwt.i18n.shared.DateTimeFormat)((DateTimePropertyEditor)f.getPropertyEditor()).getFormat()));
        } else if (targetField instanceof DateField) {
            ((DateField)targetField).setValue((Object)sourceProperty.getValues().get(0).getDate((com.google.gwt.i18n.shared.DateTimeFormat)((DateTimePropertyEditor)f.getPropertyEditor()).getFormat()));
        } else if (targetField instanceof CheckBox) {
            ((CheckBox)targetField).setValue(sourceProperty.getValues().get(0).getBoolean());
        } else if (targetField instanceof ContentPickerField) {
            ArrayList<GWTJahiaNode> values = new ArrayList<GWTJahiaNode>();
            for (GWTJahiaNodePropertyValue value : sourceProperty.getValues()) {
                values.add(value.getNode());
            }
            ((ContentPickerField)targetField).setValue(values);
        } else if (!(targetField instanceof ComboBox)) {
            if (targetField instanceof TextField) {
                ((TextField)targetField).setValue((Object)sourceProperty.getValues().get(0).getString());
            } else if (targetField instanceof MultipleTextField) {
                ArrayList<String> v = new ArrayList<String>();
                for (GWTJahiaNodePropertyValue value : sourceProperty.getValues()) {
                    v.add(value.getString());
                }
                ((MultipleTextField)targetField).setValue(v);
            }
        }
    }

    private static native String getComboTemplate();

    public static class TextFieldWithClass
    extends TextField<String> {
        public void markInvalid(String msg) {
            super.markInvalid(msg);
            if (this.errorIcon != null) {
                this.errorIcon.addStyleName("invalid-icon");
            }
        }
    }

    public static class CustomDualListField<D extends ModelData>
    extends DualListField<D> {
        private List<D> originalValue = new ArrayList<D>();
        private StoreFilterField<D> filterField;
        private boolean allowBlank;

        public void setCustomOriginalValue(List<D> originalValue) {
            this.originalValue = originalValue;
        }

        public boolean isAllowBlank() {
            return this.allowBlank;
        }

        public void setAllowBlank(boolean allowBlank) {
            this.allowBlank = allowBlank;
        }

        public boolean isDirty() {
            return !this.originalValue.equals(this.getToList().getStore().getModels());
        }

        protected void onRender(Element target, int index) {
            super.onRender(target, index);
            this.getFromList().getListView().el().makePositionable();
            this.getToList().getListView().el().makePositionable();
            if (GXT.isAriaEnabled() && !this.allowBlank) {
                Accessibility.setState((Element)this.getToList().getElement(), (String)"aria-required", (String)"true");
            }
            this.toField.getStore().addListener(ListStore.Add, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    this.validate();
                }
            });
            this.toField.setName("to-" + this.name);
            this.fromField.setName("from-" + this.name);
            this.setHeight(200);
        }

        public StoreFilterField<D> getFilterField() {
            return this.filterField;
        }

        public void setFilterField(StoreFilterField<D> filterField) {
            this.filterField = filterField;
            VerticalPanel vp = new VerticalPanel();
            vp.add(filterField);
            vp.add((Widget)this.fields.remove(0));
            this.fields.add(0, new AdapterField((Widget)vp));
        }

        protected void onResize(int width, int height) {
            super.onResize(width, height);
            if (this.filterField != null) {
                this.fromField.setHeight(this.fromField.getHeight() - 11);
                this.filterField.setWidth(this.fromField.getWidth());
            }
        }

        public void setReadOnly(boolean readOnly) {
            if (readOnly) {
                this.buttonBar.disable();
                this.fromField.disable();
            } else {
                this.buttonBar.enable();
                this.fromField.enable();
            }
            super.setReadOnly(readOnly);
        }

        protected boolean validateValue(String value) {
            boolean b;
            boolean bl = b = !this.allowBlank && this.toField.getStore().getCount() == 0;
            if (b) {
                this.toField.markInvalid(this.getMessages().getInvalidText());
                this.toField.getListView().setBorders(true);
                this.toField.getListView().removeStyleName("x-combo-list");
                this.toField.getListView().removeStyleName("x-border");
                this.toField.getListView().addStyleName("x-form-invalid");
                return false;
            }
            this.toField.getListView().addStyleName("x-combo-list");
            this.toField.getListView().addStyleName("x-border");
            this.toField.getListView().setBorders(false);
            this.toField.getListView().removeStyleName("x-form-invalid");
            this.toField.clearInvalid();
            return true;
        }
    }
}

