/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.util.security;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTBitSet;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;

public class PermissionsUtils {
    private static Map<Integer, List<String>> registeredPermissionCopies = new HashMap<Integer, List<String>>();
    private static int lastPermissionsHashCode;
    private static Set<Integer> notifiedMissingHashes;

    public static void loadPermissions(List<String> permissions) {
        lastPermissionsHashCode = permissions.hashCode();
        registeredPermissionCopies.put(lastPermissionsHashCode, permissions);
        notifiedMissingHashes.remove(lastPermissionsHashCode);
    }

    public static boolean isPermitted(String permissionName) {
        return true;
    }

    public static boolean isPermitted(String permissionName, GWTJahiaNode node) {
        if (node == null) {
            return true;
        }
        return PermissionsUtils.isPermitted(permissionName, node.getPermissions());
    }

    public static boolean isPermitted(String permissionName, GWTBitSet permissions) {
        int i;
        if (permissions == null) {
            return false;
        }
        if ("root".equals(JahiaGWTParameters.getCurrentUser())) {
            return true;
        }
        List<String> registeredPermissions = PermissionsUtils.getRegisteredPermissions(permissions.getReferenceHashCode());
        if (registeredPermissions == null) {
            PermissionsUtils.triggerPermissionsReload();
            if (notifiedMissingHashes.add(permissions.getReferenceHashCode())) {
                Window.alert((String)Messages.get("permission.uncheckable", "There was a problem while checking permissions. If you encounter a wrongly denied permission, please try reloading the page."));
            }
            if ((registeredPermissions = PermissionsUtils.getRegisteredPermissions(permissions.getReferenceHashCode())) == null) {
                return false;
            }
        }
        if ((i = registeredPermissions.indexOf(permissionName)) == -1) {
            i = registeredPermissions.indexOf(permissionName + "_" + JahiaGWTParameters.getWorkspace());
        }
        if (i == -1) {
            Window.alert((String)(Messages.get("message.unknownPermission", "Unknown permission") + " " + permissionName));
            return false;
        }
        return permissions.get(i);
    }

    private static List<String> getRegisteredPermissions(int bitSetPermissionsHashCode) {
        int permissionsHashCode = bitSetPermissionsHashCode == 0 ? lastPermissionsHashCode : bitSetPermissionsHashCode;
        return registeredPermissionCopies.get(permissionsHashCode);
    }

    public static void triggerPermissionsReload() {
        JahiaContentManagementService.App.getInstance().getAvailablePermissions((AsyncCallback<List<String>>)new BaseAsyncCallback<List<String>>(){

            public void onSuccess(List<String> permissions) {
                PermissionsUtils.loadPermissions(permissions);
            }

            @Override
            public void onFailure(Throwable caught) {
            }
        });
    }

    static {
        notifiedMissingHashes = new HashSet<Integer>();
    }
}

