/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.LoadEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.LoadListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNodeUsage;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementServiceAsync;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.content.NodeUsagesGrid;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.SidePanelTabItem;

public class DeleteItemWindow
extends Window {
    private final int windowHeight = 500;
    private final int windowWidth = 650;
    final Grid<GWTJahiaNodeUsage> usagesGrid;
    final FormPanel formPanel;

    public DeleteItemWindow(final Linker linker, final LinkerSelectionContext lh, final boolean permanentlyDelete) {
        this.addStyleName("delete-item-window");
        this.setSize(650, 500);
        this.setHeadingHtml("Informations");
        this.setResizable(false);
        this.setModal(true);
        this.formPanel = new FormPanel();
        this.formPanel.setHeadingHtml(Messages.get("label.information"));
        this.formPanel.setHeaderVisible(false);
        this.formPanel.setBorders(false);
        this.formPanel.setId("JahiaGxtDeleteItem");
        this.formPanel.setLayout((Layout)new RowLayout(Style.Orientation.VERTICAL));
        this.formPanel.setSize(650, 500);
        final Html textMessage = new Html();
        this.formPanel.add((Widget)textMessage);
        ArrayList<GWTJahiaNode> selectedNodeList = new ArrayList<GWTJahiaNode>();
        final ArrayList<String> selectedPathList = new ArrayList<String>();
        for (GWTJahiaNode node : lh.getMultipleSelection()) {
            selectedNodeList.add(node);
            selectedPathList.add(node.getPath());
        }
        final ContentPanel cp = new ContentPanel();
        cp.setLayout((Layout)new FitLayout());
        cp.setBorders(false);
        cp.setHeaderVisible(false);
        this.usagesGrid = NodeUsagesGrid.createUsageGrid(selectedNodeList);
        this.usagesGrid.setSize(650, 200);
        cp.add(this.usagesGrid);
        this.formPanel.add((Widget)cp);
        final TextArea textArea = new TextArea();
        textArea.setSize(620, 100);
        if (!permanentlyDelete) {
            this.formPanel.add((Widget)new Html("<br />" + Messages.get("label.comment", "Comment") + ": <br />"));
            this.formPanel.add((Widget)textArea);
        }
        final int nbSelectedNodes = selectedNodeList.size();
        this.usagesGrid.getStore().getLoader().addLoadListener(new LoadListener(){

            public void loaderLoad(LoadEvent le) {
                List data = (List)le.getData();
                int nbRows = data.size();
                String strMessage = DeleteItemWindow.this.getConfirmationMessage(lh, nbSelectedNodes);
                if (nbRows > 0) {
                    strMessage = strMessage + "<br /><br />" + (nbSelectedNodes > 1 ? Messages.get("message.remove.multiple.usage", "Those nodes are still used in:") : Messages.get("message.remove.single.usage", "This node is still used by:"));
                } else {
                    DeleteItemWindow.this.formPanel.remove((Widget)cp);
                    textArea.setSize("620", "70%");
                    if (permanentlyDelete) {
                        DeleteItemWindow.this.setHeight(130);
                        DeleteItemWindow.this.formPanel.setHeight(130);
                    }
                }
                textMessage.setHtml(strMessage);
                DeleteItemWindow.this.formPanel.layout();
            }
        });
        if (permanentlyDelete) {
            String permanentDeletionMessage = Messages.get("message.remove.warning", "<br/><span style=\"font-style:bold;color:red;\">Warning: this will erase the content definitively from the repository<br/>So it will not be displayed anymore anywere</span>");
            this.formPanel.add((Widget)new Html(permanentDeletionMessage));
            this.setIcon(StandardIconsProvider.STANDARD_ICONS.warning());
        }
        Button submit = new Button(Messages.get("label.yes"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                DeleteItemWindow.this.hide();
                linker.loading(Messages.get("label.executing"));
                JahiaContentManagementServiceAsync async = JahiaContentManagementService.App.getInstance();
                BaseAsyncCallback<GWTJahiaNode> baseAsyncCallback = new BaseAsyncCallback<GWTJahiaNode>(){

                    @Override
                    public void onApplicationFailure(Throwable throwable) {
                        linker.loaded();
                        Log.error((String)throwable.getMessage(), (Throwable)throwable);
                        MessageBox.alert((String)Messages.get("label.error", "Error"), (String)throwable.getMessage(), null);
                    }

                    public void onSuccess(GWTJahiaNode displayableParentNode) {
                        linker.loaded();
                        EditLinker el = null;
                        if (linker instanceof SidePanelTabItem.SidePanelLinker) {
                            el = ((SidePanelTabItem.SidePanelLinker)linker).getEditLinker();
                        } else if (linker instanceof EditLinker) {
                            el = (EditLinker)linker;
                        }
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        if (el != null && selectedPathList.contains(el.getSelectionContext().getMainNode().getPath())) {
                            data.put("mainDeleted", true);
                            if (displayableParentNode == null) {
                                data.put("node", el.getSelectionContext().getMainNode());
                            } else {
                                data.put("node", displayableParentNode);
                            }
                        } else {
                            data.put("refreshAll", true);
                        }
                        linker.refresh(data);
                        linker.select(null);
                    }
                };
                if (permanentlyDelete) {
                    async.deletePaths(selectedPathList, (AsyncCallback<GWTJahiaNode>)baseAsyncCallback);
                } else {
                    async.markForDeletion(selectedPathList, (String)textArea.getValue(), baseAsyncCallback);
                }
            }
        });
        submit.addStyleName("button-yes");
        Button cancel = new Button(Messages.get("label.no"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                DeleteItemWindow.this.hide();
            }
        });
        cancel.addStyleName("button-no");
        ButtonBar buttons = new ButtonBar();
        buttons.setAlignment(Style.HorizontalAlignment.CENTER);
        buttons.add((Component)submit);
        buttons.add((Component)cancel);
        this.formPanel.add((Widget)buttons);
        this.setBottomComponent((Component)buttons);
        this.add((Component)this.formPanel);
    }

    private String getConfirmationMessage(LinkerSelectionContext lh, int nbSelectedNodes) {
        String message = "";
        message = nbSelectedNodes > 1 ? Messages.getWithArgs("message.remove.multiple.confirm", "Do you really want to remove the {0} selected resources?", new String[]{String.valueOf(nbSelectedNodes)}) : (lh.getMultipleSelection().get(0).getNodeTypes().contains("jmix:canBeUseAsTemplateModel") ? Messages.getWithArgs("message.remove.single.pagemodel.confirm", "Do you really want to remove the selected PAGE model {0}?", new String[]{lh.getSingleSelection().getName()}) : (lh.getMultipleSelection().get(0).getNodeTypes().contains("jnt:page") ? Messages.getWithArgs("message.remove.single.page.confirm", "Do you really want to remove the selected PAGE {0}?", new String[]{lh.getSingleSelection().getName()}) : Messages.getWithArgs("message.remove.single.confirm", "Do you really want to remove the selected resource {0}?", new String[]{lh.getSingleSelection().getName()})));
        return message;
    }
}

