/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTManagerConfiguration;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementServiceAsync;
import org.jahia.ajax.gwt.client.widget.SearchField;
import org.jahia.ajax.gwt.client.widget.content.ThumbsListView;

public class SearchGrid
extends ContentPanel {
    private ThumbsListView listView;
    private ListStore<GWTJahiaNode> store;
    private GWTManagerConfiguration config;
    private boolean multiple = false;

    public SearchGrid(GWTManagerConfiguration config, boolean multiple) {
        this(config);
        this.multiple = multiple;
    }

    public SearchGrid(GWTManagerConfiguration config) {
        this.config = config;
        this.setLayout((Layout)new FitLayout());
        this.setBorders(false);
        this.setBodyBorder(false);
        this.setId("images-view");
        SearchField searchField = new SearchField(Messages.get("label_search", "Search") + ": ", false){

            @Override
            public void onFieldValidation(String value) {
                SearchGrid.this.setSearchContent(value, (Component)SearchGrid.this.listView);
            }

            @Override
            public void onSaveButtonClicked(String value) {
            }
        };
        this.setHeaderVisible(false);
        this.setTopComponent((Component)searchField);
        this.store = new ListStore();
        this.listView = new ThumbsListView(true);
        this.listView.setStore(this.store);
        this.listView.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaNode>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaNode> event) {
                if (event != null && event.getSelectedItem() != null) {
                    SearchGrid.this.onContentPicked((GWTJahiaNode)event.getSelectedItem());
                }
            }
        });
        this.listView = new ThumbsListView(true);
        this.listView.setStore(this.store);
        this.listView.setBorders(false);
        this.listView.getSelectionModel().setSelectionMode(Style.SelectionMode.SINGLE);
        this.listView.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaNode>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaNode> event) {
                if (event != null && event.getSelectedItem() != null) {
                    SearchGrid.this.onContentPicked((GWTJahiaNode)event.getSelectedItem());
                }
            }
        });
        this.add((Component)this.listView);
    }

    public void setSearchContent(final String text, final Component parent) {
        this.clearTable();
        parent.mask(Messages.get("label_search", "Search"));
        if (text != null && text.length() > 0) {
            JahiaContentManagementServiceAsync service = JahiaContentManagementService.App.getInstance();
            service.search(text, 0, this.config.getNodeTypes(), this.config.getMimeTypes(), this.config.getFilters(), (AsyncCallback<List<GWTJahiaNode>>)new BaseAsyncCallback<List<GWTJahiaNode>>(){

                public void onSuccess(List<GWTJahiaNode> gwtJahiaNodes) {
                    if (gwtJahiaNodes != null) {
                        Log.debug((String)("Found " + gwtJahiaNodes.size() + " results with text: " + text));
                        SearchGrid.this.setProcessedContent(gwtJahiaNodes);
                    } else {
                        Log.debug((String)"No result found in search");
                    }
                    parent.unmask();
                }

                @Override
                public void onApplicationFailure(Throwable throwable) {
                    Window.alert((String)("Element list retrieval failed :\n" + throwable.getLocalizedMessage()));
                    parent.unmask();
                }
            });
        } else {
            this.refresh();
        }
    }

    public void setContent(Object root) {
    }

    public void setProcessedContent(Object content) {
        this.clearTable();
        this.store.add((List)content);
        if (this.store.getSortState().getSortField() != null && this.store.getSortState().getSortDir() != null) {
            this.store.sort(this.store.getSortState().getSortField(), this.store.getSortState().getSortDir());
        } else {
            this.store.sort("date", Style.SortDir.DESC);
        }
    }

    public void clearTable() {
        this.store.removeAll();
    }

    public Object getSelection() {
        return this.listView.getSelectionModel().getSelectedItems();
    }

    public void refresh() {
    }

    public void clearSelection() {
        this.listView.getSelectionModel().deselectAll();
    }

    public void onContentPicked(GWTJahiaNode gwtJahiaNode) {
    }
}

