/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content.portlet;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACE;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACL;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.acleditor.AclEditor;
import org.jahia.ajax.gwt.client.widget.content.portlet.PortletWizardCard;

public class PortletModesCard
extends PortletWizardCard {
    private AclEditor modeMappingEditor;

    public PortletModesCard() {
        super(Messages.get("org.jahia.engines.PortletsManager.wizard.modesperm.label", "Modes permissions"), Messages.get("org.jahia.engines.PortletsManager.wizard.modesperm.description.label", "Set modes permissions"));
    }

    @Override
    public void next() {
        if (this.modeMappingEditor != null) {
            this.getGwtJahiaNewPortletInstance().setModes(this.modeMappingEditor.getAcl());
        }
    }

    @Override
    public void createUI() {
        this.removeAll();
        super.createUI();
        final GWTJahiaNodeACL acl = this.getPortletWizardWindow().getGwtJahiaNewPortletInstance().getGwtJahiaPortletDefinition().getBaseAcl().cloneObject();
        List<String> permissions = acl.getAvailableRoles().get("modes");
        acl.setBreakAllInheritance(true);
        if (permissions != null && permissions.size() > 0) {
            JahiaContentManagementService.App.getInstance().createDefaultUsersGroupACE(permissions, true, (AsyncCallback<GWTJahiaNodeACE>)new BaseAsyncCallback<GWTJahiaNodeACE>(){

                public void onSuccess(GWTJahiaNodeACE gwtJahiaNodeACE) {
                    Log.debug((String)"Add group ACE");
                    PortletModesCard.this.removeAll();
                    ArrayList<GWTJahiaNodeACE> aces = new ArrayList<GWTJahiaNodeACE>();
                    aces.add(gwtJahiaNodeACE);
                    acl.setAce(aces);
                    PortletModesCard.this.initModeMappingEditor(acl);
                    PortletModesCard.this.modeMappingEditor.addNewAclPanel(PortletModesCard.this);
                    PortletModesCard.this.getPortletWizardWindow().updateWizard();
                }

                @Override
                public void onApplicationFailure(Throwable throwable) {
                    Log.error((String)"Unable to Add group ACE");
                    PortletModesCard.this.removeAll();
                    PortletModesCard.this.initModeMappingEditor(acl);
                    PortletModesCard.this.modeMappingEditor.addNewAclPanel(PortletModesCard.this);
                }
            });
        } else {
            this.add((Widget)new Label(Messages.get("org.jahia.engines.PortletsManager.wizard.modesperm.onlyViewMode", "The selected portlets contains only view mode.")));
        }
    }

    private void initModeMappingEditor(GWTJahiaNodeACL acl) {
        this.modeMappingEditor = new AclEditor(acl, this.getPortletWizardWindow().getParentNode().getSiteKey(), null, Collections.singleton("modes"), null);
        this.modeMappingEditor.setAddUsersLabel(Messages.get("org.jahia.engines.PortletsManager.wizard.modes.adduser.label", "Add mode-user permission"));
        this.modeMappingEditor.setAddGroupsLabel(Messages.get("org.jahia.engines.PortletsManager.wizard.modes.addgroup.label", "Add mode-group permission"));
    }

    @Override
    public void refreshLayout() {
    }
}

