/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.data.BaseListLoader;
import com.extjs.gxt.ui.client.data.DataProxy;
import com.extjs.gxt.ui.client.data.ListLoadResult;
import com.extjs.gxt.ui.client.data.ListLoader;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.PagingLoadResult;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.dnd.DND;
import com.extjs.gxt.ui.client.dnd.GridDragSource;
import com.extjs.gxt.ui.client.dnd.GridDropTarget;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentPlugin;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.CheckBoxSelectionModel;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridSelectionModel;
import com.extjs.gxt.ui.client.widget.grid.RowNumberer;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTColumn;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.content.JCRClientUtils;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.widget.NodeColumnConfigList;

public class ManualListOrderingEditor
extends ContentPanel {
    private GWTJahiaNode node;
    private ListLoader<ListLoadResult<GWTJahiaNode>> loader;
    private Grid<GWTJahiaNode> childrenGrid;
    private List<GWTJahiaNode> removedNodes = new ArrayList<GWTJahiaNode>();

    public ManualListOrderingEditor() {
        this(null);
    }

    public ManualListOrderingEditor(GWTJahiaNode node) {
        this.node = node;
        this.init();
    }

    public List<GWTJahiaNode> getOrderedNodes() {
        return this.childrenGrid.getStore().getModels();
    }

    public List<GWTJahiaNode> getRemovedNodes() {
        return this.removedNodes;
    }

    private void init() {
        this.setBodyBorder(true);
        ArrayList<GWTColumn> columnNames = new ArrayList<GWTColumn>();
        columnNames.add(new GWTColumn("icon", Messages.get("label.icon"), 30));
        columnNames.add(new GWTColumn("displayName", Messages.get("label.title"), 350));
        columnNames.add(new GWTColumn("name", Messages.get("label.name"), 100));
        columnNames.add(new GWTColumn("jcr:created", Messages.get("label.created"), 100));
        columnNames.add(new GWTColumn("jcr:createdBy", Messages.get("column.createdBy.label"), 75));
        columnNames.add(new GWTColumn("jcr:lastModified", Messages.get("label.lastModif"), 100));
        columnNames.add(new GWTColumn("jcr:lastModifiedBy", Messages.get("column.modifiedBy.label"), 75));
        NodeColumnConfigList columnConfigList = new NodeColumnConfigList((List<GWTColumn>)columnNames);
        columnConfigList.init();
        CheckBoxSelectionModel sm = new CheckBoxSelectionModel();
        columnConfigList.add(0, new RowNumberer());
        columnConfigList.add(1, sm.getColumn());
        RpcProxy<PagingLoadResult<GWTJahiaNode>> privateProxy = new RpcProxy<PagingLoadResult<GWTJahiaNode>>(){

            protected void load(Object gwtJahiaFolder, AsyncCallback<PagingLoadResult<GWTJahiaNode>> listAsyncCallback) {
                String path = ((GWTJahiaNode)gwtJahiaFolder).getPath();
                Log.debug((String)("retrieving children of " + path));
                JahiaContentManagementService.App.getInstance().lsLoad(path, JCRClientUtils.MANUALLY_ORDERABLE_NODETYPES, null, null, Arrays.asList("icon", "displayName", "name", "jcr:created", "jcr:createdBy", "jcr:lastModified", "jcr:lastModifiedBy"), false, -1, -1, false, null, null, false, false, listAsyncCallback);
                ManualListOrderingEditor.this.childrenGrid.unmask();
            }
        };
        this.loader = new BaseListLoader((DataProxy)privateProxy);
        ListStore store = new ListStore(this.loader);
        this.childrenGrid = new Grid(store, new ColumnModel((List)columnConfigList));
        this.childrenGrid.setBorders(true);
        this.childrenGrid.setHeight(400);
        new GridDragSource(this.childrenGrid);
        GridDropTarget target = new GridDropTarget(this.childrenGrid);
        target.setAllowSelfAsSource(true);
        target.setFeedback(DND.Feedback.INSERT);
        this.childrenGrid.mask();
        if (this.node != null) {
            this.loader.load((Object)this.node);
        }
        ToolBar toolBar = new ToolBar();
        Button moveUp = new Button(Messages.get("label.move.up", "move up"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                for (GWTJahiaNode node : ManualListOrderingEditor.this.getOrderedSelectedList()) {
                    this.execute(node);
                }
                ManualListOrderingEditor.this.childrenGrid.getView().refresh(false);
            }

            public void execute(GWTJahiaNode selectedNode) {
                ManualListOrderingEditor.this.removeSorter();
                int index = ManualListOrderingEditor.this.childrenGrid.getStore().indexOf((ModelData)selectedNode);
                if (index > 0) {
                    ManualListOrderingEditor.this.childrenGrid.getStore().remove((ModelData)selectedNode);
                    ManualListOrderingEditor.this.childrenGrid.getStore().insert((ModelData)selectedNode, index - 1);
                    ManualListOrderingEditor.this.childrenGrid.getSelectionModel().select(index - 1, true);
                }
            }
        });
        moveUp.setIcon(StandardIconsProvider.STANDARD_ICONS.moveUp());
        moveUp.addStyleName("button-moveup");
        toolBar.add((Component)moveUp);
        Button moveFirst = new Button(Messages.get("label.move.first", "move first"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                int iteration = 0;
                for (GWTJahiaNode node : ManualListOrderingEditor.this.getOrderedSelectedList()) {
                    this.execute(node, iteration);
                    ++iteration;
                }
            }

            public void execute(GWTJahiaNode node, int index) {
                ManualListOrderingEditor.this.removeSorter();
                ManualListOrderingEditor.this.childrenGrid.getStore().remove((ModelData)node);
                ManualListOrderingEditor.this.childrenGrid.getStore().insert((ModelData)node, index);
                ManualListOrderingEditor.this.childrenGrid.getSelectionModel().select(index, true);
                ManualListOrderingEditor.this.childrenGrid.getView().refresh(false);
            }
        });
        moveFirst.setIcon(StandardIconsProvider.STANDARD_ICONS.moveFirst());
        moveFirst.addStyleName("button-movefirst");
        toolBar.add((Component)moveFirst);
        Button moveDown = new Button(Messages.get("label.move.down", "move down"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                List ordered = ManualListOrderingEditor.this.getOrderedSelectedList();
                Collections.reverse(ordered);
                for (GWTJahiaNode node : ordered) {
                    this.execute(node);
                }
            }

            public void execute(GWTJahiaNode selectedNode) {
                int index = ManualListOrderingEditor.this.childrenGrid.getStore().indexOf((ModelData)selectedNode);
                if (index < ManualListOrderingEditor.this.childrenGrid.getStore().getCount() - 1) {
                    ManualListOrderingEditor.this.removeSorter();
                    ManualListOrderingEditor.this.childrenGrid.getStore().remove((ModelData)selectedNode);
                    ManualListOrderingEditor.this.childrenGrid.getStore().insert((ModelData)selectedNode, index + 1);
                    ManualListOrderingEditor.this.childrenGrid.getSelectionModel().select(index + 1, true);
                    ManualListOrderingEditor.this.childrenGrid.getView().refresh(false);
                }
            }
        });
        moveDown.setIcon(StandardIconsProvider.STANDARD_ICONS.moveDown());
        moveDown.addStyleName("button-movedown");
        toolBar.add((Component)moveDown);
        Button moveLast = new Button(Messages.get("label.move.last", "move last"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                List ordered = ManualListOrderingEditor.this.getOrderedSelectedList();
                Collections.reverse(ordered);
                int index = ManualListOrderingEditor.this.childrenGrid.getStore().getCount() - 1;
                for (GWTJahiaNode node : ordered) {
                    this.execute(node, index);
                    --index;
                }
                ManualListOrderingEditor.this.childrenGrid.getSelectionModel().setSelection(ManualListOrderingEditor.this.childrenGrid.getSelectionModel().getSelection());
                ManualListOrderingEditor.this.childrenGrid.getView().refresh(false);
            }

            public void execute(GWTJahiaNode node, int index) {
                ManualListOrderingEditor.this.removeSorter();
                ManualListOrderingEditor.this.childrenGrid.getStore().remove((ModelData)node);
                ManualListOrderingEditor.this.childrenGrid.getStore().insert((ModelData)node, index);
                ManualListOrderingEditor.this.childrenGrid.getSelectionModel().select(index, true);
            }
        });
        moveLast.setIcon(StandardIconsProvider.STANDARD_ICONS.moveLast());
        moveLast.addStyleName("button-movelast");
        toolBar.add((Component)moveLast);
        Button remove = new Button(Messages.get("label.remove", "Delete"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                for (GWTJahiaNode node : ManualListOrderingEditor.this.childrenGrid.getSelectionModel().getSelectedItems()) {
                    ManualListOrderingEditor.this.childrenGrid.getStore().remove((ModelData)node);
                    ManualListOrderingEditor.this.removedNodes.add(node);
                }
                ManualListOrderingEditor.this.childrenGrid.getView().refresh(false);
            }
        });
        remove.setIcon(StandardIconsProvider.STANDARD_ICONS.minusRound());
        remove.addStyleName("button-remove");
        toolBar.add((Component)remove);
        this.setLayout((Layout)new FitLayout());
        this.setHeaderVisible(false);
        this.setTopComponent((Component)toolBar);
        this.childrenGrid.setSelectionModel((GridSelectionModel)sm);
        this.childrenGrid.setBorders(true);
        this.childrenGrid.addPlugin((ComponentPlugin)sm);
        this.add((Component)this.childrenGrid);
    }

    private void removeSorter() {
        if (this.childrenGrid.getStore().getStoreSorter() != null) {
            this.childrenGrid.getStore().setSortField(null);
            this.childrenGrid.getStore().setStoreSorter(null);
            this.childrenGrid.getView().refresh(true);
        } else {
            this.childrenGrid.getView().refresh(false);
        }
    }

    private List<GWTJahiaNode> getOrderedSelectedList() {
        List selectedNodes = this.childrenGrid.getSelectionModel().getSelection();
        Comparator<GWTJahiaNode> c = new Comparator<GWTJahiaNode>(){

            @Override
            public int compare(GWTJahiaNode gwtJahiaNode, GWTJahiaNode gwtJahiaNode1) {
                int index2;
                int index = ManualListOrderingEditor.this.childrenGrid.getStore().indexOf((ModelData)gwtJahiaNode);
                if (index == (index2 = ManualListOrderingEditor.this.childrenGrid.getStore().indexOf((ModelData)gwtJahiaNode1))) {
                    return 0;
                }
                if (index > index2) {
                    return 1;
                }
                return -1;
            }
        };
        Collections.sort(selectedNodes, c);
        return selectedNodes;
    }
}

