/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNodeVersion;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.AsyncTabItem;
import org.jahia.ajax.gwt.client.widget.content.compare.CompareEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;

public class VersioningTabItem
extends EditEngineTabItem {
    private transient String locale;

    public VersioningTabItem() {
        this.setHandleCreate(false);
    }

    @Override
    public void init(final NodeHolder engine, final AsyncTabItem tab, String locale) {
        if (!tab.isProcessed()) {
            this.locale = locale;
            JahiaContentManagementService.App.getInstance().getVersions(engine.getNode().getPath(), (AsyncCallback<List<GWTJahiaNodeVersion>>)new BaseAsyncCallback<List<GWTJahiaNodeVersion>>(){

                public void onSuccess(List<GWTJahiaNodeVersion> result) {
                    ListStore all = new ListStore();
                    all.add(result);
                    ArrayList<ColumnConfig> configs = new ArrayList<ColumnConfig>();
                    ColumnConfig column = new ColumnConfig();
                    column.setId("label");
                    column.setSortable(false);
                    column.setHeaderHtml("Name");
                    column.setWidth(100);
                    column.setRenderer(new GridCellRenderer(){

                        public Object render(ModelData model, String property, ColumnData config, int rowIndex, int colIndex, ListStore listStore, Grid grid) {
                            GWTJahiaNodeVersion version = (GWTJahiaNodeVersion)model;
                            String value = Messages.get("label.version", "Version") + " ";
                            if (version.getLabel() != null && !"".equals(version.getLabel())) {
                                String[] strings = version.getLabel().split("_at_");
                                if (strings.length == 2) {
                                    String s1 = strings[0].contains("published") ? Messages.get("label.version.published", "published at") : (strings[0].contains("uploaded") ? Messages.get("label.version.uploaded", "uploaded at") : Messages.get("label.version." + strings[0], strings[0]));
                                    Date date = DateTimeFormat.getFormat((String)"yyyy_MM_dd_HH_mm_ss").parse(strings[1]);
                                    value = value + s1 + " " + DateTimeFormat.getMediumDateTimeFormat().format(date);
                                } else {
                                    value = version.getLabel();
                                }
                            }
                            return value;
                        }
                    });
                    configs.add(column);
                    if (PermissionsUtils.isPermitted("jcr:write", engine.getNode()) && !engine.getNode().isLocked().booleanValue()) {
                        column = new ColumnConfig();
                        column.setSortable(false);
                        column.setHeaderHtml("Action");
                        column.setWidth(200);
                        column.setRenderer(new GridCellRenderer(){

                            public Object render(ModelData model, String property, ColumnData config, int rowIndex, int colIndex, ListStore listStore, Grid grid) {
                                ButtonBar buttonBar = new ButtonBar();
                                Button button = new Button(Messages.get("label.compare.with.staging.engine", "Compare With Staging"));
                                button.addStyleName("button-compare-staging");
                                button.setToolTip(Messages.get("label.compare.with.staging.engine", "Compare With Staging"));
                                final GWTJahiaNodeVersion version = (GWTJahiaNodeVersion)model;
                                button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                                    public void componentSelected(ButtonEvent ce) {
                                        new CompareEngine(version.getNode().getUUID(), VersioningTabItem.this.locale, false, version.getNode().getPath(), new Date(version.getDate().getTime() + 30000L), engine, version.getWorkspace(), version.getLabel()).show();
                                    }
                                });
                                buttonBar.add((Component)button);
                                return buttonBar;
                            }
                        });
                        configs.add(column);
                    }
                    Grid grid = new Grid(all, new ColumnModel(configs));
                    grid.setAutoExpandColumn("label");
                    tab.add((Widget)grid);
                    tab.layout();
                    tab.show();
                }
            });
            tab.setProcessed(true);
        }
    }

    @Override
    public void onLanguageChange(String language, TabItem tabItem) {
        this.locale = language;
        super.onLanguageChange(language, tabItem);
    }
}

