/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.InfoConfig;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaChannel;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEditConfiguration;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.edit.EditModeDNDListener;
import org.jahia.ajax.gwt.client.widget.edit.EditPanelViewport;
import org.jahia.ajax.gwt.client.widget.edit.ModuleSelectionListener;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.Module;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.SidePanel;
import org.jahia.ajax.gwt.client.widget.toolbar.ActionToolbarLayoutContainer;

public class EditLinker
implements Linker {
    private GWTEditConfiguration config;
    private String mainPath;
    private String template;
    private LinkerSelectionContext selectionContext = new LinkerSelectionContext();
    private Module selectedModule;
    private EditModeDNDListener dndListener;
    private ActionToolbarLayoutContainer toolbar;
    private MainModule mainModule;
    private SidePanel sidePanel;
    private ModuleSelectionListener selectionListener;
    private Widget mainAreaComponent;
    private String locale;
    private GWTJahiaChannel activeChannel;
    private String activeChannelVariant = null;
    private boolean isInSettingsPage = true;
    private long lastRefreshInfoDisplayTime;

    public EditLinker(MainModule mainModule, SidePanel sidePanel, ActionToolbarLayoutContainer toolbar, GWTEditConfiguration config) {
        if (config.isDragAndDropEnabled()) {
            this.dndListener = new EditModeDNDListener(this);
        }
        this.mainModule = mainModule;
        this.sidePanel = sidePanel;
        this.toolbar = toolbar;
        this.config = config;
        this.registerLinker();
    }

    public SidePanel getSidePanel() {
        return this.sidePanel;
    }

    public void setSidePanel(SidePanel sidePanel) {
        this.sidePanel = sidePanel;
        if (sidePanel != null) {
            try {
                sidePanel.initWithLinker(this);
            }
            catch (Exception e) {
                Log.error((String)"Error on init linker", (Throwable)e);
            }
        }
    }

    public MainModule getMainModule() {
        return this.mainModule;
    }

    @Override
    public GWTEditConfiguration getConfig() {
        return this.config;
    }

    public void switchConfig(GWTEditConfiguration config, String newPath, boolean updateSidePanel, boolean updateToolbar, String enforcedWorkspace) {
        this.config = config;
        JahiaGWTParameters.setSiteNode(config.getSiteNode());
        JahiaGWTParameters.setSitesMap(config.getSitesMap());
        JahiaGWTParameters.setChannels(config.getChannels());
        if (enforcedWorkspace != null) {
            JahiaGWTParameters.setWorkspace(enforcedWorkspace);
        }
        PermissionsUtils.loadPermissions(config.getPermissions());
        if (updateSidePanel) {
            this.setActiveChannel(null);
            this.activeChannelVariant = null;
        }
        this.mainModule.setConfig(config, newPath);
        if (updateSidePanel) {
            this.sidePanel.setConfig(config);
        }
        if (updateToolbar) {
            this.toolbar.setConfig(config);
        }
        EditPanelViewport.getInstance().setViewportStyleName(config.getName());
        this.registerLinker(true, updateSidePanel, updateToolbar);
    }

    public EditModeDNDListener getDndListener() {
        return this.dndListener;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(GWTJahiaLanguage locale) {
        if (locale != null) {
            this.locale = locale.getLanguage();
            JahiaGWTParameters.setLanguage(locale);
        } else {
            this.locale = null;
        }
    }

    public Module getSelectedModule() {
        return this.selectedModule;
    }

    public void setSelectionListener(ModuleSelectionListener selectionListener) {
        this.selectionListener = selectionListener;
    }

    public void onModuleSelection(Module selection) {
        if (this.selectionListener == null) {
            this.selectedModule = selection;
            this.handleNewModuleSelection();
            if (this.selectedModule != null) {
                this.selectedModule.setDraggable(true);
            }
        } else {
            this.selectionListener.onModuleSelection(selection);
        }
    }

    public void onMainSelection(String mainPath, String template) {
        this.mainPath = mainPath;
        this.selectedModule = null;
        this.template = template;
    }

    @Override
    public void refresh(Map<String, Object> data) {
        if (!this.config.getRefreshOnExternalModification() && Boolean.TRUE.equals(data.get("externalRefresh"))) {
            if (this.sidePanel != null) {
                this.sidePanel.markForManualRefresh(data);
            }
            long time = System.currentTimeMillis();
            InfoConfig infoConfig = new InfoConfig(Messages.get("label.atmosphere.editorial.content.update", "a content has been updated."), Messages.get("label.refresh.modify", "Click refresh to see updated content"));
            if (time - this.lastRefreshInfoDisplayTime > (long)infoConfig.display) {
                Info.display((InfoConfig)infoConfig);
                this.lastRefreshInfoDisplayTime = time;
            }
        } else {
            this.mainModule.refresh(data);
            if (this.sidePanel != null) {
                this.sidePanel.refresh(data);
            }
        }
    }

    public void handleNewModuleSelection() {
        this.syncSelectionContext(1);
        this.toolbar.handleNewLinkerSelection();
        this.mainModule.handleNewModuleSelection(this.selectedModule);
        if (this.sidePanel != null) {
            this.sidePanel.handleNewModuleSelection(this.selectedModule);
        }
    }

    public void handleNewMainSelection() {
        this.syncSelectionContext(1);
        this.mainModule.handleNewMainSelection(this.mainPath, this.template);
        this.mainModule.handleNewModuleSelection(null);
        if (this.sidePanel != null) {
            this.sidePanel.handleNewMainSelection(this.mainPath);
        }
        this.toolbar.handleNewLinkerSelection();
    }

    public void handleNewMainNodeLoaded() {
        this.syncSelectionContext(1);
        GWTJahiaNode node = this.mainModule.getNode();
        this.toolbar.handleNewMainNodeLoaded(node);
        if (this.sidePanel != null) {
            this.sidePanel.handleNewMainNodeLoaded(node);
        }
        Document.get().getBody().setAttribute("data-main-node-displayname", node.getDisplayName());
        Document.get().getBody().setAttribute("data-main-node-path", node.getPath());
        Document.get().getBody().setAttribute("data-sitesettings", Boolean.toString(node.equals(JahiaGWTParameters.getSiteNode())));
    }

    protected void registerLinker() {
        this.registerLinker(true, true, true);
    }

    protected void registerLinker(boolean doMainModule, boolean doSidePanel, boolean doToolbar) {
        if (this.mainModule != null && doMainModule) {
            try {
                this.mainModule.initWithLinker(this);
            }
            catch (Exception e) {
                Log.error((String)"Error on init linker", (Throwable)e);
            }
        }
        if (this.sidePanel != null && doSidePanel) {
            try {
                this.sidePanel.initWithLinker(this);
            }
            catch (Exception e) {
                Log.error((String)"Error on init linker", (Throwable)e);
            }
        }
        if (this.toolbar != null && doToolbar) {
            try {
                this.toolbar.initWithLinker(this);
            }
            catch (Exception e) {
                Log.error((String)"Error on init linker", (Throwable)e);
            }
        }
    }

    @Override
    public void select(Object o) {
        if (o == null || o instanceof Module) {
            this.onModuleSelection((Module)((Object)o));
        }
    }

    @Override
    public void loaded() {
        this.mainModule.unmask();
    }

    @Override
    public void loading(String resource) {
        this.mainModule.mask(resource, "x-mask-loading");
    }

    @Override
    public void setSelectPathAfterDataUpdate(List<String> paths) {
    }

    @Override
    public LinkerSelectionContext getSelectionContext() {
        return this.selectionContext;
    }

    @Override
    public void syncSelectionContext(int context) {
        this.selectionContext.setMainNode(this.getMainModule().getNode());
        ArrayList<GWTJahiaNode> nodes = new ArrayList<GWTJahiaNode>();
        if (this.mainModule.isCtrlActive()) {
            nodes.addAll(this.selectionContext.getSelectedNodes());
        }
        if (this.getSelectedModule() != null && this.getSelectedModule().getNode() != null && !(this.getSelectedModule() instanceof MainModule) && !nodes.contains(this.getSelectedModule().getNode())) {
            nodes.add(this.getSelectedModule().getNode());
        }
        this.selectionContext.setSelectedNodes(nodes);
        this.selectionContext.refresh(context);
        if (this.selectionContext.getSingleSelection() != null) {
            EditLinker.setSelectionOnBodyAttributes(this.selectionContext.getSingleSelection());
        }
        Document.get().getBody().setAttribute("data-selection-count", this.selectionContext.getSelectedNodes() != null ? Integer.toString(this.selectionContext.getSelectedNodes().size()) : "0");
    }

    public static void setSelectionOnBodyAttributes(GWTJahiaNode node) {
        Document.get().getBody().setAttribute("data-singleselection-node-displayname", node.getDisplayName());
        Document.get().getBody().setAttribute("data-singleselection-node-path", node.getPath());
    }

    public void replaceMainAreaComponent(Widget w) {
        ContentPanel m;
        if (this.mainAreaComponent == null) {
            m = (ContentPanel)this.mainModule.getParent();
            this.mainModule.saveCurrentFramePosition();
            this.mainModule.setStyleAttribute("display", "none");
        } else {
            m = (ContentPanel)this.mainAreaComponent.getParent();
            m.remove(this.mainAreaComponent);
        }
        this.mainAreaComponent = w;
        m.insert(this.mainAreaComponent, 0, (LayoutData)new BorderLayoutData(Style.LayoutRegion.CENTER));
        m.layout();
    }

    public void restoreMainArea() {
        if (this.mainAreaComponent != null) {
            ContentPanel m = (ContentPanel)this.mainAreaComponent.getParent();
            m.remove(this.mainAreaComponent);
            this.mainAreaComponent = null;
            this.mainModule.setStyleAttribute("display", "block");
            m.layout();
            this.mainModule.moveToSavePosition();
        }
    }

    @Override
    public boolean isDisplayHiddenProperties() {
        return false;
    }

    public GWTJahiaChannel getActiveChannel() {
        return this.activeChannel;
    }

    public void setActiveChannel(GWTJahiaChannel activeChannel) {
        this.activeChannel = activeChannel;
        if (activeChannel == null || activeChannel.getValue().equals("generic")) {
            Document.get().getBody().removeAttribute("data-channel");
        } else {
            Document.get().getBody().setAttribute("data-channel", activeChannel.getValue());
        }
    }

    public String getActiveChannelIdentifier() {
        return this.activeChannel != null ? this.activeChannel.getValue() : null;
    }

    public String getActiveChannelVariant() {
        return this.activeChannelVariant;
    }

    public void setActiveChannelVariant(String activeChannelVariant) {
        this.activeChannelVariant = activeChannelVariant;
    }

    public boolean isInSettingsPage() {
        return this.isInSettingsPage;
    }

    public void setInSettingsPage(boolean inSettingsPage) {
        this.isInSettingsPage = inSettingsPage;
    }

    public int getActiveChannelVariantIndex() {
        int result = 0;
        if (this.getActiveChannel() != null && this.getActiveChannelVariant() != null) {
            String[] variantValueArray = this.getActiveChannel().getCapability("variants").split(",");
            for (int i = 0; i < variantValueArray.length; ++i) {
                if (!variantValueArray[i].equals(this.getActiveChannelVariant())) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    public Widget getMainAreaComponent() {
        return this.mainAreaComponent;
    }
}

