/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.sidepanel;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseListLoader;
import com.extjs.gxt.ui.client.data.DataProxy;
import com.extjs.gxt.ui.client.data.ListLoadResult;
import com.extjs.gxt.ui.client.data.ListLoader;
import com.extjs.gxt.ui.client.data.LoadEvent;
import com.extjs.gxt.ui.client.data.PagingLoadResult;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.dnd.DND;
import com.extjs.gxt.ui.client.dnd.DragSource;
import com.extjs.gxt.ui.client.dnd.ListViewDragSource;
import com.extjs.gxt.ui.client.dnd.StatusProxy;
import com.extjs.gxt.ui.client.event.DNDEvent;
import com.extjs.gxt.ui.client.event.DragEvent;
import com.extjs.gxt.ui.client.event.DragListener;
import com.extjs.gxt.ui.client.event.LoadListener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.StoreSorter;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.ListView;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.VBoxLayoutData;
import com.extjs.gxt.ui.client.widget.selection.AbstractStoreSelectionModel;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTSidePanelTab;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.Collator;
import org.jahia.ajax.gwt.client.util.content.JCRClientUtils;
import org.jahia.ajax.gwt.client.widget.content.ThumbsListView;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.BrowseTabItem;

class PortletBrowseTabItem
extends BrowseTabItem {
    protected transient LayoutContainer contentContainer;
    protected transient ListLoader<ListLoadResult<GWTJahiaNode>> listLoader;
    protected transient ListStore<GWTJahiaNode> contentStore;
    protected transient ImageDragSource dragSource;
    protected transient ThumbsListView listView;

    PortletBrowseTabItem() {
    }

    @Override
    public TabItem create(GWTSidePanelTab config) {
        super.create(config);
        this.contentContainer = new LayoutContainer();
        this.contentContainer.setBorders(true);
        this.contentContainer.setId("images-view");
        this.contentContainer.setScrollMode(Style.Scroll.AUTOY);
        RpcProxy<PagingLoadResult<GWTJahiaNode>> listProxy = new RpcProxy<PagingLoadResult<GWTJahiaNode>>(){

            protected void load(Object gwtJahiaFolder, AsyncCallback<PagingLoadResult<GWTJahiaNode>> listAsyncCallback) {
                if (gwtJahiaFolder != null) {
                    String path = ((GWTJahiaNode)gwtJahiaFolder).getPath();
                    Log.debug((String)("retrieving children of " + path));
                    JahiaContentManagementService.App.getInstance().lsLoad(path, JCRClientUtils.PORTLET_NODETYPES, null, null, Arrays.asList("permissions", "icon", "publicationInfo", "thumbnails", "tags"), false, -1, -1, false, null, null, false, false, listAsyncCallback);
                } else {
                    PortletBrowseTabItem.this.contentContainer.unmask();
                }
            }
        };
        this.listLoader = new BaseListLoader((DataProxy)listProxy);
        this.listLoader.addLoadListener(new LoadListener(){

            public void loaderLoad(LoadEvent le) {
                if (!le.isCancelled()) {
                    PortletBrowseTabItem.this.contentContainer.unmask();
                }
            }
        });
        this.contentStore = new ListStore(this.listLoader);
        this.contentStore.setStoreSorter(new StoreSorter((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    return Collator.getInstance().localeCompare(s1, s2);
                }
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return 0;
            }
        }));
        this.tree.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaNode>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaNode> event) {
                PortletBrowseTabItem.this.contentContainer.mask(Messages.get("label.loading", "Loading..."), "x-mask-loading");
                PortletBrowseTabItem.this.listLoader.load((Object)event.getSelectedItem());
            }
        });
        this.listView = new ThumbsListView(true);
        this.listView.setStyleAttribute("overflow-x", "hidden");
        this.listView.setStore(this.contentStore);
        this.contentContainer.add((Widget)this.listView);
        this.tree.setContextMenu(this.createContextMenu(config.getTreeContextMenu(), (AbstractStoreSelectionModel<GWTJahiaNode>)this.tree.getSelectionModel()));
        this.listView.setContextMenu(this.createContextMenu(config.getTableContextMenu(), (AbstractStoreSelectionModel<GWTJahiaNode>)this.listView.getSelectionModel()));
        VBoxLayoutData contentVBoxData = new VBoxLayoutData();
        contentVBoxData.setFlex(2.0);
        this.tab.add((Widget)this.contentContainer, (LayoutData)contentVBoxData);
        this.tab.setId("JahiaGxtPortletBrowseTab");
        return this.tab;
    }

    @Override
    public void initWithLinker(EditLinker linker) {
        super.initWithLinker(linker);
        if (linker.getConfig().isDragAndDropEnabled()) {
            this.dragSource = new ImageDragSource(this.listView);
            this.dragSource.addDNDListener(linker.getDndListener());
        }
    }

    @Override
    protected boolean acceptNode(GWTJahiaNode node) {
        return node.getInheritedNodeTypes().contains("jnt:portlet");
    }

    @Override
    public boolean needRefresh(Map<String, Object> data) {
        GWTJahiaNode node;
        if (data.containsKey("node") && ((node = (GWTJahiaNode)data.get("node")).getNodeTypes().contains("jnt:portlet") || node.getNodeTypes().contains("jnt:portletFolder"))) {
            return true;
        }
        return super.needRefresh(data);
    }

    public class ImageDragSource
    extends ListViewDragSource {
        public ImageDragSource(ListView listView) {
            super(listView);
            DragListener listener = new DragListener(){

                public void dragEnd(DragEvent de) {
                    DNDEvent e = new DNDEvent((DragSource)ImageDragSource.this, de.getEvent());
                    e.setData(ImageDragSource.this.data);
                    e.setDragEvent(de);
                    e.setComponent(ImageDragSource.this.component);
                    e.setStatus(ImageDragSource.this.statusProxy);
                    ImageDragSource.this.onDragEnd(e);
                }
            };
            this.draggable.addDragListener(listener);
        }

        protected void onDragStart(DNDEvent e) {
            e.getStatus().setData("sourceType", (Object)"content");
            ArrayList<GWTJahiaNode> nodes = new ArrayList<GWTJahiaNode>(1);
            nodes.add((GWTJahiaNode)this.listView.getSelectionModel().getSelectedItem());
            e.setData(nodes);
            ArrayList<GWTJahiaNode> list = new ArrayList<GWTJahiaNode>(1);
            list.add((GWTJahiaNode)this.listView.getSelectionModel().getSelectedItem());
            e.getStatus().setData("size", (Object)list.size());
            e.getStatus().setData("sourceNodes", list);
            e.setOperation(DND.Operation.COPY);
            super.onDragStart(e);
        }

        protected void onDragCancelled(DNDEvent dndEvent) {
            super.onDragCancelled(dndEvent);
            this.onDragEnd(dndEvent);
        }

        protected void onDragEnd(DNDEvent e) {
            StatusProxy sp = e.getStatus();
            sp.setData("sourceType", null);
            sp.setData("content", null);
            sp.setData("targetType", null);
            sp.setData("targetNode", null);
            sp.setData("targetPath", null);
            sp.setData("sourceNodes", null);
            sp.setData("query", null);
            sp.setData("sourceTemplate", null);
            sp.setData("operationCalled", null);
            e.setData(null);
        }
    }
}

