/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.widget.MessageBox;
import com.google.gwt.user.client.rpc.AsyncCallback;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTModuleReleaseInfo;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseActionItem;
import org.jahia.ajax.gwt.client.widget.toolbar.action.ForgeLoginWindow;

public class GoToForgeActionItem
extends BaseActionItem {
    private static final long serialVersionUID = 4466321584782980102L;

    @Override
    public void handleNewLinkerSelection() {
        GWTJahiaNode siteNode = JahiaGWTParameters.getSiteNode();
        this.setEnabled(siteNode.getProperties().containsKey("j:forgeUrl"));
    }

    @Override
    public void onComponentSelection() {
        this.linker.loading(Messages.get("label.releaseModule.loadingInfo", "Loading release information for module..."));
        JahiaContentManagementService.App.getInstance().getInfoForModuleRelease(JahiaGWTParameters.getSiteKey(), (AsyncCallback<GWTModuleReleaseInfo>)new BaseAsyncCallback<GWTModuleReleaseInfo>(){

            @Override
            public void onApplicationFailure(Throwable caught) {
                GoToForgeActionItem.this.linker.loaded();
                MessageBox.alert((String)Messages.get("label.error", "Error"), (String)(Messages.get("label.releaseModule.loadingInfo.failure", "Cannot load module information for release") + ":\n" + caught.getMessage()), null);
            }

            public void onSuccess(GWTModuleReleaseInfo result) {
                GoToForgeActionItem.this.linker.loaded();
                GoToForgeActionItem.this.onInfoLoaded(result);
            }
        });
    }

    protected void onInfoLoaded(final GWTModuleReleaseInfo result) {
        if (result != null) {
            final ForgeLoginWindow w = new ForgeLoginWindow();
            w.setCallback(new ForgeLoginWindow.Callback(){

                @Override
                public void handle(String username, String password) {
                    String forgeModulePageUrl = result.getForgeModulePageUrl();
                    if (username != null && password != null) {
                        forgeModulePageUrl = forgeModulePageUrl + "?username=" + username + "&password=" + password + "&doLogin=true";
                    }
                    String finalUrl = forgeModulePageUrl;
                    MainModule.getInstance().goToExternalUrl(finalUrl);
                    w.hide();
                }
            });
            w.show();
        } else {
            MessageBox.alert((String)Messages.get("label.error", "Error"), (String)Messages.get("label.releaseModule.distributionServer.notProvided", "No target distribution server configured for this module yet."), null);
        }
    }
}

