/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.data.GWTJahiaValueDisplayBean;

public class GWTJahiaChannel
extends GWTJahiaValueDisplayBean {
    public GWTJahiaChannel() {
    }

    public GWTJahiaChannel(String value, String display) {
        super(value, display);
    }

    public GWTJahiaChannel(String value, String display, String image, Map<String, String> capabilities) {
        super(value, display);
        this.set("image", image);
        this.setCapabilities(capabilities);
    }

    public Map<String, String> getCapabilities() {
        return (Map)this.get("capabilities");
    }

    public void setCapabilities(Map<String, String> capabilities) {
        this.set("capabilities", capabilities);
    }

    public String getCapability(String capabilityName) {
        if (capabilityName == null) {
            return null;
        }
        if (this.getCapabilities() == null) {
            return null;
        }
        return this.getCapabilities().get(capabilityName);
    }

    public List<String> getVariants() {
        String variantListStr = this.getCapability("variants");
        if (variantListStr == null) {
            return new ArrayList<String>();
        }
        String[] variantArray = variantListStr.split(",");
        return Arrays.asList(variantArray);
    }

    public String getCapabilityListAtIndex(String capabilityName, int listIndex) {
        String capabilityListValueStr = this.getCapability(capabilityName);
        if (capabilityListValueStr == null) {
            return null;
        }
        String[] capabilityValueArray = capabilityListValueStr.split(",");
        if (listIndex >= 0 && listIndex < capabilityValueArray.length) {
            return capabilityValueArray[listIndex];
        }
        return null;
    }

    public int[] getResolutionFromString(String resolutionString) {
        if (resolutionString == null) {
            return new int[0];
        }
        String[] resolutionStrArray = resolutionString.split("x");
        if (resolutionStrArray == null || resolutionStrArray.length != 2) {
            return new int[0];
        }
        int[] result = new int[]{Integer.parseInt(resolutionStrArray[0]), Integer.parseInt(resolutionStrArray[1])};
        return result;
    }

    public int[] getResolutionCapability(String capabilityName) {
        String resolutionCapabilityStr = this.getCapability(capabilityName);
        if (resolutionCapabilityStr == null) {
            return new int[0];
        }
        return this.getResolutionFromString(resolutionCapabilityStr);
    }

    public int[] getResolutionCapabilityAtIndex(String capabilityName, int variantIndex) {
        String resolutionCapabilityStr = this.getCapabilityListAtIndex(capabilityName, variantIndex);
        return this.getResolutionFromString(resolutionCapabilityStr);
    }

    public String getVariantDisplayName(int variantIndex) {
        return this.getCapabilityListAtIndex("variants-displayNames", variantIndex);
    }

    public String getVariantDecoratorImage(int variantIndex) {
        return this.getCapabilityListAtIndex("decorator-images", variantIndex);
    }

    public int[] getVariantDecoratorImageSize(int variantIndex) {
        return this.getResolutionCapabilityAtIndex("decorator-image-sizes", variantIndex);
    }

    public int[] getVariantDecoratorScreenPosition(int variantIndex) {
        return this.getResolutionCapabilityAtIndex("decorator-screen-positions", variantIndex);
    }

    public int[] getVariantUsableResolution(int variantIndex) {
        return this.getResolutionCapabilityAtIndex("usable-resolutions", variantIndex);
    }
}

