/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.util;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.menu.Item;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jahia.ajax.gwt.client.messages.Messages;

public class Formatter {
    public static final float GB = 1.0737418E9f;
    public static final float MB = 1048576.0f;
    public static final float KB = 1024.0f;
    public static final DateTimeFormat DEFAULT_DATETIME_FORMAT = DateTimeFormat.getFormat((String)"dd.MM.yyyy HH:mm");

    public static String getFormattedSize(long size) {
        NumberFormat nf = NumberFormat.getFormat((String)"0.00");
        StringBuffer dispSize = new StringBuffer();
        if ((float)size >= 1.0737418E9f) {
            dispSize.append(String.valueOf(nf.format((double)((float)size / 1.0737418E9f)))).append(" GB");
        } else if ((float)size >= 1048576.0f) {
            dispSize.append(String.valueOf(nf.format((double)((float)size / 1048576.0f)))).append(" MB");
        } else if ((float)size >= 1024.0f) {
            dispSize.append(String.valueOf(nf.format((double)((float)size / 1024.0f)))).append(" KB");
        } else {
            dispSize.append(String.valueOf(nf.format((double)size))).append(" B");
        }
        return dispSize.toString();
    }

    public static String getFormattedDate(Date date, String pattern) {
        return date != null ? (pattern != null ? DateTimeFormat.getFormat((String)pattern).format(date) : DEFAULT_DATETIME_FORMAT.format(date)) : "-";
    }

    public static String getFormattedDate(Date date) {
        return Formatter.getFormattedDate(date, null);
    }

    public static String getLockLabel(String lockInfo) {
        if (lockInfo == null || lockInfo.length() == 0) {
            return lockInfo;
        }
        if (lockInfo.startsWith("label.")) {
            return Messages.get(lockInfo);
        }
        return lockInfo.contains(":") ? lockInfo.substring(0, lockInfo.indexOf(":")) + " (" + lockInfo.substring(lockInfo.indexOf(":") + 1) + ")" : lockInfo;
    }

    public static void enableButton(Component ti) {
        if (!ti.isEnabled()) {
            ti.setEnabled(true);
        }
    }

    public static void disableButton(Component ti) {
        if (ti.isEnabled()) {
            ti.disable();
        }
    }

    public static void setButtonEnabled(Component ti, boolean b) {
        if (b) {
            Formatter.enableButton(ti);
        } else {
            Formatter.disableButton(ti);
        }
    }

    public static void enableMenuItem(Item mi) {
        if (!mi.isEnabled()) {
            mi.enable();
        }
    }

    public static void disableMenuItem(Item mi) {
        if (mi.isEnabled()) {
            mi.disable();
        }
    }

    public static void setMenuItemEnabled(MenuItem ti, boolean b) {
        if (b) {
            Formatter.enableMenuItem((Item)ti);
        } else {
            Formatter.disableMenuItem((Item)ti);
        }
    }

    public static String join(List<?> list, String separator) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder str = new StringBuilder(list.get(0).toString());
        for (int i = 1; i < list.size(); ++i) {
            str.append(separator);
            str.append(list.get(i).toString());
        }
        return str.toString();
    }

    public static String[] concat(String[] first, String[] second) {
        ArrayList both = new ArrayList(first.length + second.length);
        Collections.addAll(both, first);
        Collections.addAll(both, second);
        return both.toArray(new String[0]);
    }
}

