/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.util;

import com.extjs.gxt.ui.client.data.ModelData;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONBoolean;
import com.google.gwt.json.client.JSONNull;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.util.EventDataSupplier;

public class JsonUtils {
    private JsonUtils() {
    }

    private static String encodeValue(Object value) {
        if (value instanceof Date) {
            return Long.toString(((Date)value).getTime());
        }
        return value.toString();
    }

    public static JSONArray serialize(List<Object> data) {
        JSONArray jsona = new JSONArray();
        for (int i = 0; i < data.size(); ++i) {
            Object val = data.get(i);
            if (val instanceof Map) {
                jsona.set(i, (JSONValue)JsonUtils.serialize((Map)val));
                continue;
            }
            if (val instanceof List) {
                jsona.set(i, (JSONValue)JsonUtils.serialize((List)val));
                continue;
            }
            if (val instanceof String) {
                jsona.set(i, (JSONValue)new JSONString(JsonUtils.encodeValue(val)));
                continue;
            }
            if (val instanceof Number) {
                jsona.set(i, (JSONValue)new JSONString(JsonUtils.encodeValue(val)));
                continue;
            }
            if (val instanceof Boolean) {
                jsona.set(i, (JSONValue)JSONBoolean.getInstance((boolean)((Boolean)val)));
                continue;
            }
            if (val == null) {
                jsona.set(i, (JSONValue)JSONNull.getInstance());
                continue;
            }
            if (val instanceof Date) {
                jsona.set(i, (JSONValue)new JSONString(JsonUtils.encodeValue(val)));
                continue;
            }
            if (val instanceof ModelData) {
                jsona.set(i, (JSONValue)JsonUtils.serialize(((ModelData)val).getProperties()));
                continue;
            }
            if (!(val instanceof EventDataSupplier)) continue;
            jsona.set(i, (JSONValue)JsonUtils.serialize(((EventDataSupplier)val).getEventData()));
        }
        return jsona;
    }

    public static JSONObject serialize(Map<String, Object> data) {
        JSONObject jsobj = new JSONObject();
        for (String key : data.keySet()) {
            Object val = data.get(key);
            if (val instanceof String) {
                jsobj.put(key, (JSONValue)new JSONString(JsonUtils.encodeValue(val)));
                continue;
            }
            if (val instanceof Date) {
                jsobj.put(key, (JSONValue)new JSONString(JsonUtils.encodeValue(val)));
                continue;
            }
            if (val instanceof Number) {
                jsobj.put(key, (JSONValue)new JSONString(JsonUtils.encodeValue(val)));
                continue;
            }
            if (val instanceof Boolean) {
                jsobj.put(key, (JSONValue)JSONBoolean.getInstance((boolean)((Boolean)val)));
                continue;
            }
            if (val == null) {
                jsobj.put(key, (JSONValue)JSONNull.getInstance());
                continue;
            }
            if (val instanceof Map) {
                jsobj.put(key, (JSONValue)JsonUtils.serialize((Map)val));
                continue;
            }
            if (val instanceof List) {
                jsobj.put(key, (JSONValue)JsonUtils.serialize((List)val));
                continue;
            }
            if (val instanceof ModelData) {
                jsobj.put(key, (JSONValue)JsonUtils.serialize(((ModelData)val).getProperties()));
                continue;
            }
            if (!(val instanceof EventDataSupplier)) continue;
            jsobj.put(key, (JSONValue)JsonUtils.serialize(((EventDataSupplier)val).getEventData()));
        }
        return jsobj;
    }

    public static JSONObject serialize(ModelData data) {
        return JsonUtils.serialize(data.getProperties());
    }
}

