/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.CardLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineContainer;

public class EngineCards
extends LayoutContainer
implements EngineContainer {
    private EngineContainer mainContainer;
    private LayoutContainer cardsContainer;
    private Grid<BaseModelData> list;
    private List<Component> components = new ArrayList<Component>();
    private List<String> headers = new ArrayList<String>();
    private List<ButtonBar> bars = new ArrayList<ButtonBar>();
    private List<List<Component>> barItems = new ArrayList<List<Component>>();
    private ButtonBar bar;
    private int selectedCardIndex = 0;

    public EngineCards(EngineContainer mainContainer, Linker linker) {
        super((Layout)new BorderLayout());
        this.setId("JahiaGxtEngineCards");
        this.addStyleName("engine-cards");
        ListStore store = new ListStore();
        ColumnConfig lang = new ColumnConfig("lang", 50);
        ColumnConfig title = new ColumnConfig("header", 800);
        ColumnConfig actions = new ColumnConfig("action", 200);
        actions.setRenderer((GridCellRenderer)new GridCellRenderer<ModelData>(){

            public Object render(ModelData model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<ModelData> store, Grid<ModelData> grid) {
                return model.get("action");
            }
        });
        ColumnModel header = new ColumnModel(Arrays.asList(lang, title, actions));
        this.list = new Grid(store, header);
        this.list.setAutoExpandColumn("header");
        this.list.setHideHeaders(true);
        this.list.setAutoExpandMax(1200);
        this.list.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<BaseModelData>(){

            public void selectionChanged(SelectionChangedEvent<BaseModelData> se) {
                EngineCards.this.updateView();
            }
        });
        BorderLayoutData data = new BorderLayoutData(Style.LayoutRegion.NORTH, 150.0f);
        data.setCollapsible(true);
        data.setSplit(false);
        data.setFloatable(true);
        this.add((Widget)this.list, (LayoutData)data);
        this.cardsContainer = new LayoutContainer((Layout)new CardLayout());
        this.add((Widget)this.cardsContainer, (LayoutData)new BorderLayoutData(Style.LayoutRegion.CENTER));
        this.mainContainer = mainContainer;
        this.bar = new ButtonBar();
        this.bar.setAlignment(Style.HorizontalAlignment.CENTER);
        mainContainer.setEngine((Component)this, "", this.bar, null, linker);
    }

    @Override
    public ContentPanel getPanel() {
        return this.mainContainer.getPanel();
    }

    @Override
    public void setEngine(Component component, String header, ButtonBar buttonsBar, GWTJahiaLanguage language, Linker linker) {
        this.components.add(component);
        this.bars.add(buttonsBar);
        this.headers.add(header);
        BaseModelData data = new BaseModelData();
        data.set("header", (Object)header);
        data.set("action", (Object)buttonsBar);
        if (language != null) {
            data.set("lang", (Object)("<img src=\"" + language.getImage() + "\"/>&nbsp;"));
        }
        this.list.getStore().add((ModelData)data);
        this.cardsContainer.add((Widget)component);
    }

    @Override
    public void showEngine() {
        for (ButtonBar buttonBar : this.bars) {
            this.barItems.add(new ArrayList(buttonBar.getItems()));
        }
        this.list.getSelectionModel().select(0, false);
        this.mainContainer.showEngine();
    }

    @Override
    public void closeEngine() {
        this.closeEngine(this.selectedCardIndex);
    }

    private void updateView() {
        if (this.list.getSelectionModel().getSelectedItem() == null) {
            return;
        }
        String name = this.components.get(this.selectedCardIndex).getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1).toLowerCase();
        this.removeStyleName(name + "-ctn");
        this.mainContainer.getPanel().removeStyleName(name + "-card");
        this.selectedCardIndex = this.list.getStore().indexOf(this.list.getSelectionModel().getSelectedItem());
        name = this.components.get(this.selectedCardIndex).getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1).toLowerCase();
        this.addStyleName(name + "-ctn");
        this.mainContainer.getPanel().addStyleName(name + "-card");
        ((CardLayout)this.cardsContainer.getLayout()).setActiveItem(this.components.get(this.selectedCardIndex));
        this.mainContainer.getPanel().setHeadingHtml(this.headers.get(this.selectedCardIndex));
    }

    public void addGlobalButton(Button button) {
        if (button != null) {
            this.bar.add((Component)button);
        }
    }

    public Component getCurrentComponent() {
        return this.components.get(this.selectedCardIndex);
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public void closeAllEngines() {
        this.components.clear();
        this.headers.clear();
        this.bars.clear();
        this.barItems.clear();
        this.list.getStore().removeAll();
        this.mainContainer.closeEngine();
    }

    public void closeEngine(int cardIndex) {
        this.components.remove(cardIndex);
        this.headers.remove(cardIndex);
        this.bars.remove(cardIndex);
        this.barItems.remove(cardIndex);
        this.list.getStore().remove(cardIndex);
        if (this.list.getStore().getCount() == 0) {
            this.closeAllEngines();
        } else {
            if (this.selectedCardIndex >= this.list.getStore().getCount()) {
                this.selectedCardIndex = this.list.getStore().getCount() - 1;
            }
            this.list.getSelectionModel().select(this.selectedCardIndex, false);
        }
    }

    public void closeEngine(Component card) {
        this.closeEngine(this.components.indexOf(card));
    }
}

