/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BasePagingLoadConfig;
import com.extjs.gxt.ui.client.data.BasePagingLoadResult;
import com.extjs.gxt.ui.client.data.BasePagingLoader;
import com.extjs.gxt.ui.client.data.DataProxy;
import com.extjs.gxt.ui.client.data.ListLoader;
import com.extjs.gxt.ui.client.data.PagingLoadResult;
import com.extjs.gxt.ui.client.data.PagingLoader;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.GroupingStore;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.toolbar.PagingToolBar;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.data.GWTJahiaContentHistoryEntry;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementServiceAsync;
import org.jahia.ajax.gwt.client.util.Formatter;

public class HistoryPanel
extends LayoutContainer {
    private GWTJahiaNode node;
    private FormPanel detailsPanel;
    private List<GWTJahiaContentHistoryEntry> selectedItems = null;
    private PagingToolBar pagingToolBar;
    public static final String SECONDS_PRECISION_DATETIME_FORMAT = "dd.MM.yyyy HH:mm:ss";

    public HistoryPanel(GWTJahiaNode node) {
        super((Layout)new BorderLayout());
        this.node = node;
        this.init();
    }

    protected void onRender(Element parent, int index) {
        super.onRender(parent, index);
    }

    private void init() {
        this.setBorders(false);
        final JahiaContentManagementServiceAsync service = JahiaContentManagementService.App.getInstance();
        RpcProxy<PagingLoadResult<GWTJahiaContentHistoryEntry>> proxy = new RpcProxy<PagingLoadResult<GWTJahiaContentHistoryEntry>>(){

            protected void load(Object loadConfig, AsyncCallback<PagingLoadResult<GWTJahiaContentHistoryEntry>> callback) {
                if (loadConfig == null) {
                    service.getContentHistory(HistoryPanel.this.node.getUUID(), 0, Integer.MAX_VALUE, callback);
                } else if (loadConfig instanceof BasePagingLoadConfig) {
                    BasePagingLoadConfig pagingLoadConfig = (BasePagingLoadConfig)loadConfig;
                    int limit = pagingLoadConfig.getLimit();
                    int offset = pagingLoadConfig.getOffset();
                    service.getContentHistory(HistoryPanel.this.node.getUUID(), offset, limit, callback);
                } else {
                    callback.onSuccess((Object)new BasePagingLoadResult(new ArrayList()));
                }
            }
        };
        BasePagingLoader loader = new BasePagingLoader((DataProxy)proxy);
        loader.setRemoteSort(true);
        GroupingStore store = new GroupingStore((ListLoader)loader);
        store.groupBy("status");
        this.pagingToolBar = new PagingToolBar(50);
        PagingToolBar.PagingToolBarMessages pagingMessages = this.pagingToolBar.getMessages();
        pagingMessages.setEmptyMsg(pagingMessages.getEmptyMsg() + ". " + Messages.get("label.historyMayBeDelayed", "History may be delayed."));
        if (pagingMessages.getDisplayMsg() != null) {
            pagingMessages.setDisplayMsg(pagingMessages.getDisplayMsg() + ". " + Messages.get("label.historyMayBeDelayed", "History may be delayed."));
        }
        this.pagingToolBar.bind((PagingLoader)loader);
        ArrayList<ColumnConfig> config = new ArrayList<ColumnConfig>();
        ColumnConfig column = new ColumnConfig("date", Messages.get("label.date", "Date"), 125);
        column.setDateTimeFormat(DateTimeFormat.getFormat((String)SECONDS_PRECISION_DATETIME_FORMAT));
        column.setSortable(false);
        config.add(column);
        column = new ColumnConfig("action", Messages.get("label.action", "Action"), 90);
        column.setSortable(false);
        config.add(column);
        column = new ColumnConfig("userKey", Messages.get("label.user", "User"), 90);
        column.setSortable(false);
        config.add(column);
        column = new ColumnConfig("propertyName", Messages.get("label.property", "Property"), 90);
        column.setSortable(false);
        config.add(column);
        column = new ColumnConfig("languageCode", Messages.get("label.language", "Language"), 70);
        column.setSortable(false);
        config.add(column);
        column = new ColumnConfig("message", Messages.get("label.message", "Message"), 300);
        column.setSortable(false);
        column.setRenderer((GridCellRenderer)new GridCellRenderer<GWTJahiaContentHistoryEntry>(){

            public Object render(GWTJahiaContentHistoryEntry gwtJahiaContentHistoryEntry, String s, ColumnData columnData, int i, int i1, ListStore<GWTJahiaContentHistoryEntry> gwtJahiaContentHistoryEntryListStore, Grid<GWTJahiaContentHistoryEntry> gwtJahiaContentHistoryEntryGrid) {
                String message = HistoryPanel.this.buildMessage(gwtJahiaContentHistoryEntry);
                return new Label(message);
            }
        });
        config.add(column);
        ColumnModel cm = new ColumnModel(config);
        final Grid grid = new Grid((ListStore)store, cm);
        grid.setBorders(true);
        grid.setAutoExpandColumn("message");
        grid.setTrackMouseOver(false);
        grid.setStateId("historyPagingGrid");
        grid.setStateful(true);
        grid.addListener(Events.Attach, (Listener)new Listener<GridEvent<GWTJahiaContentHistoryEntry>>((PagingLoader)loader){
            final /* synthetic */ PagingLoader val$loader;
            {
                this.val$loader = pagingLoader;
            }

            public void handleEvent(GridEvent<GWTJahiaContentHistoryEntry> be) {
                BasePagingLoadConfig config = new BasePagingLoadConfig();
                config.setOffset(0);
                config.setLimit(50);
                Map state = grid.getState();
                if (state.containsKey("offset")) {
                    int offset = (Integer)state.get("offset");
                    int limit = (Integer)state.get("limit");
                    config.setOffset(offset);
                    config.setLimit(limit);
                }
                if (state.containsKey("sortField")) {
                    config.setSortField((String)state.get("sortField"));
                    config.setSortDir(Style.SortDir.valueOf((String)((String)state.get("sortDir"))));
                }
                this.val$loader.load((Object)config);
            }
        });
        grid.setLoadMask(true);
        grid.setBorders(true);
        grid.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaContentHistoryEntry>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaContentHistoryEntry> gwtJahiaJobDetailSelectionChangedEvent) {
                HistoryPanel.this.selectedItems = gwtJahiaJobDetailSelectionChangedEvent.getSelection();
                HistoryPanel.this.updateDetails();
            }
        });
        ContentPanel listPanel = new ContentPanel();
        listPanel.setFrame(true);
        listPanel.setCollapsible(false);
        listPanel.setAnimCollapse(false);
        listPanel.setHeaderVisible(false);
        listPanel.setLayout((Layout)new FitLayout());
        listPanel.add((Widget)grid);
        listPanel.setSize(600, 350);
        listPanel.setBottomComponent((Component)this.pagingToolBar);
        grid.getAriaSupport().setLabelledBy(listPanel.getId());
        this.add((Component)listPanel);
        BorderLayoutData centerData = new BorderLayoutData(Style.LayoutRegion.CENTER);
        this.add((Widget)listPanel, (LayoutData)centerData);
        FormPanel detailPanel = new FormPanel();
        detailPanel.setBorders(true);
        detailPanel.setBodyBorder(true);
        detailPanel.setHeaderVisible(true);
        detailPanel.setHeadingHtml(Messages.get("label.detailed", "Details"));
        detailPanel.setScrollMode(Style.Scroll.AUTOY);
        detailPanel.setLabelWidth(100);
        this.detailsPanel = detailPanel;
        BorderLayoutData southData = new BorderLayoutData(Style.LayoutRegion.SOUTH, 200.0f);
        southData.setSplit(true);
        southData.setCollapsible(true);
        this.add((Widget)detailPanel, (LayoutData)southData);
    }

    private String buildMessage(GWTJahiaContentHistoryEntry gwtJahiaContentHistoryEntry) {
        String message = gwtJahiaContentHistoryEntry.getMessage();
        if ("published".equals(gwtJahiaContentHistoryEntry.getAction())) {
            Object[] messageParts = message.split(";;");
            if (messageParts.length == 3) {
                message = Messages.getWithArgs("label.publishMessageWithComments", "Published from {0} to {1} with comments \"{2}\"", messageParts);
            } else if (messageParts.length == 2) {
                message = Messages.getWithArgs("label.publishMessage", "Published from {0} to {1}", messageParts);
            }
        }
        return message;
    }

    public void addDetail(String labelKey, String labelDefaultValue, Object value) {
        if (value != null) {
            TextField textField = new TextField();
            textField.setFieldLabel(Messages.get(labelKey, labelDefaultValue));
            textField.setReadOnly(true);
            if (value instanceof String) {
                textField.setValue(value);
            } else if (value instanceof Date) {
                textField.setValue((Object)Formatter.getFormattedDate((Date)value, SECONDS_PRECISION_DATETIME_FORMAT));
            } else {
                textField.setValue((Object)value.toString());
            }
            this.detailsPanel.add((Widget)textField, (LayoutData)new FormData("98%"));
        }
    }

    public void addTimeDetail(String labelKey, String labelDefaultValue, Object value) {
        if (value instanceof Long) {
            Date date = new Date((Long)value);
            this.addDetail(labelKey, labelDefaultValue, date);
        } else {
            this.addDetail(labelKey, labelDefaultValue, value);
        }
    }

    public void updateDetails() {
        if (this.detailsPanel == null) {
            return;
        }
        if (this.selectedItems == null || this.selectedItems.size() == 0) {
            return;
        }
        this.detailsPanel.removeAll();
        if (this.selectedItems.size() == 1) {
            GWTJahiaContentHistoryEntry historyEntry = this.selectedItems.get(0);
            this.addDetail("label.user", "User key", historyEntry.getUserKey());
            this.addTimeDetail("label.date", "Date", historyEntry.getDate());
            this.addDetail("label.property", "Property", historyEntry.getPropertyName());
            this.addDetail("label.language", "Language", historyEntry.getLanguageCode());
            this.addDetail("label.path", "Path", historyEntry.getPath());
            this.addDetail("label.action", "Action", historyEntry.getAction());
            this.addDetail("label.message", "Message", this.buildMessage(historyEntry));
        } else {
            int nbHistoryEntries = 0;
            for (GWTJahiaContentHistoryEntry historyEntry : this.selectedItems) {
                ++nbHistoryEntries;
            }
            this.detailsPanel.add((Widget)new HTML("<b>" + Messages.get("label.selectedHistoryEntryCount", "Number of selected history entries") + " :</b> " + nbHistoryEntries));
        }
        this.detailsPanel.layout();
    }
}

