/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.core.XTemplate;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.StoreEvent;
import com.extjs.gxt.ui.client.store.StoreListener;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.util.Util;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.DualListField;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridSelectionModel;
import com.extjs.gxt.ui.client.widget.layout.FillLayout;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.GWTJahiaCreateEngineInitBean;
import org.jahia.ajax.gwt.client.data.GWTJahiaEditEngineInitBean;
import org.jahia.ajax.gwt.client.data.GWTJahiaValueDisplayBean;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACL;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.publication.GWTJahiaPublicationInfo;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.util.icons.ToolbarIconProvider;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.AsyncTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;
import org.jahia.ajax.gwt.client.widget.definition.PropertiesEditor;

public class VisibilityTabItem
extends EditEngineTabItem {
    private transient Map<String, PropertiesEditor> propertiesEditorMap = new HashMap<String, PropertiesEditor>();
    private transient ListStore<GWTJahiaNode> conditionsStore;
    private transient List<GWTJahiaNode> deleted;
    private transient CheckBox allConditionsMatch;
    private transient boolean changed;
    private transient boolean oneTrue;
    private transient boolean oneFalse;
    private transient boolean oneUnknown;
    private transient StatusBar statusBar;

    public VisibilityTabItem() {
        this.setHandleCreate(false);
    }

    @Override
    public void init(NodeHolder engine, AsyncTabItem tab, String language) {
        if (engine.getNode() == null) {
            return;
        }
        final GWTJahiaNode node = engine.getNode();
        tab.setLayout((Layout)new RowLayout());
        tab.setProcessed(true);
        boolean editable = !engine.isExistingNode() || PermissionsUtils.isPermitted("jcr:modifyProperties", engine.getNode()) && engine.getNode().isLocked() == false;
        LayoutContainer top = new LayoutContainer((Layout)new FillLayout(Style.Orientation.VERTICAL));
        tab.add((Widget)top, (LayoutData)new RowData(1.0, 60.0, new Margins(5)));
        HorizontalPanel statusPanel = new HorizontalPanel();
        statusPanel.setVerticalAlign(Style.VerticalAlignment.MIDDLE);
        top.add((Widget)statusPanel);
        this.statusBar = new StatusBar(node, statusPanel, editable);
        HorizontalPanel addPanel = new HorizontalPanel();
        addPanel.setVerticalAlign(Style.VerticalAlignment.MIDDLE);
        if (editable) {
            top.add((Widget)addPanel);
        }
        addPanel.add((Widget)new HTML(Messages.get("label.visibility.allConditionsMatch", "All conditions should match") + ":&nbsp;"));
        this.allConditionsMatch = new CheckBox();
        this.allConditionsMatch.setEnabled(editable);
        this.allConditionsMatch.addListener(Events.Change, (Listener)new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent event) {
                VisibilityTabItem.this.changed = true;
                VisibilityTabItem.this.refreshConditionsList();
                VisibilityTabItem.this.statusBar.update();
            }
        });
        addPanel.add((Widget)this.allConditionsMatch);
        addPanel.add((Widget)new HTML("&nbsp;&nbsp;&nbsp;" + Messages.get("label.visibility.addCondition", "Add new condition") + ":&nbsp;"));
        final ListStore typesStore = new ListStore();
        final ComboBox types = new ComboBox();
        types.setDisplayField("label");
        types.setStore(typesStore);
        types.setTypeAhead(true);
        types.setTriggerAction(ComboBox.TriggerAction.ALL);
        types.setForceSelection(true);
        types.setEditable(false);
        types.setWidth(250);
        types.setEnabled(editable);
        addPanel.add((Widget)types);
        final HashMap typesMap = new HashMap();
        final Button add = new Button();
        add.setIcon(StandardIconsProvider.STANDARD_ICONS.plusRound());
        add.setEnabled(false);
        addPanel.add((Widget)add);
        this.conditionsStore = new ListStore();
        this.deleted = new ArrayList<GWTJahiaNode>();
        ArrayList<ColumnConfig> configs = new ArrayList<ColumnConfig>();
        ColumnConfig name = new ColumnConfig("name", Messages.get("label.title"), 500);
        name.setRenderer((GridCellRenderer)new GridCellRenderer<GWTJahiaNode>(){

            public Object render(GWTJahiaNode condition, String property, ColumnData config, int rowIndex, int colIndex, ListStore<GWTJahiaNode> store, Grid<GWTJahiaNode> grid) {
                String typeName = condition.getNodeTypes().get(0);
                XTemplate tpl = (XTemplate)((GWTJahiaNodeType)typesMap.get(typeName)).get("compiledTemplate");
                return tpl.applyTemplate(Util.getJsObject((ModelData)condition));
            }
        });
        name.setFixed(true);
        configs.add(name);
        ColumnConfig conditionStatus = new ColumnConfig("status", Messages.get("label.status"), 100);
        conditionStatus.setRenderer((GridCellRenderer)new GridCellRenderer<GWTJahiaNode>(){

            public Object render(GWTJahiaNode model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<GWTJahiaNode> gwtJahiaNodeListStore, Grid<GWTJahiaNode> gwtJahiaNodeGrid) {
                Boolean match = (Boolean)model.get("conditionMatch");
                if (match != null) {
                    if (match.equals(Boolean.TRUE)) {
                        AbstractImagePrototype icon = ToolbarIconProvider.getInstance().getIcon("visibilityStatusGreen");
                        return icon.getHTML();
                    }
                    AbstractImagePrototype icon = ToolbarIconProvider.getInstance().getIcon("visibilityStatusRed");
                    return icon.getHTML();
                }
                AbstractImagePrototype icon = ToolbarIconProvider.getInstance().getIcon("visibilityStatusUnknown");
                return icon.getHTML();
            }
        });
        configs.add(conditionStatus);
        if (editable) {
            ColumnConfig remove = new ColumnConfig("remove", Messages.get("label.remove"), 100);
            remove.setRenderer((GridCellRenderer)new GridCellRenderer<GWTJahiaNode>(){

                public Object render(final GWTJahiaNode condition, String property, ColumnData config, int rowIndex, int colIndex, ListStore<GWTJahiaNode> listStore, Grid<GWTJahiaNode> grid) {
                    Button button;
                    if (condition.get("node-removed") == null || condition.isMarkedForDeletion()) {
                        button = new Button(Messages.get("label.remove"));
                        button.addStyleName("button-remove");
                        button.setIcon(StandardIconsProvider.STANDARD_ICONS.minusRound());
                    } else {
                        button = new Button(Messages.get("label.undelete"));
                        button.addStyleName("button-undelete");
                        button.setIcon(StandardIconsProvider.STANDARD_ICONS.restore());
                    }
                    button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                        public void componentSelected(ButtonEvent buttonEvent) {
                            VisibilityTabItem.this.conditionsStore.remove((ModelData)condition);
                            VisibilityTabItem.this.propertiesEditorMap.remove(condition.getPath());
                            if (condition.get("new-node") == null) {
                                VisibilityTabItem.this.deleted.add(condition);
                                condition.set("node-removed", Boolean.TRUE);
                            }
                            VisibilityTabItem.this.changed = true;
                            VisibilityTabItem.this.refreshConditionsList();
                            VisibilityTabItem.this.statusBar.update();
                        }
                    });
                    return button;
                }
            });
            configs.add(remove);
        }
        ColumnModel cm = new ColumnModel(configs);
        final Grid conditions = new Grid(this.conditionsStore, cm);
        conditions.setAutoExpandColumn("name");
        tab.add((Widget)conditions, (LayoutData)new RowData(1.0, 0.5));
        final LayoutContainer form = new LayoutContainer((Layout)new FitLayout());
        form.setEnabled(editable);
        tab.add((Widget)form, (LayoutData)new RowData(1.0, 0.5));
        final GridSelectionModel selectionModel = conditions.getSelectionModel();
        selectionModel.setSelectionMode(Style.SelectionMode.SINGLE);
        selectionModel.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaNode>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaNode> event) {
                form.removeAll();
                final GWTJahiaNode conditionNode = (GWTJahiaNode)selectionModel.getSelectedItem();
                if (conditionNode != null) {
                    PropertiesEditor pe = (PropertiesEditor)((Object)VisibilityTabItem.this.propertiesEditorMap.get(conditionNode.getPath()));
                    if (pe != null) {
                        form.add((Widget)pe);
                        form.layout();
                    } else if (conditionNode.get("new-node") != null) {
                        final GWTJahiaNodeType type = (GWTJahiaNodeType)types.getSelection().get(0);
                        JahiaContentManagementService.App.getInstance().initializeCreateEngine(type.getName(), node.getPath(), null, (AsyncCallback<GWTJahiaCreateEngineInitBean>)new BaseAsyncCallback<GWTJahiaCreateEngineInitBean>(){

                            public void onSuccess(GWTJahiaCreateEngineInitBean result) {
                                PropertiesEditor pe = new PropertiesEditor(Arrays.asList(type), new HashMap<String, GWTJahiaNodeProperty>(), Arrays.asList("content"));
                                pe.setChoiceListInitializersValues(result.getChoiceListInitializersValues());
                                pe.renderNewFormPanel();
                                VisibilityTabItem.this.propertiesEditorMap.put(conditionNode.getPath(), pe);
                                form.add((Widget)pe);
                                form.layout();
                                VisibilityTabItem.this.addFieldListener(pe, conditions, conditionNode);
                            }
                        });
                    } else {
                        JahiaContentManagementService.App.getInstance().initializeEditEngine(conditionNode.getPath(), false, (AsyncCallback<GWTJahiaEditEngineInitBean>)new BaseAsyncCallback<GWTJahiaEditEngineInitBean>(){

                            public void onSuccess(GWTJahiaEditEngineInitBean result) {
                                PropertiesEditor pe = new PropertiesEditor(result.getNodeTypes(), result.getProperties(), Arrays.asList("content"));
                                pe.setChoiceListInitializersValues(result.getInitializersValues());
                                pe.renderNewFormPanel();
                                VisibilityTabItem.this.propertiesEditorMap.put(conditionNode.getPath(), pe);
                                form.add((Widget)pe);
                                form.layout();
                                VisibilityTabItem.this.addFieldListener(pe, conditions, conditionNode);
                            }
                        });
                    }
                }
            }
        });
        add.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                GWTJahiaNode newCondition = new GWTJahiaNode();
                List nodeTypes = types.getSelection();
                String nodeTypeName = ((GWTJahiaNodeType)nodeTypes.get(0)).getName();
                newCondition.setNodeTypes(Arrays.asList(nodeTypeName));
                String nodeName = nodeTypeName + VisibilityTabItem.this.conditionsStore.getCount();
                newCondition.setName(nodeName);
                newCondition.setPath(node.getPath() + "/j:conditionalVisibility/" + nodeName);
                newCondition.set("new-node", Boolean.TRUE);
                VisibilityTabItem.this.conditionsStore.add((ModelData)newCondition);
                selectionModel.select(Arrays.asList(newCondition), false);
                VisibilityTabItem.this.changed = true;
                VisibilityTabItem.this.refreshConditionsList();
                VisibilityTabItem.this.statusBar.update();
            }
        });
        if (editable) {
            types.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaNodeType>(){

                public void selectionChanged(SelectionChangedEvent<GWTJahiaNodeType> se) {
                    add.enable();
                }
            });
        }
        JahiaContentManagementService.App.getInstance().getVisibilityInformation(node.getPath(), (AsyncCallback<ModelData>)new BaseAsyncCallback<ModelData>(){

            public void onSuccess(ModelData result) {
                List l = (List)result.get("types");
                typesStore.add(l);
                types.setSelection(Arrays.asList((GWTJahiaNodeType)l.get(0)));
                for (GWTJahiaNodeType type : l) {
                    typesMap.put(type.getName(), type);
                    XTemplate tpl = XTemplate.create((String)((String)type.get("xtemplate")));
                    tpl.compile();
                    type.set("compiledTemplate", tpl);
                }
                VisibilityTabItem.this.conditionsStore.add((List)result.get("conditions"));
                VisibilityTabItem.this.refreshConditionsList();
                VisibilityTabItem.this.allConditionsMatch.setOriginalValue(result.get("j:forceMatchAllConditions"));
                VisibilityTabItem.this.allConditionsMatch.setValue((Boolean)result.get("j:forceMatchAllConditions"));
                VisibilityTabItem.this.statusBar.initStatusBar((GWTJahiaPublicationInfo)result.get("publicationInfo"), (Boolean)result.get("liveStatus"));
            }
        });
        tab.layout();
    }

    private void refreshConditionsList() {
        this.oneTrue = false;
        this.oneFalse = false;
        this.oneUnknown = false;
        for (GWTJahiaNode model : this.conditionsStore.getModels()) {
            Boolean match = (Boolean)model.get("conditionMatch");
            if (match != null) {
                if (match.equals(Boolean.TRUE)) {
                    this.oneTrue = true;
                } else {
                    this.oneFalse = true;
                }
            }
            if (model.get("new-node") == null) continue;
            this.oneUnknown = true;
        }
    }

    public void addFieldListener(PropertiesEditor pe, final Grid grid, final GWTJahiaNode conditionNode) {
        for (final Field<?> field : pe.getFields()) {
            final Field<?> f = field instanceof PropertiesEditor.PropertyAdapterField ? ((PropertiesEditor.PropertyAdapterField)field).getField() : field;
            if (f instanceof DualListField) {
                ((DualListField)f).getToList().getStore().addStoreListener(new StoreListener(){

                    public void handleEvent(StoreEvent e) {
                        ArrayList displayValue = new ArrayList();
                        List v = ((DualListField)f).getToList().getStore().getModels();
                        for (Object o : v) {
                            if (o instanceof GWTJahiaValueDisplayBean) {
                                ((List)displayValue).add(((GWTJahiaValueDisplayBean)o).getDisplay());
                                continue;
                            }
                            ((List)displayValue).add(o);
                        }
                        conditionNode.set(field.getName(), displayValue);
                        conditionNode.set("node-modified", Boolean.TRUE);
                        VisibilityTabItem.this.changed = true;
                        grid.getView().refresh(false);
                        VisibilityTabItem.this.statusBar.update();
                    }
                });
                continue;
            }
            field.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    Object value = field.getValue();
                    if (value instanceof GWTJahiaValueDisplayBean) {
                        value = ((GWTJahiaValueDisplayBean)value).getDisplay();
                    }
                    conditionNode.set(field.getName(), value);
                    conditionNode.set("node-modified", Boolean.TRUE);
                    VisibilityTabItem.this.changed = true;
                    grid.getView().refresh(false);
                    VisibilityTabItem.this.statusBar.update();
                }
            });
        }
    }

    @Override
    public void setProcessed(boolean processed) {
        if (!processed) {
            this.propertiesEditorMap = new HashMap<String, PropertiesEditor>();
            this.conditionsStore = null;
            this.deleted = null;
            this.allConditionsMatch = null;
            this.changed = false;
            this.oneTrue = false;
            this.oneFalse = false;
            this.oneUnknown = false;
            this.statusBar = null;
        }
        super.setProcessed(processed);
    }

    @Override
    public void doSave(GWTJahiaNode node, List<GWTJahiaNodeProperty> changedProperties, Map<String, List<GWTJahiaNodeProperty>> changedI18NProperties, Set<String> addedTypes, Set<String> removedTypes, List<GWTJahiaNode> chidren, GWTJahiaNodeACL acl) {
        if (this.conditionsStore != null) {
            List list = this.conditionsStore.getModels();
            for (GWTJahiaNode jahiaNode : list) {
                PropertiesEditor pe = this.propertiesEditorMap.get(jahiaNode.getPath());
                if (pe == null) continue;
                jahiaNode.set("gwtproperties", pe.getProperties(false, true, false));
            }
            list.addAll(this.deleted);
            node.set("visibilityConditions", list);
            if (this.allConditionsMatch.isDirty()) {
                node.set("node-visibility-forceMatchAllConditions", this.allConditionsMatch.getValue());
            }
        }
    }

    class StatusBar {
        private GWTJahiaNode node;
        private HorizontalPanel statusPanel;
        private boolean editable;
        private GWTJahiaPublicationInfo info;
        private LayoutContainer statusContainer;
        private CheckBox checkbox;
        private LayoutContainer publicationInfoContainer;

        StatusBar(GWTJahiaNode node, HorizontalPanel statusPanel, boolean editable) {
            this.node = node;
            this.statusPanel = statusPanel;
            this.editable = editable;
            statusPanel.add((Widget)new HTML(Messages.get("label.visibility.currentStatusInLive", "Current status in live") + ":&nbsp;"));
        }

        private void initStatusBar(GWTJahiaPublicationInfo info, Boolean liveStatus) {
            this.info = info;
            if (Boolean.TRUE.equals(liveStatus)) {
                this.statusPanel.add((Widget)ToolbarIconProvider.getInstance().getIcon("visibilityStatusGreen").createImage());
            } else if (Boolean.FALSE.equals(liveStatus)) {
                this.statusPanel.add((Widget)ToolbarIconProvider.getInstance().getIcon("visibilityStatusRed").createImage());
            } else {
                this.statusPanel.add((Widget)new HTML("not published"));
            }
            this.statusPanel.add((Widget)new HTML("&nbsp;&nbsp;&nbsp;" + Messages.get("label.visibility.currentConditionsResult", "Current conditions result") + ":&nbsp;"));
            this.statusContainer = new LayoutContainer((Layout)new FitLayout());
            this.statusPanel.add((Widget)this.statusContainer);
            GWTJahiaPublicationInfo aggregatedPublicationInfo = this.node.getAggregatedPublicationInfo();
            if (aggregatedPublicationInfo != null && aggregatedPublicationInfo.getStatus() != 4) {
                this.statusPanel.add((Widget)new HTML("&nbsp;&nbsp;&nbsp;" + Messages.get("label.visibility.publicationStatus", "Publication status") + ":&nbsp;"));
                this.publicationInfoContainer = new LayoutContainer((Layout)new FitLayout());
                this.statusPanel.add((Widget)this.publicationInfoContainer);
                this.statusPanel.add((Widget)new HTML("&nbsp;&nbsp;&nbsp;" + Messages.get("label.visibility.publishOnSave", "Publish conditions on save") + ":&nbsp;"));
                this.checkbox = new CheckBox();
                this.checkbox.setEnabled(this.editable);
                this.checkbox.addListener(Events.Change, (Listener)new Listener<ComponentEvent>(){

                    public void handleEvent(ComponentEvent event) {
                        StatusBar.this.node.set("conditions-published", StatusBar.this.checkbox.getValue());
                    }
                });
                this.statusPanel.add((Widget)this.checkbox);
            }
            this.update();
        }

        private void update() {
            if (this.statusContainer != null) {
                this.statusContainer.removeAll();
                if (VisibilityTabItem.this.oneUnknown && (VisibilityTabItem.this.allConditionsMatch.getValue().booleanValue() || !VisibilityTabItem.this.oneTrue && !VisibilityTabItem.this.oneFalse)) {
                    this.statusContainer.add((Widget)ToolbarIconProvider.getInstance().getIcon("visibilityStatusUnknown").createImage());
                } else if (VisibilityTabItem.this.allConditionsMatch.getValue() != false && !VisibilityTabItem.this.oneFalse || VisibilityTabItem.this.allConditionsMatch.getValue() == false && VisibilityTabItem.this.oneTrue || !VisibilityTabItem.this.oneTrue && !VisibilityTabItem.this.oneFalse) {
                    this.statusContainer.add((Widget)ToolbarIconProvider.getInstance().getIcon("visibilityStatusGreen").createImage());
                } else {
                    this.statusContainer.add((Widget)ToolbarIconProvider.getInstance().getIcon("visibilityStatusRed").createImage());
                }
            }
            if (this.publicationInfoContainer != null) {
                int infoStatus;
                if (this.info != null) {
                    infoStatus = this.info.getStatus();
                    if (VisibilityTabItem.this.changed && infoStatus == 1) {
                        infoStatus = 3;
                    }
                } else {
                    infoStatus = VisibilityTabItem.this.changed ? 4 : 1;
                }
                Image res = GWTJahiaPublicationInfo.renderPublicationStatusImage(infoStatus);
                this.publicationInfoContainer.removeAll();
                this.publicationInfoContainer.add((Widget)res);
                this.checkbox.setEnabled(infoStatus != 1);
            }
            this.statusPanel.layout();
        }
    }
}

