/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.definition;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.GXT;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.core.El;
import com.extjs.gxt.ui.client.core.Template;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.EventType;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldSetEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.util.Params;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.AdapterField;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.DualListField;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TriggerField;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.extjs.gxt.ui.client.widget.layout.HBoxLayout;
import com.extjs.gxt.ui.client.widget.layout.HBoxLayoutData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTChoiceListInitializer;
import org.jahia.ajax.gwt.client.data.GWTJahiaValueDisplayBean;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaItemDefinition;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaPropertyDefinition;
import org.jahia.ajax.gwt.client.data.node.GWTBitSet;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.definition.FormFieldCreator;
import org.jahia.ajax.gwt.client.widget.content.ContentPickerField;
import org.jahia.ajax.gwt.client.widget.content.MultipleNumberField;
import org.jahia.ajax.gwt.client.widget.content.MultipleTextField;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;
import org.jahia.ajax.gwt.client.widget.definition.LangPropertiesEditor;
import org.jahia.ajax.gwt.client.widget.form.tag.TagField;

public class PropertiesEditor
extends FormPanel {
    private List<GWTJahiaNodeType> nodeTypes = null;
    private List<GWTJahiaNodeType> mixin = null;
    private Map<String, GWTChoiceListInitializer> choiceListInitializersValues;
    private Map<String, List<GWTJahiaNodePropertyValue>> defaultValues;
    private Map<String, GWTJahiaNodeProperty> currentProperties = null;
    private Map<String, GWTJahiaNodeProperty> originalProperties = null;
    private Map<String, PropertyAdapterField> fields;
    private Map<String, FieldSet> fieldSets;
    private List<FieldSet> orderingListFieldSet = new ArrayList<FieldSet>();
    private Map<String, GWTJahiaItemDefinition> propertyDefinitions = new HashMap<String, GWTJahiaItemDefinition>();
    private boolean isMultipleEdit = false;
    private boolean viewInheritedItems = true;
    private boolean viewCopyToAllLangs = false;
    private List<String> excludedItems;
    private List<String> excludedTypes;
    private List<String> dataType;
    private boolean isWriteable = true;
    private boolean isNonI18NWriteable = true;
    private boolean fieldSetGrouping = false;
    private Set<String> addedTypes = new HashSet<String>();
    private Set<String> removedTypes = new HashSet<String>();
    private Map<String, Set<GWTJahiaNodeType>> externalMixin = new HashMap<String, Set<GWTJahiaNodeType>>();
    private String locale = "";
    private GWTBitSet permissions;
    private LangPropertiesEditor translationSource;
    private LangPropertiesEditor translationTarget;
    private NodeHolder engine;
    private boolean displayHiddenProperties = false;

    public void setPermissions(GWTBitSet permissions) {
        this.permissions = permissions;
    }

    public boolean isDisplayHiddenProperties() {
        return this.displayHiddenProperties;
    }

    public void setDisplayHiddenProperties(boolean displayHiddenProperties) {
        this.displayHiddenProperties = displayHiddenProperties;
    }

    public PropertiesEditor(List<GWTJahiaNodeType> nodeTypes, Map<String, GWTJahiaNodeProperty> properties, List<String> datatype) {
        this(nodeTypes, properties, datatype, null);
    }

    public PropertiesEditor(List<GWTJahiaNodeType> nodeTypes, Map<String, GWTJahiaNodeProperty> properties, List<String> datatype, NodeHolder engine) {
        this.nodeTypes = nodeTypes;
        this.dataType = datatype;
        this.originalProperties = properties;
        this.engine = engine;
        this.cloneProperties();
    }

    public void setNodeTypes(List<GWTJahiaNodeType> nodeTypes) {
        this.nodeTypes = nodeTypes;
    }

    public void setMixin(List<GWTJahiaNodeType> mixin) {
        this.mixin = mixin;
    }

    public void setChoiceListInitializersValues(Map<String, GWTChoiceListInitializer> initializersValues) {
        this.choiceListInitializersValues = initializersValues;
    }

    public void setDefaultValues(Map<String, List<GWTJahiaNodePropertyValue>> defaultValues) {
        this.defaultValues = defaultValues;
    }

    public void setMultipleEdit(boolean multipleEdit) {
        this.isMultipleEdit = multipleEdit;
    }

    public void setViewInheritedItems(boolean viewInheritedItems) {
        this.viewInheritedItems = viewInheritedItems;
    }

    public void setViewCopyToAllLangs(boolean viewCopyToAllLangs) {
        this.viewCopyToAllLangs = viewCopyToAllLangs;
    }

    public void setExcludedItems(List<String> excludedItems) {
        this.excludedItems = excludedItems;
    }

    public void setExcludedTypes(List<String> excludedTypes) {
        this.excludedTypes = excludedTypes;
    }

    public void setWriteable(boolean writeable) {
        this.isWriteable = writeable;
    }

    public void setNonI18NWriteable(boolean nonI18NWriteable) {
        this.isNonI18NWriteable = nonI18NWriteable;
    }

    public void setFieldSetGrouping(boolean fieldSetGrouping) {
        this.fieldSetGrouping = fieldSetGrouping;
    }

    public void renderNewFormPanel() {
        this.setLabelWidth(180);
        this.setLabelAlign(FormPanel.LabelAlign.TOP);
        this.setPadding(5);
        this.setCollapsible(false);
        this.setFrame(false);
        this.setAnimCollapse(false);
        this.setBorders(false);
        this.setBodyBorder(false);
        this.setHeaderVisible(false);
        this.setScrollMode(Style.Scroll.AUTO);
        this.setButtonAlign(Style.HorizontalAlignment.CENTER);
        this.removeAll();
        this.fields = new HashMap<String, PropertyAdapterField>();
        this.fieldSets = new HashMap<String, FieldSet>();
        ArrayList<String> supertypes = new ArrayList<String>();
        for (GWTJahiaNodeType nodeType : this.nodeTypes) {
            supertypes.addAll(nodeType.getSuperTypes());
            if (this.mixin != null && this.mixin.contains(nodeType)) continue;
            this.addItems(nodeType, nodeType.getItems(), false, this.fieldSetGrouping, null);
            if (!this.viewInheritedItems) continue;
            this.addItems(nodeType, nodeType.getInheritedItems(), false, this.fieldSetGrouping, null);
        }
        if (this.mixin != null) {
            for (GWTJahiaNodeType mix : this.mixin) {
                if (supertypes.contains(mix.getName()) || mix.getSuperTypes().contains("jmix:templateMixin")) continue;
                ArrayList<GWTJahiaItemDefinition> list = new ArrayList<GWTJahiaItemDefinition>(mix.getItems());
                if (this.viewInheritedItems) {
                    list.addAll(mix.getInheritedItems());
                }
                this.addItems(mix, list, true, this.fieldSetGrouping, null);
            }
        }
    }

    private void addItems(final GWTJahiaNodeType nodeType, List<GWTJahiaItemDefinition> items, boolean optional, boolean fieldSetGrouping, Field<?> remoteField) {
        FieldSet fieldSet = null;
        if (remoteField != null) {
            fieldSet = (FieldSet)remoteField.getParent();
        }
        for (int itemIndex = 0; itemIndex < items.size(); ++itemIndex) {
            String declaringNodeTypeLabel;
            GWTJahiaItemDefinition definition = items.get(itemIndex);
            FormLayout fl = new FormLayout(){
                private Template fieldTemplate = null;

                protected void renderField(Field<?> field, int index, El target) {
                    int pad;
                    if (!(field instanceof PropertyAdapterField)) {
                        super.renderField(field, index, target);
                        return;
                    }
                    if (this.fieldTemplate == null) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("<div role='presentation' class='x-form-item {9} {5}' tabIndex='-1'>");
                        sb.append("<label for={8} style='{2};{7}' class=x-form-item-label>{1}{4}</label>");
                        sb.append("<div role='presentation' class='x-form-element x-form-el-{0}' id='x-form-el-{0}' style='{3}'>");
                        sb.append("</div><div class='{6}' role='presentation'></div>");
                        sb.append("</div>");
                        this.fieldTemplate = new Template(sb.toString());
                        this.fieldTemplate.compile();
                    }
                    String ls = field.getLabelSeparator() != null ? field.getLabelSeparator() : super.getLabelSeparator();
                    field.setLabelSeparator(ls);
                    Params p = new Params();
                    if (super.getHideLabels()) {
                        field.setHideLabel(true);
                    }
                    int n = pad = this.getLabelPad() != 0 ? this.getLabelPad() : 5;
                    String elementStyle = this.getHideLabels() ? "padding-left:0;" : (this.getLabelAlign() == FormPanel.LabelAlign.TOP ? "padding-left:0;" : "padding-left:" + (this.getLabelWidth() + pad) + "px");
                    p.add((Object)field.getId());
                    p.add((Object)field.getFieldLabel());
                    p.add((Object)super.getLabelWidth());
                    p.add((Object)elementStyle);
                    p.add((Object)ls);
                    p.add((Object)(field.isHideLabel() ? "x-hide-label" : ""));
                    p.add((Object)"x-form-clear-left");
                    p.add((Object)field.getLabelStyle());
                    String inputId = field.getId();
                    p.add((Object)inputId);
                    boolean internationalized = ((PropertyAdapterField)field).getDefinition().isInternationalized();
                    p.add((Object)(internationalized ? "prop-i18n-field" : "prop-field"));
                    this.fieldTemplate.insert(target.dom, index, p);
                    if (field.isRendered()) {
                        target.selectNode(".x-form-el-" + field.getId()).appendChild(field.getElement());
                    } else {
                        field.render(target.selectNode((String)new StringBuilder().append((String)".x-form-el-").append((String)field.getId()).toString()).dom);
                    }
                    if (field.getStyleName().contains("-wrap")) {
                        inputId = inputId + "-input";
                        target.selectNode(".x-form-el-" + field.getId()).previousSibling().setAttribute("for", inputId);
                    }
                }
            };
            fl.setLabelWidth(0);
            if (this.excludedTypes != null && this.excludedTypes.contains(definition.getDeclaringNodeType()) || this.excludedItems != null && this.excludedItems.contains(definition.getName()) || remoteField == null && this.dataType != null && !this.dataType.isEmpty() && !this.dataType.contains(definition.getDataType())) continue;
            ArrayList<String> defaultedProperties = new ArrayList<String>();
            if (!this.currentProperties.containsKey(definition.getName())) {
                GWTJahiaNodeProperty property = new GWTJahiaNodeProperty();
                property.setName(definition.getName());
                property.setValues(new ArrayList<GWTJahiaNodePropertyValue>());
                if (!definition.isNode()) {
                    property.setMultiple(((GWTJahiaPropertyDefinition)definition).isMultiple());
                }
                this.currentProperties.put(definition.getName(), property);
            }
            GWTJahiaNodeProperty gwtJahiaNodeProperty = this.currentProperties.get(definition.getName());
            String key = definition.getOverrideDeclaringNodeType() + "." + definition.getName();
            GWTChoiceListInitializer choiceListInitializer = this.choiceListInitializersValues != null ? this.choiceListInitializersValues.get(key) : null;
            List<GWTJahiaNodePropertyValue> propertyDefaultValues = null;
            if (this.defaultValues != null && (this.originalProperties.isEmpty() || this.originalProperties.containsKey(definition.getName()) || !this.nodeTypes.contains(nodeType) || this.engine != null && !this.engine.isExistingNode())) {
                propertyDefaultValues = this.defaultValues.get(key);
            }
            if (propertyDefaultValues != null && gwtJahiaNodeProperty.getValues().size() == 0 && (this.originalProperties.isEmpty() || this.originalProperties.containsKey(definition.getName()))) {
                defaultedProperties.add(definition.getName());
            }
            Field<?> field = FormFieldCreator.createField(definition, gwtJahiaNodeProperty, choiceListInitializer, this.displayHiddenProperties, this.permissions, propertyDefaultValues);
            this.propertyDefinitions.put(gwtJahiaNodeProperty.getName(), definition);
            if (field == null) continue;
            String string = declaringNodeTypeLabel = optional ? nodeType.getLabel() : definition.getDeclaringNodeTypeLabel();
            if (fieldSet == null || fieldSetGrouping && !fieldSet.getId().equals(declaringNodeTypeLabel)) {
                fieldSet = new FieldSet();
                fieldSet.setId(declaringNodeTypeLabel);
                fieldSet.setHeadingHtml(declaringNodeTypeLabel);
                fieldSet.setLayout((Layout)fl);
                if (GXT.isSafari) {
                    fieldSet.setStyleAttribute("overflow", "visible");
                }
                this.fieldSets.put(optional ? nodeType.getName() : definition.getDeclaringNodeType(), fieldSet);
                this.add((Component)fieldSet);
            }
            if (!this.isWriteable || !this.isNonI18NWriteable && !definition.isNode() && !((GWTJahiaPropertyDefinition)definition).isInternationalized()) {
                field.setReadOnly(true);
                if (field instanceof TriggerField) {
                    ((TriggerField)field).setHideTrigger(true);
                }
            }
            final PropertyAdapterField adapterField = new PropertyAdapterField(field, definition, gwtJahiaNodeProperty, remoteField);
            adapterField.setWidth("98%");
            adapterField.setStyleAttribute("padding-left", "0");
            if (definition.isInternationalized()) {
                adapterField.addStyleName("field-i18n");
            }
            this.fields.put(field.getName(), adapterField);
            FormData fd = new FormData("98%");
            fd.setMargins(new Margins(0));
            if (remoteField != null) {
                Component component;
                int remoteFieldIndex = 0;
                Iterator iterator = fieldSet.getItems().iterator();
                while (iterator.hasNext() && !(component = (Component)iterator.next()).equals(remoteField)) {
                    ++remoteFieldIndex;
                }
                fieldSet.insert((Widget)adapterField, remoteFieldIndex + itemIndex + 1, (LayoutData)fd);
            } else {
                fieldSet.add((Widget)adapterField, (LayoutData)fd);
            }
            fieldSet.layout();
            if (optional) {
                boolean isOrderingList = "jmix:orderedList".equalsIgnoreCase(definition.getDeclaringNodeType());
                if (this.isWriteable && this.isNonI18NWriteable) {
                    fieldSet.setCollapsible(true);
                    if (!isOrderingList) {
                        fieldSet.setCheckboxToggle(true);
                        if (this.nodeTypes.contains(nodeType) && !this.removedTypes.contains(nodeType.getName()) || this.addedTypes.contains(nodeType.getName())) {
                            fieldSet.setExpanded(true);
                        } else {
                            fieldSet.setExpanded(false);
                        }
                        fieldSet.addListener(Events.Collapse, (Listener)new Listener<FieldSetEvent>(){

                            public void handleEvent(FieldSetEvent componentEvent) {
                                PropertiesEditor.this.removedTypes.add(nodeType.getName());
                                PropertiesEditor.this.addedTypes.remove(nodeType.getName());
                                FieldSet fs = (FieldSet)componentEvent.getBoxComponent();
                                for (Component component : fs.getItems()) {
                                    PropertyAdapterField adapterField;
                                    if (component instanceof PropertyAdapterField && (adapterField = (PropertyAdapterField)component).getField() instanceof ComboBox) {
                                        List selection = ((ComboBox)adapterField.getField()).getSelection();
                                        PropertiesEditor.this.removeExternalMixin(selection, adapterField);
                                    }
                                    component.setData("addedField", null);
                                }
                            }
                        });
                        fieldSet.addListener(Events.Expand, (Listener)new Listener<FieldSetEvent>(){

                            public void handleEvent(FieldSetEvent componentEvent) {
                                PropertiesEditor.this.addedTypes.add(nodeType.getName());
                                PropertiesEditor.this.removedTypes.remove(nodeType.getName());
                                final FieldSet fs = (FieldSet)componentEvent.getBoxComponent();
                                final ArrayList w = new ArrayList();
                                w.addAll(fs.getItems());
                                fs.removeAll();
                                DeferredCommand.addCommand((Command)new Command(){

                                    public void execute() {
                                        for (Component component : w) {
                                            component.setWidth("98%");
                                            fs.add((Widget)component);
                                            component.setData("addedField", (Object)"true");
                                        }
                                        fs.layout();
                                    }
                                });
                            }
                        });
                    }
                } else if (!this.nodeTypes.contains(nodeType)) {
                    fieldSet.setVisible(false);
                }
                if (isOrderingList) {
                    this.orderingListFieldSet.add(fieldSet);
                }
            }
            if (field instanceof ComboBox) {
                final ComboBox c = (ComboBox)field;
                final List oldSelection = c.getSelection();
                c.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaValueDisplayBean>(){

                    public void selectionChanged(SelectionChangedEvent<GWTJahiaValueDisplayBean> event) {
                        PropertiesEditor.this.removeExternalMixin(oldSelection, adapterField);
                        PropertiesEditor.this.setExternalMixin(adapterField);
                        if (oldSelection.size() > 0) {
                            oldSelection.remove(0);
                        }
                        oldSelection.add(c.getSelection().get(0));
                    }
                });
                if (c.getValue() != null) {
                    this.setExternalMixin(adapterField);
                }
            }
            if (!defaultedProperties.contains(field.getName())) continue;
            field.setData("defaultedField", (Object)"true");
        }
    }

    public void setExternalMixin(PropertyAdapterField c) {
        GWTJahiaNodeType mix;
        String addMixin = null;
        if (c.getValue() != null) {
            addMixin = (String)((GWTJahiaValueDisplayBean)((ComboBox)c.getField()).getValue()).get("addMixin");
        }
        if (addMixin != null && (mix = this.getMixin(addMixin)) != null && !this.externalMixinExist(addMixin)) {
            HashSet<GWTJahiaNodeType> inheritedMixins = new HashSet<GWTJahiaNodeType>();
            if (mix.getSuperTypes() != null) {
                for (String superType : mix.getSuperTypes()) {
                    GWTJahiaNodeType superMix = this.getMixin(superType);
                    if (superMix == null || this.externalMixinExist(superMix.getName())) continue;
                    inheritedMixins.add(superMix);
                }
            }
            this.externalMixin.put(mix.getName(), inheritedMixins);
            this.addItems(mix, mix.getItems(), false, false, (Field<?>)c);
            for (GWTJahiaNodeType inheritedMixin : inheritedMixins) {
                this.addItems(inheritedMixin, inheritedMixin.getItems(), false, false, (Field<?>)c);
            }
        }
    }

    private boolean externalMixinExist(String mixinName) {
        for (String externalMixinKey : this.externalMixin.keySet()) {
            if (externalMixinKey.equals(mixinName)) {
                return true;
            }
            for (GWTJahiaNodeType externalInheritedMixinKey : this.externalMixin.get(externalMixinKey)) {
                if (!externalInheritedMixinKey.getName().equals(mixinName)) continue;
                return true;
            }
        }
        return false;
    }

    private GWTJahiaNodeType getMixin(String mixinName) {
        if (this.mixin != null) {
            for (GWTJahiaNodeType mix : this.mixin) {
                if (!mix.getName().equals(mixinName)) continue;
                return mix;
            }
        }
        return null;
    }

    private void removeExternalMixin(List<GWTJahiaValueDisplayBean> oldSelection, PropertyAdapterField c) {
        String removeMixin;
        if (oldSelection != null && oldSelection.size() > 0 && oldSelection.get(0).getValue() != null && this.externalMixin.containsKey(removeMixin = (String)oldSelection.get(0).get("addMixin"))) {
            this.removedTypes.add(removeMixin);
            Set<GWTJahiaNodeType> inheritedMixins = this.externalMixin.remove(removeMixin);
            FieldSet fs = (FieldSet)c.getParent();
            HashSet<Component> compToRemove = new HashSet<Component>();
            for (Component co : fs.getItems()) {
                if (!(co instanceof PropertyAdapterField)) continue;
                String fieldDeclaringNodeType = ((PropertyAdapterField)co).getDefinition().getDeclaringNodeType();
                if (fieldDeclaringNodeType.equals(removeMixin)) {
                    compToRemove.add(co);
                }
                for (GWTJahiaNodeType inheritedMixin : inheritedMixins) {
                    if (!fieldDeclaringNodeType.equals(inheritedMixin.getName())) continue;
                    compToRemove.add(co);
                }
            }
            for (Component co : compToRemove) {
                this.fields.remove(((PropertyAdapterField)co).getName());
                co.removeFromParent();
            }
        }
    }

    private void cloneProperties() {
        this.currentProperties = new HashMap<String, GWTJahiaNodeProperty>();
        if (this.originalProperties != null) {
            for (String aProp : this.originalProperties.keySet()) {
                this.currentProperties.put(aProp, this.originalProperties.get(aProp).cloneObject());
            }
        }
    }

    public List<GWTJahiaNodeProperty> getProperties() {
        return this.getProperties(true, true, false);
    }

    public List<GWTJahiaNodeProperty> getProperties(boolean includeI18N, boolean includeNonI18N, boolean modifiedOnly) {
        return this.getProperties(includeI18N, includeNonI18N, modifiedOnly, false);
    }

    public List<GWTJahiaNodeProperty> getProperties(boolean includeI18N, boolean includeNonI18N, boolean modifiedOnly, boolean doNotCheckFieldsValues) {
        ArrayList<GWTJahiaNodeProperty> newProps = new ArrayList<GWTJahiaNodeProperty>();
        ArrayList<GWTJahiaNodeType> l = new ArrayList<GWTJahiaNodeType>(this.nodeTypes);
        if (this.mixin != null) {
            for (GWTJahiaNodeType type : this.mixin) {
                if (this.addedTypes.contains(type.getName())) {
                    l.add(type);
                }
                if (this.externalMixin.containsKey(type.getName())) {
                    l.add(type);
                }
                if (!this.removedTypes.contains(type.getName())) continue;
                l.remove(type);
            }
        }
        for (GWTJahiaNodeType nodeType : l) {
            ArrayList<GWTJahiaItemDefinition> allItems = new ArrayList<GWTJahiaItemDefinition>();
            if (this.viewInheritedItems) {
                allItems.addAll(nodeType.getInheritedItems());
            }
            allItems.addAll(nodeType.getItems());
            for (GWTJahiaItemDefinition definition : allItems) {
                boolean i18nProp;
                boolean bl = i18nProp = definition instanceof GWTJahiaPropertyDefinition && ((GWTJahiaPropertyDefinition)definition).isInternationalized();
                if ((!includeI18N || !i18nProp) && (!includeNonI18N || i18nProp) || (!definition.isHidden() && this.displayHiddenProperties || this.originalProperties.get(definition.getName()) == null) && this.dataType != null && !this.dataType.isEmpty() && !this.dataType.contains(definition.getDataType()) || definition.isProtected()) continue;
                PropertyAdapterField f = this.fields.get(definition.getName());
                GWTJahiaNodeProperty prop = this.currentProperties.get(definition.getName());
                if (doNotCheckFieldsValues || f == null || f.getValue() == null && f.getField().getEmptyText().equals(f.getField().getOriginalValue()) || !f.isDirty() && modifiedOnly && f.getData("addedField") == null && f.getData("defaultedField") == null) continue;
                Log.debug((String)("Set value for " + prop.getName()));
                prop.setValues(PropertiesEditor.getPropertyValues(f, definition));
                prop.setDirty(f.isDirty());
                if (f.isDirty()) {
                    f.setDirty(true);
                }
                newProps.add(prop);
            }
        }
        return newProps;
    }

    public Set<String> getAddedTypes() {
        return this.addedTypes;
    }

    public Set<String> getRemovedTypes() {
        return this.removedTypes;
    }

    public Set<String> getExternalMixin() {
        return this.externalMixin.keySet();
    }

    public List<GWTJahiaNodeType> getNodeTypes() {
        return this.nodeTypes;
    }

    public static List<GWTJahiaNodePropertyValue> getPropertyValues(Field<?> field, GWTJahiaItemDefinition itemDef) {
        ArrayList<GWTJahiaNodePropertyValue> values = new ArrayList<GWTJahiaNodePropertyValue>();
        Field<?> fld = field;
        if (field instanceof PropertyAdapterField) {
            fld = ((PropertyAdapterField)field).getField();
        }
        if (itemDef.isNode()) {
            if (fld instanceof ContentPickerField) {
                ContentPickerField pck = (ContentPickerField)fld;
                Object selection = pck.getValue();
                Iterator iterator = selection.iterator();
                while (iterator.hasNext()) {
                    GWTJahiaNode node = (GWTJahiaNode)iterator.next();
                    values.add(new GWTJahiaNodePropertyValue(node, 21));
                }
            } else {
                Object value = fld.getValue();
                if (value != null) {
                    values.add(new GWTJahiaNodePropertyValue(value.toString(), 20));
                }
            }
        } else {
            GWTJahiaPropertyDefinition propDef = (GWTJahiaPropertyDefinition)itemDef;
            if (fld instanceof DualListField) {
                List selection = ((DualListField)fld).getToList().getStore().getModels();
                for (GWTJahiaValueDisplayBean valueDisplayBean : selection) {
                    GWTJahiaNodePropertyValue propertyValue = PropertiesEditor.getPropertyValue(valueDisplayBean, propDef.getRequiredType());
                    if (propertyValue == null) continue;
                    values.add(propertyValue);
                }
            } else if (fld instanceof ContentPickerField) {
                ContentPickerField pck = (ContentPickerField)fld;
                Object selection = pck.getValue();
                Iterator valueDisplayBean = selection.iterator();
                while (valueDisplayBean.hasNext()) {
                    GWTJahiaNode node = (GWTJahiaNode)valueDisplayBean.next();
                    GWTJahiaNodePropertyValue propertyValue = new GWTJahiaNodePropertyValue(node, propDef.getRequiredType());
                    values.add(propertyValue);
                }
            } else if (fld instanceof MultipleTextField || fld instanceof MultipleNumberField || fld instanceof TagField) {
                List list = (List)fld.getValue();
                for (Object item : list) {
                    values.add(PropertiesEditor.getPropertyValue(item, propDef.getRequiredType()));
                }
            } else if (fld.getValue() != null) {
                values.add(PropertiesEditor.getPropertyValue(fld.getValue(), propDef.getRequiredType()));
            }
        }
        return values;
    }

    private static GWTJahiaNodePropertyValue getPropertyValue(Object fieldValue, int requiredType) {
        String propValueString = null;
        if (fieldValue != null) {
            propValueString = fieldValue instanceof Date ? String.valueOf(((Date)fieldValue).getTime()) : (fieldValue instanceof GWTJahiaValueDisplayBean ? ((GWTJahiaValueDisplayBean)fieldValue).getValue() : fieldValue.toString());
        }
        return new GWTJahiaNodePropertyValue(propValueString, requiredType);
    }

    public void copyToAllLanguages(GWTJahiaNodeProperty prop, Field<?> remoteField) {
    }

    public Map<String, PropertyAdapterField> getFieldsMap() {
        return this.fields;
    }

    public Map<String, FieldSet> getFieldSetsMap() {
        return this.fieldSets;
    }

    public GWTJahiaItemDefinition getGWTJahiaItemDefinition(GWTJahiaNodeProperty prop) {
        return this.getGWTJahiaItemDefinition(prop.getName());
    }

    public GWTJahiaItemDefinition getGWTJahiaItemDefinition(String propName) {
        return this.propertyDefinitions.get(propName);
    }

    public List<FieldSet> getOrderingListFieldSet() {
        return this.orderingListFieldSet;
    }

    public String toString() {
        return this.nodeTypes.toString();
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setTranslationSource(LangPropertiesEditor translationSource) {
        this.translationSource = translationSource;
    }

    public void setTranslationTarget(LangPropertiesEditor translationTarget) {
        this.translationTarget = translationTarget;
    }

    public class PropertyAdapterField
    extends AdapterField {
        private Field<?> field;
        private boolean dirty;
        private GWTJahiaItemDefinition definition;
        private LayoutContainer panel;
        private Field<?> remoteAdapterField;

        public PropertyAdapterField(final Field<?> field, final GWTJahiaItemDefinition definition, GWTJahiaNodeProperty property, final Field<?> remoteAdapterField) {
            super((Widget)new LayoutContainer());
            this.dirty = false;
            this.remoteAdapterField = remoteAdapterField;
            this.panel = (LayoutContainer)this.getWidget();
            if (PropertiesEditor.this.isMultipleEdit && !definition.isProtected()) {
                field.setEnabled(false);
                final CheckBox checkbox = new CheckBox();
                final Field<?> f = field;
                checkbox.addListener(Events.Change, (Listener)new Listener<ComponentEvent>(){

                    public void handleEvent(ComponentEvent event) {
                        if (checkbox.getValue().booleanValue()) {
                            Log.debug((String)"add ");
                            f.setEnabled(true);
                        } else {
                            Log.debug((String)"remove ");
                            f.setEnabled(false);
                        }
                    }
                });
                checkbox.setHideLabel(true);
                HBoxLayout hBoxLayout = new HBoxLayout();
                hBoxLayout.setHBoxLayoutAlign(HBoxLayout.HBoxLayoutAlign.MIDDLE);
                this.panel.setLayout((Layout)hBoxLayout);
                this.panel.add((Widget)checkbox, (LayoutData)new HBoxLayoutData());
                this.panel.add(field, (LayoutData)new HBoxLayoutData());
            } else {
                this.panel.addStyleName("mypanel");
                FlowLayout hBoxLayout = new FlowLayout();
                this.panel.setLayout((Layout)hBoxLayout);
                this.panel.add(field);
                field.setWidth("98%");
                if (PropertiesEditor.this.isWriteable && PropertiesEditor.this.viewCopyToAllLangs && JahiaGWTParameters.getSiteLanguages() != null && JahiaGWTParameters.getSiteLanguages().size() > 1 && definition.isInternationalized()) {
                    Button button = new Button(Messages.get("label.translate.copyall", "Copy to all languages"));
                    button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                        public void componentSelected(ButtonEvent ce) {
                            GWTJahiaNodeProperty prop = ((GWTJahiaNodeProperty)PropertiesEditor.this.currentProperties.get(definition.getName())).cloneObject();
                            prop.setValues(PropertiesEditor.getPropertyValues(field, definition));
                            final GWTJahiaNodeProperty prop2 = prop;
                            MessageBox.confirm((String)Messages.get("label.translate.copyall", "Copy to all languages"), (String)Messages.get("label.translate.copyall.confirm", "The field value in all the other languages will be replaced by this one, do you want to copy this content to all languages?"), (Listener)new Listener<MessageBoxEvent>(){

                                public void handleEvent(MessageBoxEvent be) {
                                    if ("yes".equalsIgnoreCase(be.getButtonClicked().getItemId())) {
                                        PropertiesEditor.this.copyToAllLanguages(prop2, remoteAdapterField);
                                        Info.display((String)Messages.get("label.translate.copyall", "Copy to all languages"), (String)Messages.get("label.translate.copyall.done"));
                                    }
                                }
                            });
                        }
                    });
                    button.addStyleName("button-copyall");
                    this.panel.add((Widget)button);
                }
                if (PropertiesEditor.this.isWriteable && PropertiesEditor.this.translationSource != null && JahiaGWTParameters.getSiteLanguages().size() > 1 && ((GWTJahiaPropertyDefinition)definition).getRequiredType() == 1 && definition.isInternationalized() && !definition.isHidden() && !definition.isProtected() && !((GWTJahiaPropertyDefinition)definition).isConstrained()) {
                    PropertiesEditor sourcePropertiesEditor = PropertiesEditor.this.translationSource.getPropertiesEditorByLang(PropertiesEditor.this.translationSource.getDisplayedLocale().getLanguage());
                    if (sourcePropertiesEditor != null) {
                        GWTJahiaNodeProperty sourceProperty = null;
                        for (GWTJahiaNodeProperty prop : sourcePropertiesEditor.getProperties(true, false, false)) {
                            if (!definition.getName().equals(prop.getName())) continue;
                            sourceProperty = prop;
                            break;
                        }
                        if (sourceProperty != null) {
                            Button suggestButton = new Button(Messages.get("label.translate.suggest", "Suggest translation"));
                            suggestButton.addStyleName("button-suggest");
                            final GWTJahiaNodeProperty finalSourceProperty = sourceProperty;
                            suggestButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                                public void componentSelected(ButtonEvent ce) {
                                    MessageBox.confirm((String)Messages.get("label.translate.suggest", "Suggest translation"), (String)Messages.get("label.translate.suggest.confirm", "Do you want to replace the content by an automatic translation of it?"), (Listener)new Listener<MessageBoxEvent>(){

                                        public void handleEvent(MessageBoxEvent be) {
                                            if ("yes".equalsIgnoreCase(be.getButtonClicked().getItemId())) {
                                                String destLanguage;
                                                String srcLanguage = PropertiesEditor.this.translationSource.getDisplayedLocale().getLanguage();
                                                int i = srcLanguage.indexOf("_");
                                                if (i > -1) {
                                                    srcLanguage = srcLanguage.substring(0, i);
                                                }
                                                if ((i = (destLanguage = PropertiesEditor.this.locale).indexOf("_")) > -1) {
                                                    destLanguage = destLanguage.substring(0, i);
                                                }
                                                JahiaContentManagementService.App.getInstance().translate(finalSourceProperty, definition, srcLanguage, destLanguage, JahiaGWTParameters.getSiteUUID(), (AsyncCallback<GWTJahiaNodeProperty>)new BaseAsyncCallback<GWTJahiaNodeProperty>(){

                                                    @Override
                                                    public void onApplicationFailure(Throwable throwable) {
                                                        Window.alert((String)(Messages.get("failure.property.translation", "Property translation failed") + "\n\n" + throwable.getMessage()));
                                                        Log.error((String)"Failed to translate property", (Throwable)throwable);
                                                    }

                                                    public void onSuccess(GWTJahiaNodeProperty newProp) {
                                                        Field<?> field = PropertiesEditor.this.getFieldsMap().get(definition.getName()).getField();
                                                        FormFieldCreator.copyValue(newProp, field);
                                                    }
                                                });
                                            }
                                        }
                                    });
                                }
                            });
                            this.panel.add((Widget)suggestButton);
                        }
                    } else {
                        PropertiesEditor.this.translationTarget.setNeedRefresh(true);
                    }
                }
            }
            this.field = field;
            this.definition = definition;
            this.setName(field.getName());
            this.setFieldLabel(field.getFieldLabel());
            this.setLabelSeparator(field.getLabelSeparator());
        }

        public Field<?> getField() {
            return this.field;
        }

        public GWTJahiaItemDefinition getDefinition() {
            return this.definition;
        }

        public Object getValue() {
            return this.field.getValue();
        }

        public boolean isDirty() {
            return this.dirty || this.field.isDirty();
        }

        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.field.setVisible(visible);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.field.setEnabled(enabled);
        }

        public void setWidth(final String width) {
            super.setWidth(width);
            DeferredCommand.addCommand((Command)new Command(){

                public void execute() {
                    PropertyAdapterField.this.field.setWidth(width);
                }
            });
        }

        public void addListener(EventType eventType, Listener<? extends BaseEvent> listener) {
            if (eventType == Events.Change) {
                this.field.addListener(eventType, listener);
            } else {
                super.addListener(eventType, listener);
            }
        }

        public <X> X getData(String key) {
            return (X)this.field.getData(key);
        }

        public void setData(String key, Object data) {
            this.field.setData(key, data);
        }
    }
}

