/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Header;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarMenu;
import org.jahia.ajax.gwt.client.util.icons.ToolbarIconProvider;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.toolbar.ActionToolbarMenu;
import org.jahia.ajax.gwt.client.widget.toolbar.action.ActionItem;

public class ToolbarHeader
extends Header {
    private HorizontalPanel horizontalPanel;
    private List<ActionItem> actionItems = new ArrayList<ActionItem>();
    private HorizontalPanel leftWidgetPanel;

    public ToolbarHeader() {
        this.setHeight("22");
        this.leftWidgetPanel = new HorizontalPanel();
        this.leftWidgetPanel.setVerticalAlign(Style.VerticalAlignment.MIDDLE);
        this.addStyleName("toolbar-header");
    }

    protected void onRender(Element target, int index) {
        super.onRender(target, index);
        this.leftWidgetPanel.addStyleName("x-panel-toolbar");
        this.leftWidgetPanel.addStyleName("toolbar-left-container");
        this.leftWidgetPanel.setLayoutOnChange(true);
        this.leftWidgetPanel.setStyleAttribute("float", "left");
        this.leftWidgetPanel.getAriaSupport().setPresentation(true);
        this.leftWidgetPanel.setVisible(true);
        this.leftWidgetPanel.render(this.getElement());
        this.getElement().insertFirst((Node)this.leftWidgetPanel.getElement());
    }

    public void removeAllTools() {
        if (this.horizontalPanel != null) {
            super.removeTool((Component)this.horizontalPanel);
            this.horizontalPanel = null;
        }
        if (this.leftWidgetPanel != null) {
            this.leftWidgetPanel.removeAll();
        }
        if (this.actionItems != null) {
            this.actionItems.clear();
        }
    }

    public void addTool(Component tool) {
        this.addTool(tool, false);
    }

    public void addTool(Component tool, boolean left) {
        if (left) {
            this.leftWidgetPanel.add((Widget)tool);
            this.leftWidgetPanel.layout();
        } else {
            if (this.horizontalPanel == null) {
                this.horizontalPanel = new HorizontalPanel();
                this.horizontalPanel.addStyleName("x-toolbar-header");
                this.horizontalPanel.addStyleName("toolbar-right-container");
                this.horizontalPanel.setVerticalAlign(Style.VerticalAlignment.MIDDLE);
            }
            this.horizontalPanel.add((Widget)tool);
            this.horizontalPanel.layout();
        }
    }

    public void removeTool(Component tool) {
        this.horizontalPanel.remove((Widget)tool);
        this.horizontalPanel.layout();
    }

    public void attachTools() {
        if (this.horizontalPanel != null && this.horizontalPanel.getParent() == null) {
            super.addTool((Component)this.horizontalPanel);
        }
    }

    public void addItem(Linker linker, GWTJahiaToolbarItem gwtToolbarItem) {
        boolean left = gwtToolbarItem.getProperties().get("position") != null && gwtToolbarItem.getProperties().get("position").getValue().equals("left");
        this.addItem(linker, gwtToolbarItem, left);
    }

    private void addItem(Linker linker, GWTJahiaToolbarItem gwtToolbarItem, boolean left) {
        if (gwtToolbarItem instanceof GWTJahiaToolbarMenu) {
            GWTJahiaToolbarMenu gwtToolbarMenu = (GWTJahiaToolbarMenu)gwtToolbarItem;
            ActionToolbarMenu menu = new ActionToolbarMenu(linker);
            menu.addStyleName("action-bar-menu");
            menu.addStyleName("menu-" + gwtToolbarMenu.getClassName());
            menu.setActionItems(this.actionItems);
            for (GWTJahiaToolbarItem subItem : gwtToolbarMenu.getGwtToolbarItems()) {
                menu.addItem(subItem);
            }
            Button menuToolItem = new Button(gwtToolbarMenu.getItemsGroupTitle());
            menuToolItem.addStyleName("action-bar-menu-item");
            gwtToolbarItem.addClasses((Component)menuToolItem);
            menuToolItem.setBorders(false);
            String minIconStyle = gwtToolbarMenu.getIcon();
            if (minIconStyle != null) {
                menuToolItem.setIcon(ToolbarIconProvider.getInstance().getIcon(minIconStyle));
            }
            menuToolItem.setMenu((Menu)menu);
            this.addTool((Component)menuToolItem, left);
        } else {
            ActionItem actionItem = gwtToolbarItem.getActionItem();
            this.actionItems.add(actionItem);
            if (actionItem != null) {
                actionItem.init(gwtToolbarItem, linker);
                if (actionItem.getCustomItem() != null) {
                    this.addTool(actionItem.getCustomItem(), left);
                } else {
                    this.addTool(actionItem.getTextToolItem(), left);
                }
            }
        }
    }

    public void handleNewLinkerSelection() {
        for (ActionItem item : this.actionItems) {
            try {
                item.handleNewLinkerSelection();
            }
            catch (Exception exception) {}
        }
    }

    public void handleNewMainNodeLoaded(GWTJahiaNode node) {
        for (ActionItem item : this.actionItems) {
            try {
                item.handleNewMainNodeLoaded(node);
            }
            catch (Exception exception) {}
        }
    }
}

