/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.mainarea;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.dnd.DragSource;
import com.extjs.gxt.ui.client.dnd.DropTarget;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.DNDEvent;
import com.extjs.gxt.ui.client.event.DNDListener;
import com.extjs.gxt.ui.client.event.DomEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.IconButtonEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Header;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.button.ToolButton;
import com.extjs.gxt.ui.client.widget.tips.ToolTipConfig;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaGetPropertiesResult;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTConfiguration;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementServiceAsync;
import org.jahia.ajax.gwt.client.util.icons.ContentModelIconProvider;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.contentengine.EditContentEnginePopupListener;
import org.jahia.ajax.gwt.client.widget.contentengine.TranslateContentEngine;
import org.jahia.ajax.gwt.client.widget.edit.ModuleSelectionListener;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.AreaModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.Hover;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.Module;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.ModuleDropTarget;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.ModuleHelper;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.SimpleModuleDragSource;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.TranslatableHighlight;

public class SimpleModule
extends Module {
    protected boolean hasDragDrop = true;
    protected boolean canHover = true;
    protected boolean editable = true;
    protected boolean addIconInHeader = true;
    protected boolean bindable = false;
    protected Boolean bound = null;
    private DragSource dragSource = null;
    private DropTarget dragTarget = null;
    private String boundProperty = "j:bindedComponent";
    private HTML placeholder;
    private TranslatableHighlight translatableHighlight;
    private Listener openEditEngineListener;
    private Listener openTranslateEngineListener;

    public SimpleModule(String id, String path, Element divElement, MainModule mainModule) {
        super(id, path, divElement, mainModule);
        this.editable = !"false".equals(DOM.getElementAttribute((Element)divElement, (String)"editable"));
        this.initializeListeners();
    }

    public SimpleModule(String id, String path, Element divElement, MainModule mainModule, boolean header) {
        super(id, path, divElement, mainModule);
        this.hasDragDrop = !"false".equals(DOM.getElementAttribute((Element)divElement, (String)"dragdrop")) && MainModule.getInstance().getDragAndDropBehavior() != GWTConfiguration.DragAndDropBehavior.NO_DRAG_IN_EDIT_AREA;
        this.editable = !"false".equals(DOM.getElementAttribute((Element)divElement, (String)"editable"));
        this.bindable = "true".equals(DOM.getElementAttribute((Element)divElement, (String)"bindable"));
        if ((header || this.bindable) && this.editable) {
            this.head = new Header();
            this.add((Component)this.head);
            this.setHeaderText(path.substring(path.lastIndexOf(47) + 1));
            this.head.addStyleName("x-panel-header");
            this.head.addStyleName("x-panel-header-simplemodule");
            this.setBorders(false);
        }
        this.html = new HTML(divElement.getInnerHTML());
        this.add((Widget)this.html);
        if (this.bindable && this.head != null) {
            this.head.addTool((Component)new ToolButton("x-tool-pin", (SelectionListener)new BindSelectionListener(mainModule)));
        }
        this.initializeListeners();
    }

    private void initializeListeners() {
        this.openEditEngineListener = new EditContentEnginePopupListener(this, this.mainModule.getEditLinker());
        final SimpleModule m = this;
        this.openTranslateEngineListener = new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent be) {
                if (!m.isSelectable() || MainModule.isGlobalSelectionDisabled()) {
                    return;
                }
                if (ModuleHelper.canUseComponentForEdit(ModuleHelper.getNodeType(m.getNode().getNodeTypes().get(0))) && PermissionsUtils.isPermitted("jcr:modifyProperties_" + JahiaGWTParameters.getWorkspace() + "_" + JahiaGWTParameters.getLanguage(), m.getNode().getPermissions())) {
                    new TranslateContentEngine(m.getNode(), SimpleModule.this.mainModule.getEditLinker(), JahiaGWTParameters.getLanguage(m.getTranslatableFromLanguage()), JahiaGWTParameters.getLanguage(JahiaGWTParameters.getLanguage())).show();
                }
            }
        };
    }

    @Override
    public void onParsed() {
        Log.debug((String)("Add drag source for simple module " + this.path));
        if (this.mainModule.getConfig().isDragAndDropEnabled()) {
            if (this.hasDragDrop) {
                this.dragSource = new SimpleModuleDragSource(this);
                this.dragSource.addDNDListener((DNDListener)this.mainModule.getEditLinker().getDndListener());
                if (this.mainModule.getDragAndDropBehavior() == GWTConfiguration.DragAndDropBehavior.DRAG_ZONE_IN_EDIT_AREA) {
                    this.dragSource.disable();
                }
                this.dragTarget = new ModuleDropTarget(this, "simpleModule");
                this.dragTarget.setAllowSelfAsSource(true);
                this.dragTarget.addDNDListener((DNDListener)this.mainModule.getEditLinker().getDndListener());
            } else {
                new DropTarget((Component)this){

                    protected void onDragEnter(DNDEvent event) {
                        event.getStatus().setStatus(false);
                    }
                };
            }
        }
        if (this.editable) {
            this.sinkEvents(262195);
            Listener<ComponentEvent> listener = new Listener<ComponentEvent>(){

                public void handleEvent(ComponentEvent ce) {
                    if (SimpleModule.this.selectable && !MainModule.isGlobalSelectionDisabled()) {
                        Log.info((String)("click" + SimpleModule.this.path + " : " + SimpleModule.this.scriptInfo));
                        SimpleModule.this.mainModule.setSelectable(false);
                        SimpleModule.this.mainModule.setCtrlActive((DomEvent)ce);
                        if (!ce.isRightClick() || !SimpleModule.this.mainModule.getSelections().containsKey((Object)SimpleModule.this)) {
                            SimpleModule.this.mainModule.getEditLinker().onModuleSelection(SimpleModule.this);
                        }
                    }
                }
            };
            this.addListener(Events.OnClick, (Listener)listener);
            this.addListener(Events.OnContextMenu, (Listener)listener);
            this.addListener(Events.OnDoubleClick, this.openEditEngineListener);
            Listener<ComponentEvent> hoverListener = new Listener<ComponentEvent>(){

                public void handleEvent(ComponentEvent ce) {
                    if (SimpleModule.this.canHover) {
                        Hover.getInstance().addHover(SimpleModule.this, ce);
                    }
                }
            };
            Listener<ComponentEvent> outListener = new Listener<ComponentEvent>(){

                public void handleEvent(ComponentEvent ce) {
                    Hover.getInstance().removeHover(SimpleModule.this);
                }
            };
            this.addListener(Events.OnMouseOver, (Listener)hoverListener);
            this.addListener(Events.OnMouseOut, (Listener)outListener);
        }
    }

    @Override
    public void setNode(GWTJahiaNode node) {
        super.setNode(node);
        if (node.isShared()) {
            this.setToolTip(new ToolTipConfig(Messages.get("info_important", "Important"), Messages.get("info_sharednode", "This is a shared node")));
        }
        if (this.head != null && this.addIconInHeader) {
            GWTJahiaNodeType nodeType = ModuleHelper.getNodeType(node.getNodeTypes().get(0));
            this.head.setIcon(ContentModelIconProvider.getInstance().getIcon(nodeType));
        }
        if (this.overlayLabel != null) {
            this.setStyleAttribute("position", "relative");
            this.insert((Widget)this.overlayLabel, 0);
            this.overlayLabel.setHeight(Integer.toString(this.html.getOffsetHeight()) + "px");
            this.overlayLabel.setWidth(Integer.toString(this.html.getOffsetWidth()) + "px");
            DOM.setStyleAttribute((Element)this.html.getElement(), (String)"opacity", (String)this.opacity);
            this.layout();
            if (this.head != null) {
                Text headerHtml = new Text(this.overlayLabel.getText());
                headerHtml.setStyleAttribute("color", this.overlayColorText);
                headerHtml.setStyleAttribute("font-weight", "bold");
                this.head.addTool((Component)headerHtml);
            }
        }
        if (this.bindable) {
            JahiaContentManagementServiceAsync async = JahiaContentManagementService.App.getInstance();
            async.getProperties(node.getPath(), null, (AsyncCallback<GWTJahiaGetPropertiesResult>)new BaseAsyncCallback<GWTJahiaGetPropertiesResult>(){

                public void onSuccess(GWTJahiaGetPropertiesResult gwtJahiaGetPropertiesResult) {
                    if (gwtJahiaGetPropertiesResult.getProperties().containsKey(SimpleModule.this.boundProperty)) {
                        GWTJahiaNodeProperty o = gwtJahiaGetPropertiesResult.getProperties().get(SimpleModule.this.boundProperty);
                        if (o.getValues().get(0).getNode().getPath().equals(SimpleModule.this.mainModule.getPath())) {
                            SimpleModule.this.setHeaderText(SimpleModule.this.headerText + " - Linked to: main resource");
                            SimpleModule.this.bound = Boolean.FALSE;
                        } else {
                            SimpleModule.this.setHeaderText(SimpleModule.this.headerText + " - Linked to: " + o.getValues().get(0).getNode().getName());
                            SimpleModule.this.bound = Boolean.TRUE;
                        }
                    } else {
                        SimpleModule.this.bound = Boolean.FALSE;
                        SimpleModule.this.setHeaderText(SimpleModule.this.head.getHtml() + " - Linked to: main resource");
                    }
                }
            });
        }
    }

    void showTranslatableModule() {
        if (this.translatableHighlight == null && this.getTranslatableFromLanguage() != null) {
            this.displayPlaceholder(this.getNode().getName(), Messages.get("notTranslated.label", "Not translated"), "gwt-translate-placeholder");
            this.translatableHighlight = new TranslatableHighlight(this);
            this.translatableHighlight.select();
            this.removeListener(Events.OnDoubleClick, this.openEditEngineListener);
            this.addListener(Events.OnDoubleClick, this.openTranslateEngineListener);
        }
    }

    void hideTranslatableModule() {
        if (this.translatableHighlight != null) {
            this.removePlaceholder();
            this.translatableHighlight.hide();
            this.translatableHighlight = null;
            this.removeListener(Events.OnDoubleClick, this.openTranslateEngineListener);
            this.addListener(Events.OnDoubleClick, this.openEditEngineListener);
        }
    }

    private void displayPlaceholder(String title, String subTitle, String placeholderClass) {
        if (this.html.getOffsetHeight() == 0) {
            this.placeholder = new HTML("<span class='gwt-placeholder-title'>" + title + "</span><br /><span class='gwt-placeholder-subTitle'>" + subTitle + "</span>");
            this.placeholder.setStyleName(placeholderClass);
            this.insert((Widget)this.placeholder, 0);
            this.layout();
        }
    }

    private void removePlaceholder() {
        if (this.placeholder != null) {
            this.remove((Widget)this.placeholder);
            this.placeholder = null;
            this.layout();
        }
    }

    public boolean hasDragDrop() {
        return this.hasDragDrop;
    }

    public void setDragEnabled(boolean dragEnabled) {
        if (this.dragSource != null) {
            if (dragEnabled) {
                this.dragSource.enable();
            } else {
                this.dragSource.disable();
            }
        }
    }

    private class BindSelectionListener
    extends SelectionListener<IconButtonEvent> {
        private final MainModule mainModule;

        public BindSelectionListener(MainModule mainModule) {
            this.mainModule = mainModule;
        }

        public void componentSelected(IconButtonEvent event) {
            if (SimpleModule.this.bound != null && SimpleModule.this.bound.booleanValue()) {
                ArrayList<GWTJahiaNodeProperty> properties = new ArrayList<GWTJahiaNodeProperty>();
                GWTJahiaNodeProperty gwtJahiaNodeProperty = new GWTJahiaNodeProperty(SimpleModule.this.boundProperty, new GWTJahiaNodePropertyValue((String)null, 10));
                properties.add(gwtJahiaNodeProperty);
                JahiaContentManagementService.App.getInstance().saveProperties(Arrays.asList(SimpleModule.this.node), properties, null, new BaseAsyncCallback<Object>(){

                    public void onSuccess(Object o) {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("refreshMain", true);
                        SimpleModule.this.getMainModule().getEditLinker().refresh(data);
                    }

                    @Override
                    public void onApplicationFailure(Throwable throwable) {
                        Window.alert((String)Messages.getWithArgs("label.gwt.error", "Error: {0}", new Object[]{throwable}));
                    }
                });
            } else {
                String s = JahiaGWTParameters.getContextPath();
                if (s.equals("/")) {
                    s = "";
                }
                this.mainModule.getInnerElement().getStyle().setProperty("cursor", "url('" + s + "/gwt/resources/images/xtheme-jahia/link.cur'), pointer");
                this.mainModule.getEditLinker().setSelectionListener(new ModuleSelectionListener(){

                    @Override
                    public void onModuleSelection(Module selection) {
                        GWTJahiaNodeProperty gwtJahiaNodeProperty;
                        BindSelectionListener.this.mainModule.getInnerElement().getStyle().setProperty("cursor", "");
                        BindSelectionListener.this.mainModule.getEditLinker().setSelectionListener(null);
                        ArrayList<GWTJahiaNodeProperty> properties = new ArrayList<GWTJahiaNodeProperty>();
                        if (selection.getNode() != null && selection.getNode() != SimpleModule.this.node) {
                            gwtJahiaNodeProperty = new GWTJahiaNodeProperty(SimpleModule.this.boundProperty, new GWTJahiaNodePropertyValue(selection.getNode(), 10));
                        } else if (selection instanceof AreaModule) {
                            String areaHolder = ((AreaModule)selection).getAreaHolder();
                            gwtJahiaNodeProperty = new GWTJahiaNodeProperty(SimpleModule.this.boundProperty, new GWTJahiaNodePropertyValue(areaHolder, 1));
                        } else {
                            return;
                        }
                        properties.add(gwtJahiaNodeProperty);
                        JahiaContentManagementService.App.getInstance().saveProperties(Arrays.asList(SimpleModule.this.node), properties, null, new BaseAsyncCallback<Object>(){

                            public void onSuccess(Object o) {
                                HashMap<String, Object> data = new HashMap<String, Object>();
                                data.put("refreshMain", true);
                                SimpleModule.this.getMainModule().getEditLinker().refresh(data);
                            }

                            @Override
                            public void onApplicationFailure(Throwable throwable) {
                                Window.alert((String)Messages.getWithArgs("label.gwt.error", "Error: {0}", new Object[]{throwable}));
                            }
                        });
                    }
                });
            }
        }
    }
}

