/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.sidepanel;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseListLoader;
import com.extjs.gxt.ui.client.data.DataProxy;
import com.extjs.gxt.ui.client.data.ListLoadResult;
import com.extjs.gxt.ui.client.data.ListLoader;
import com.extjs.gxt.ui.client.data.LoadEvent;
import com.extjs.gxt.ui.client.data.PagingLoadResult;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.LoadListener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.StoreSorter;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.VBoxLayoutData;
import com.extjs.gxt.ui.client.widget.selection.AbstractStoreSelectionModel;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.Comparator;
import java.util.List;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTSidePanelTab;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.Collator;
import org.jahia.ajax.gwt.client.widget.NodeColumnConfigList;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineLoader;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.ModuleHelper;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.BrowseTabItem;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.DisplayGridDragSource;

public class CategoryBrowseTabItem
extends BrowseTabItem {
    protected int limit = 500;
    protected transient LayoutContainer contentContainer;
    protected transient ListLoader<ListLoadResult<GWTJahiaNode>> listLoader;
    protected transient ListStore<GWTJahiaNode> contentStore;
    protected transient DisplayGridDragSource displayGridSource;
    protected transient Grid<GWTJahiaNode> grid;

    @Override
    public TabItem create(GWTSidePanelTab config) {
        super.create(config);
        this.contentContainer = new LayoutContainer();
        this.contentContainer.setBorders(true);
        this.contentContainer.setScrollMode(Style.Scroll.AUTO);
        this.contentContainer.setLayout((Layout)new FitLayout());
        RpcProxy<PagingLoadResult<GWTJahiaNode>> listProxy = new RpcProxy<PagingLoadResult<GWTJahiaNode>>(){

            protected void load(Object gwtJahiaCategory, AsyncCallback<PagingLoadResult<GWTJahiaNode>> listAsyncCallback) {
                if (gwtJahiaCategory != null) {
                    JahiaContentManagementService.App.getInstance().getNodesByCategory((GWTJahiaNode)gwtJahiaCategory, CategoryBrowseTabItem.this.limit, 0, listAsyncCallback);
                }
            }
        };
        this.listLoader = new BaseListLoader((DataProxy)listProxy);
        this.listLoader.addLoadListener(new LoadListener(){

            public void loaderLoad(LoadEvent le) {
                if (!le.isCancelled()) {
                    CategoryBrowseTabItem.this.contentContainer.unmask();
                }
            }
        });
        this.contentStore = new ListStore(this.listLoader);
        this.contentStore.setStoreSorter(new StoreSorter((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    return Collator.getInstance().localeCompare(s1, s2);
                }
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return 0;
            }
        }));
        NodeColumnConfigList displayColumns = new NodeColumnConfigList(config.getTableColumns(), true);
        this.grid = new Grid(this.contentStore, new ColumnModel((List)displayColumns));
        this.grid.setAutoExpandColumn(displayColumns.getAutoExpand());
        this.contentContainer.add(this.grid);
        this.tree.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaNode>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaNode> event) {
                CategoryBrowseTabItem.this.listLoader.load((Object)event.getSelectedItem());
                CategoryBrowseTabItem.this.contentContainer.mask(Messages.get("label.loading", "Loading..."), "x-mask-loading");
            }
        });
        this.grid.addListener(Events.OnDoubleClick, (Listener)new Listener<GridEvent<GWTJahiaNode>>(){

            public void handleEvent(GridEvent<GWTJahiaNode> baseEvent) {
                final GWTJahiaNode gwtJahiaNode = (GWTJahiaNode)baseEvent.getModel();
                if (gwtJahiaNode != null && CategoryBrowseTabItem.this.editLinker != null) {
                    ModuleHelper.checkCanUseComponentForEdit(gwtJahiaNode.getNodeTypes().get(0), new ModuleHelper.CanUseComponentForEditCallback(){

                        @Override
                        public void handle(boolean canUseComponentForEdit) {
                            if (canUseComponentForEdit) {
                                EngineLoader.showEditEngine(CategoryBrowseTabItem.this.editLinker, gwtJahiaNode, null);
                            }
                        }
                    });
                }
            }
        });
        this.tree.setContextMenu(this.createContextMenu(config.getTreeContextMenu(), (AbstractStoreSelectionModel<GWTJahiaNode>)this.tree.getSelectionModel()));
        this.grid.setContextMenu(this.createContextMenu(config.getTableContextMenu(), (AbstractStoreSelectionModel<GWTJahiaNode>)this.grid.getSelectionModel()));
        VBoxLayoutData contentVBoxData = new VBoxLayoutData();
        contentVBoxData.setFlex(2.0);
        this.tab.add((Widget)this.contentContainer, (LayoutData)contentVBoxData);
        this.tab.setId("JahiaGxtCategoryBrowseTab");
        return this.tab;
    }

    @Override
    public void initWithLinker(EditLinker linker) {
        super.initWithLinker(linker);
        if (linker.getConfig().isDragAndDropEnabled()) {
            this.displayGridSource = new DisplayGridDragSource(this.grid);
            this.displayGridSource.addDNDListener(this.editLinker.getDndListener());
        }
    }

    @Override
    protected boolean acceptNode(GWTJahiaNode node) {
        return node.getInheritedNodeTypes().contains("jnt:category");
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }
}

