/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.sidepanel;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionEvent;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridSelectionModel;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.VBoxLayoutData;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.selection.AbstractStoreSelectionModel;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGrid;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGridCellRenderer;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGridSelectionModel;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTSidePanelTab;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.BrowseTabItem;
import org.jahia.ajax.gwt.client.widget.toolbar.ActionToolbar;

public class ModulesTabItem
extends BrowseTabItem {
    private static final long serialVersionUID = 7656741991148114672L;
    protected transient ButtonBar buttonBar;
    protected transient LayoutContainer layoutContainer;
    protected transient ActionToolbar toolbar;

    @Override
    public TabItem create(GWTSidePanelTab config) {
        super.create(config);
        VBoxLayoutData treeVBoxData = new VBoxLayoutData();
        treeVBoxData.setFlex(0.0);
        this.layoutContainer = new LayoutContainer();
        this.layoutContainer.setHeight(24);
        this.tab.insert((Widget)this.layoutContainer, 0, (LayoutData)treeVBoxData);
        this.tree.setSelectionModel((GridSelectionModel)new TreeGridSelectionModel<GWTJahiaNode>(){

            protected void handleMouseClick(GridEvent<GWTJahiaNode> e) {
                super.handleMouseClick(e);
                if (!(((GWTJahiaNode)this.getSelectedItem()).getPath().equals(ModulesTabItem.this.editLinker.getMainModule().getPath()) || ((GWTJahiaNode)this.getSelectedItem()).getNodeTypes().contains("jnt:virtualsite") || ((GWTJahiaNode)this.getSelectedItem()).getNodeTypes().contains("jnt:folder") || ((GWTJahiaNode)this.getSelectedItem()).getInheritedNodeTypes().contains("jnt:folder") || ((GWTJahiaNode)this.getSelectedItem()).getNodeTypes().contains("jnt:templatesFolder"))) {
                    MainModule.staticGoTo(((GWTJahiaNode)this.getSelectedItem()).getPath(), null, "generic", "");
                }
            }
        });
        this.tree.getSelectionModel().setSelectionMode(Style.SelectionMode.SINGLE);
        final Menu contextMenu = this.createContextMenu(config.getTreeContextMenu(), (AbstractStoreSelectionModel<GWTJahiaNode>)this.tree.getSelectionModel());
        this.tree.setContextMenu(contextMenu);
        this.tree.getColumnModel().getColumn(0).setRenderer((GridCellRenderer)new TreeGridCellRenderer<GWTJahiaNode>(){

            protected String getText(TreeGrid<GWTJahiaNode> gwtJahiaNodeTreeGrid, GWTJahiaNode node, String property, int rowIndex, int colIndex) {
                String v = super.getText(gwtJahiaNodeTreeGrid, (ModelData)node, property, rowIndex, colIndex);
                if (v != null) {
                    v = SafeHtmlUtils.htmlEscape((String)v);
                }
                String classes = "";
                if (node.isMarkedForDeletion()) {
                    classes = classes + "markedForDeletion ";
                }
                if (node.getNodeTypes().contains("jmix:moduleImportFile")) {
                    classes = classes + "notPublished ";
                }
                if (!PermissionsUtils.isPermitted("editModeAccess", JahiaGWTParameters.getSiteNode()) && !PermissionsUtils.isPermitted("jcr:write_default", node)) {
                    classes = classes + "accessForbidden ";
                }
                if (classes.length() > 0) {
                    v = "<span class=\"" + classes + "\">" + v + "</span>";
                }
                return v;
            }
        });
        this.tree.getSelectionModel().addListener(Events.BeforeSelect, (Listener)new Listener<SelectionEvent<GWTJahiaNode>>(){

            public void handleEvent(SelectionEvent<GWTJahiaNode> be) {
                if (((GWTJahiaNode)be.getModel()).getNodeTypes().contains("jmix:moduleImportFile")) {
                    ModulesTabItem.this.tree.setContextMenu(null);
                    be.setCancelled(true);
                } else {
                    ModulesTabItem.this.tree.setContextMenu(contextMenu);
                    contextMenu.show();
                }
            }
        });
        return this.tab;
    }

    @Override
    public void initWithLinker(EditLinker linker) {
        super.initWithLinker(linker);
        this.toolbar = new ActionToolbar(this.config.getTableContextMenu(), linker);
        this.toolbar.createToolBar();
        this.layoutContainer.add((Widget)this.toolbar);
        this.tab.remove((Widget)this.layoutContainer);
        VBoxLayoutData treeVBoxData = new VBoxLayoutData();
        treeVBoxData.setFlex(0.0);
        this.tab.insert((Widget)this.layoutContainer, 0, (LayoutData)treeVBoxData);
        this.checkIfCurrentNodeIsModule();
    }

    @Override
    public void handleNewMainSelection(String path) {
        super.handleNewMainSelection(path);
        this.toolbar.handleNewLinkerSelection();
    }

    @Override
    public void handleNewMainNodeLoaded(GWTJahiaNode node) {
        GWTJahiaNode siteNode = JahiaGWTParameters.getSiteNode();
        if (siteNode.get("j:sourcesFolder") != null) {
            super.handleNewMainNodeLoaded(node);
        }
        this.toolbar.handleNewMainNodeLoaded(node);
    }

    @Override
    public boolean needRefresh(Map<String, Object> data) {
        data.put("refreshMain", true);
        if (data.containsKey("node")) {
            GWTJahiaNode node = (GWTJahiaNode)data.get("node");
            List<String> inheritedNodeTypes = node.getInheritedNodeTypes();
            List<String> nodeTypes = node.getNodeTypes();
            if (inheritedNodeTypes.contains("jnt:editableFile") || nodeTypes.contains("jnt:editableFile") || nodeTypes.contains("jnt:definitionFile") || inheritedNodeTypes.contains("jnt:nodeType") || nodeTypes.contains("jnt:resourceBundleFile") || nodeTypes.contains("jnt:folder") || nodeTypes.contains("jnt:file")) {
                return true;
            }
        }
        if (data.containsKey("event") && ("commit".equals(data.get("event")) || "update".equals(data.get("event"))) || data.containsKey("mainDeleted") && ((Boolean)data.get("mainDeleted")).booleanValue()) {
            return true;
        }
        return super.needRefresh(data);
    }

    @Override
    public void markForAutoRefresh(Map<String, Object> data) {
        this.checkIfCurrentNodeIsModule();
        super.markForAutoRefresh(data);
    }

    @Override
    public void doRefresh() {
        List<String> selectedPath = this.factory.getSelectedPath();
        this.factory.getStore().removeAll();
        this.factory.setSelectedPath(selectedPath);
        if (this.checkIfCurrentNodeIsModule()) {
            this.factory.getStore().getLoader().load();
        }
    }

    private boolean checkIfCurrentNodeIsModule() {
        GWTJahiaNode siteNode = JahiaGWTParameters.getSiteNode();
        if (siteNode.get("j:sourcesFolder") == null) {
            ((TabPanel)this.tab.getParent()).mask();
        } else {
            ((TabPanel)this.tab.getParent()).unmask();
        }
        return siteNode.get("j:sourcesFolder") != null;
    }

    @Override
    protected boolean acceptNode(GWTJahiaNode node) {
        return true;
    }
}

